/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.core.Pair;
import net.refractions.udig.core.filter.AdaptingFilter;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectElement;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.edit.DeleteManyFeaturesCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.UDIGGenericAction;
import net.refractions.udig.project.ui.commands.DrawCommandFactory;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.UDIGEditorInputDescriptor;
import net.refractions.udig.project.ui.internal.commands.draw.DrawFeatureCommand;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class Delete
extends UDIGGenericAction {
    private boolean runSync = false;
    private boolean canDeleteProjectElements;

    public Delete(boolean canDeleteProjectElements) {
        this.canDeleteProjectElements = canDeleteProjectElements;
    }

    @Override
    public void run(IAction action) {
        Pair<Boolean, Integer> stateData;
        ISelection sel = this.getSelection();
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        ArrayList<Layer> layers = new ArrayList<Layer>(selection.size());
        Object firstElem = selection.iterator().next();
        if (this.canDeleteProjectElements && firstElem instanceof Project) {
            stateData = this.showErrorMessage(selection.size(), (Project)firstElem);
        } else if (this.canDeleteProjectElements && firstElem instanceof IProjectElement) {
            stateData = this.showErrorMessage(selection.size(), (ProjectElement)firstElem);
        } else if (firstElem instanceof Layer) {
            stateData = this.showErrorMessage(selection.size(), (Layer)firstElem);
        } else if (firstElem instanceof SimpleFeature) {
            stateData = this.showErrorMessage(selection.size(), (SimpleFeature)firstElem);
        } else if (firstElem instanceof AdaptingFilter) {
            AdaptingFilter f = (AdaptingFilter)firstElem;
            ILayer layer = (ILayer)f.getAdapter(ILayer.class);
            stateData = this.showErrorMessage(selection.size(), layer, f);
        } else {
            stateData = null;
        }
        if (stateData == null || (Integer)stateData.getRight() == 1) {
            return;
        }
        for (Object element : selection) {
            if (this.canDeleteProjectElements && element instanceof Project) {
                this.operate((Project)element, stateData);
                continue;
            }
            if (this.canDeleteProjectElements && element instanceof IProjectElement) {
                this.operate((ProjectElement)element, stateData);
                continue;
            }
            if (element instanceof Layer) {
                layers.add((Layer)element);
                continue;
            }
            if (element instanceof SimpleFeature) {
                this.operate((SimpleFeature)element, stateData);
                continue;
            }
            if (!(element instanceof AdaptingFilter)) continue;
            AdaptingFilter f = (AdaptingFilter)element;
            ILayer layer = (ILayer)f.getAdapter(ILayer.class);
            this.operate(layer, f, stateData);
        }
        if (!layers.isEmpty()) {
            this.operate(layers.toArray(new Layer[layers.size()]), stateData);
        }
    }

    protected void operate(Layer layer) {
        if (layer == null || layer.getMap() == null) {
            return;
        }
        UndoableMapCommand command = EditCommandFactory.getInstance().createDeleteLayers(new ILayer[]{layer});
        this.executeCommand((MapCommand)command, (IMap)layer.getMapInternal());
    }

    @Override
    protected void operate(Layer[] layers, Object context) {
        Pair pair = (Pair)context;
        if (pair == null || (Integer)pair.right() == 1) {
            return;
        }
        if (layers != null && layers.length > 0) {
            HashMap distributor = new HashMap();
            Layer[] layerArray = layers;
            int n = layers.length;
            int n2 = 0;
            while (n2 < n) {
                Layer layer = layerArray[n2];
                IMap map = layer.getMap();
                if (distributor.containsKey(map)) {
                    ((List)distributor.get(map)).add(layer);
                } else {
                    ArrayList<Layer> list = new ArrayList<Layer>();
                    list.add(layer);
                    distributor.put(map, list);
                }
                ++n2;
            }
            for (Map.Entry entry : distributor.entrySet()) {
                IMap map = (IMap)entry.getKey();
                Layer[] removedLayers = ((List)entry.getValue()).toArray(new Layer[0]);
                UndoableMapCommand command = EditCommandFactory.getInstance().createDeleteLayers((ILayer[])removedLayers);
                this.executeCommand((MapCommand)command, map);
            }
        }
    }

    void executeCommand(MapCommand command, IMap map) {
        if (this.runSync) {
            map.sendCommandSync(command);
        } else {
            map.sendCommandASync(command);
        }
    }

    @Override
    protected void operate(ProjectElement element, Object context) {
        if (element == null) {
            return;
        }
        Pair pair = (Pair)context;
        if (pair == null || (Integer)pair.right() == 1) {
            return;
        }
        boolean deleteFiles = (Boolean)pair.left();
        int returnCode = (Integer)pair.right();
        this.doDelete(element, deleteFiles, returnCode);
    }

    protected Pair<Boolean, Integer> showErrorMessage(int size, ILayer layer, AdaptingFilter firstElement) {
        return new Pair((Object)false, (Object)0);
    }

    protected Pair<Boolean, Integer> showErrorMessage(int size, Layer firstElement) {
        return new Pair((Object)false, (Object)0);
    }

    protected Pair<Boolean, Integer> showErrorMessage(int size, SimpleFeature firstElement) {
        return new Pair((Object)false, (Object)0);
    }

    protected Pair<Boolean, Integer> showErrorMessage(int size, ProjectElement element) {
        String deleteOne = Messages.Delete_deleteElement;
        String name = element.getName();
        String deleteMany = Messages.Delete_deleteMultipleElements;
        return this.dialog(size, deleteOne, name, deleteMany);
    }

    protected Pair<Boolean, Integer> showErrorMessage(int size, Project element) {
        String deleteOne = Messages.Delete_deleteProject;
        String name = element.getName();
        String deleteMany = Messages.Delete_deleteMultipleProjects;
        return this.dialog(size, deleteOne, name, deleteMany);
    }

    private Pair<Boolean, Integer> dialog(int size, String deleteOne, String name, String deleteMany) {
        String message = size == 1 ? MessageFormat.format(deleteOne, name) : MessageFormat.format(deleteMany, size);
        boolean delete = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.Delete_delete, (String)message);
        boolean deleteFiles = false;
        if (delete) {
            if (deleteFiles != this.getDoDelete()) {
                this.setDoDelete(deleteFiles);
            }
            return Pair.create((Object)deleteFiles, (Object)0);
        }
        return Pair.create(null, (Object)1);
    }

    @Override
    protected void operate(ILayer layer, AdaptingFilter filter, Object context) {
        Pair pair = (Pair)context;
        if (pair == null || (Integer)pair.right() == 1) {
            return;
        }
        layer.getMap().sendCommandASync((MapCommand)new DeleteManyFeaturesCommand(layer, (Filter)filter));
    }

    protected final void doDelete(ProjectElement element, boolean deleteFiles, int returncode) {
        if (returncode != 1) {
            for (UDIGEditorInputDescriptor desc : ApplicationGIS.getEditorInputs((IProjectElement)element)) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = page.findEditor((IEditorInput)desc.createInput((IProjectElement)element));
                if (editor == null) continue;
                page.closeEditor(editor, false);
            }
            List elements = element.getElements(ProjectElement.class);
            for (ProjectElement projectElement : elements) {
                this.doDelete(projectElement, deleteFiles, returncode);
            }
            Project projectInternal = element.getProjectInternal();
            if (projectInternal != null) {
                projectInternal.getElementsInternal().remove(element);
            } else {
                Project project = this.findProject(element);
                if (project != null) {
                    project.getElementsInternal().remove(element);
                }
            }
            Resource resource = element.eResource();
            if (resource != null) {
                resource.getContents().remove((Object)element);
                resource.unload();
            }
            if (deleteFiles) {
                try {
                    if (resource == null) {
                        return;
                    }
                    String path = resource.getURI().toFileString();
                    resource.unload();
                    int lastIndexOf = path.lastIndexOf(47);
                    if (lastIndexOf == -1) {
                        lastIndexOf = path.length();
                    }
                    path = path.substring(0, lastIndexOf);
                    File file = new File(path);
                    this.deleteFile(file);
                }
                catch (Exception e) {
                    ProjectUIPlugin.log("Error deleting project element file", e);
                }
            }
        }
    }

    private Project findProject(ProjectElement element) {
        List<? extends Project> projects = ApplicationGISInternal.getProjects();
        for (Project project : projects) {
            if (!project.getElements().contains(element)) continue;
            return project;
        }
        return null;
    }

    @Override
    protected void operate(Project project, Object context) {
        if (project == null || context == null) {
            return;
        }
        Pair pair = (Pair)context;
        boolean deleteFiles = (Boolean)pair.left();
        int returnCode = (Integer)pair.right();
        this.doDelete(project, deleteFiles, returnCode);
    }

    protected final void doDelete(Project project, boolean deleteProjectFiles, int returncode) {
        if (returncode != 1) {
            Resource resource = project.eResource();
            if (!deleteProjectFiles) {
                try {
                    resource.save(null);
                    resource.getContents().remove((Object)project);
                }
                catch (IOException e) {
                    ProjectUIPlugin.log(null, e);
                }
            }
            ArrayList toRemove = new ArrayList();
            toRemove.addAll(project.getElementsInternal());
            boolean oldrunSyn = this.runSync;
            this.runSync = true;
            for (ProjectElement element : toRemove) {
                this.doDelete(element, deleteProjectFiles, returncode);
            }
            this.runSync = oldrunSyn;
            resource.setModified(false);
            if (ApplicationGIS.getActiveProject() == project) {
                ProjectPlugin.getPlugin().getProjectRegistry().setCurrentProject(null);
            }
            ProjectPlugin.getPlugin().getProjectRegistry().getProjects().remove(project);
            resource.getContents().clear();
            ResourceSet resourceSet = resource.getResourceSet();
            String path = resource.getURI().toFileString();
            resource.unload();
            if (deleteProjectFiles) {
                try {
                    resourceSet.getResources().remove((Object)resource);
                    resource.unload();
                    int lastIndexOf = path.lastIndexOf(47);
                    if (lastIndexOf == -1) {
                        lastIndexOf = path.length();
                    }
                    path = path.substring(0, lastIndexOf);
                    File file = new File(path);
                    this.deleteFile(file);
                }
                catch (Exception e) {
                    ProjectUIPlugin.log("Error deleting project file", e);
                }
            }
        }
    }

    private void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                this.deleteFile(file2);
                ++n2;
            }
        }
        file.delete();
    }

    @Override
    protected void operate(final SimpleFeature feature, Object c) {
        IAdaptable adaptableFeature = null;
        if (feature instanceof IAdaptable) {
            adaptableFeature = (IAdaptable)feature;
        }
        if (adaptableFeature == null) {
            adaptableFeature = (IAdaptable)Platform.getAdapterManager().getAdapter((Object)feature, IAdaptable.class);
        }
        if (adaptableFeature == null) {
            return;
        }
        final Layer layer = (Layer)adaptableFeature.getAdapter(Layer.class);
        DrawFeatureCommand command = DrawCommandFactory.getInstance().createDrawFeatureCommand(feature, (ILayer)layer);
        ViewportPane pane = (ViewportPane)layer.getMapInternal().getRenderManager().getMapDisplay();
        pane.addDrawCommand(command);
        PlatformGIS.syncInDisplayThread((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean result = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.DeleteFeature_confirmation_title, (String)Messages.DeleteFeature_confirmation_text);
                if (result) {
                    UndoableMapCommand c = EditCommandFactory.getInstance().createDeleteFeature(feature, (ILayer)layer);
                    Delete.this.executeCommand((MapCommand)c, layer.getMap());
                }
            }
        });
        command.setValid(false);
        pane.repaint();
    }

    public void setRunSync(boolean runSync) {
        this.runSync = runSync;
    }

    private boolean getDoDelete() {
        return ProjectPlugin.getPlugin().getPreferenceStore().getBoolean("P_PROJECT_DELETE_FILES");
    }

    private void setDoDelete(boolean deleteFiles) {
        ProjectPlugin.getPlugin().getPreferenceStore().setValue("P_PROJECT_DELETE_FILES", deleteFiles);
    }
}

