/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.commands.OpenProjectElementCommand;
import net.refractions.udig.project.ui.internal.LayersView;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.IDropHandlerListener;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.EditorPart;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class StartupOpenMaps
implements IStartup {
    private String[] args = Platform.getApplicationArgs();

    public void earlyStartup() {
        ArrayList<URL> urls = new ArrayList<URL>(this.args.length);
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                String string;
                String urlString = string = stringArray[n2];
                try {
                    if (urlString.startsWith("-")) break block13;
                    if (!urlString.contains(":/")) {
                        File file = new File(urlString);
                        if (!file.exists()) break block13;
                        urlString = file.toURL().toString();
                    }
                    if (urlString.startsWith("file:/")) {
                        try {
                            new URL(urlString);
                        }
                        catch (IOException iOException) {
                            File file;
                            String tmp = urlString.substring(5);
                            if (tmp.contains(":")) {
                                tmp = tmp.substring(tmp.indexOf(":"));
                            }
                            if (!(file = new File(tmp)).exists()) break block13;
                        }
                    }
                    urls.add(new URL(urlString));
                    {
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++n2;
        }
        if (!urls.isEmpty()) {
            final ArrayList<URL> finalurls = urls;
            String title = Messages.StartupOpenMaps_openURLDialogTitle;
            IRunnableWithProgress openMapRunnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    StartupOpenMaps.this.dropURLS(finalurls, monitor);
                }
            };
            PlatformGIS.runInProgressDialog((String)title, (boolean)true, (IRunnableWithProgress)openMapRunnable, (boolean)true);
        } else {
            IPreferenceStore p = ProjectUIPlugin.getDefault().getPreferenceStore();
            boolean proceed = p.getBoolean("openMapsOnStartup");
            if (!proceed) {
                return;
            }
            int numEditors = p.getInt("net.refractions.udig.project.ui.mapEditor");
            if (numEditors == 0) {
                return;
            }
            String title = Messages.StartupOpenMaps_openMapDialogTitle;
            IRunnableWithProgress openMapRunnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    StartupOpenMaps.this.openLastOpenMaps(monitor);
                }
            };
            PlatformGIS.runInProgressDialog((String)title, (boolean)true, (IRunnableWithProgress)openMapRunnable, (boolean)true);
        }
    }

    private void openLastOpenMaps(IProgressMonitor monitor) {
        IPreferenceStore p = ProjectUIPlugin.getDefault().getPreferenceStore();
        int numEditors = p.getInt("net.refractions.udig.project.ui.mapEditor");
        monitor.beginTask(Messages.StartupOpenMaps_openMapDialogTitle, numEditors * 2 + 2);
        p.setValue("net.refractions.udig.project.ui.mapEditor", 0);
        int i = 0;
        while (i < numEditors) {
            monitor.worked(1);
            String id = "net.refractions.udig.project.ui.mapEditor:" + i;
            String name = p.getString(id);
            if (name != null && !name.equals("")) {
                p.setValue(id, "");
                if (!monitor.isCanceled()) {
                    monitor.setTaskName(String.valueOf(Messages.StartupOpenMaps_loadingTask) + name);
                    URI mapResourceURI = URI.createURI((String)name);
                    Resource resource = ProjectPlugin.getPlugin().getProjectRegistry().eResource().getResourceSet().getResource(mapResourceURI, true);
                    monitor.worked(1);
                    try {
                        CRS.decode((String)"EPSG:4326");
                    }
                    catch (NoSuchAuthorityCodeException e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                    catch (FactoryException e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                    Object object = resource.getContents().get(0);
                    if (object instanceof IProjectElement) {
                        OpenProjectElementCommand command = new OpenProjectElementCommand((IProjectElement)object);
                        monitor.setTaskName(String.valueOf(Messages.StartupOpenMaps_OpenTask) + ": " + ((IProjectElement)object).getName());
                        ApplicationGIS.getActiveProject().sendASync((Command)command);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dropURLS(List<URL> urls, IProgressMonitor monitor) {
        ProcessingURLSListener listener;
        monitor.beginTask(Messages.StartupOpenMaps_openURLDialogTitle, urls.size() * 1 + 2);
        monitor.worked(1);
        Viewer viewer = LayersView.getViewer();
        if (viewer == null) {
            ProjectUIPlugin.trace(this.getClass(), "Layers View is not available", null);
        }
        UDIGDropHandler dropHandler = new UDIGDropHandler();
        dropHandler.setTarget((Object)new EditorPart(){

            public void doSave(IProgressMonitor monitor) {
            }

            public void doSaveAs() {
            }

            public void init(IEditorSite site, IEditorInput input) throws PartInitException {
            }

            public boolean isDirty() {
                return false;
            }

            public boolean isSaveAsAllowed() {
                return false;
            }

            public void createPartControl(Composite parent) {
            }

            public void setFocus() {
            }
        });
        this.closeIntro();
        Iterator<URL> iterator = urls.iterator();
        block10: while (true) {
            if (!iterator.hasNext()) {
                return;
            }
            URL url = iterator.next();
            monitor.worked(1);
            monitor.setTaskName(String.valueOf(Messages.StartupOpenMaps_processingTask) + ": " + url);
            if (monitor.isCanceled()) {
                return;
            }
            listener = new ProcessingURLSListener(this);
            dropHandler.addListener((IDropHandlerListener)listener);
            dropHandler.performDrop((Object)url, null);
            while (true) {
                if (listener.processed || monitor.isCanceled()) continue block10;
                StartupOpenMaps startupOpenMaps = this;
                synchronized (startupOpenMaps) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 10, 11] lbl31 : MonitorExitStatement: MONITOREXIT : var8_8
                        dropHandler.removeListener((IDropHandlerListener)listener);
                        return;
                    }
                    {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 10, 11] lbl37 : MonitorExitStatement: MONITOREXIT : var8_8
                        continue;
                    }
                }
                break;
            }
            break;
        }
        finally {
            dropHandler.removeListener((IDropHandlerListener)listener);
        }
    }

    private void closeIntro() {
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
                IIntroPart intro = introManager.getIntro();
                if (intro != null) {
                    introManager.closeIntro(intro);
                }
            }
        });
    }

    public void testingSetArgs(String[] strings) {
        if (strings == null) {
            this.args = new String[0];
        } else {
            this.args = new String[strings.length];
            System.arraycopy(strings, 0, this.args, 0, this.args.length);
        }
    }

    private static class ProcessingURLSListener
    implements IDropHandlerListener {
        volatile boolean processed = false;
        StartupOpenMaps lock;

        public ProcessingURLSListener(StartupOpenMaps maps) {
            this.lock = maps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IDropAction action, Throwable t) {
            this.processed = true;
            StartupOpenMaps startupOpenMaps = this.lock;
            synchronized (startupOpenMaps) {
                this.lock.notify();
            }
        }

        public void starting(IDropAction action) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noAction(Object data) {
            this.processed = true;
            StartupOpenMaps startupOpenMaps = this.lock;
            synchronized (startupOpenMaps) {
                this.lock.notify();
            }
        }
    }
}

