/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import net.refractions.udig.catalog.ITransientResolve;
import net.refractions.udig.catalog.ui.export.ExportResourceSelectionState;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.ui.internal.MapEditorWithPalette;
import net.refractions.udig.project.ui.internal.MapPaletteSaveStrategy;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

class SaveMapPaletteRunnable
implements Runnable {
    private final MapEditorWithPalette mapEditor;
    private final boolean[] success;

    public SaveMapPaletteRunnable(MapEditorWithPalette mapEditor, boolean[] success) {
        this.mapEditor = mapEditor;
        this.success = success;
    }

    @Override
    public void run() {
        try {
            EditManager editManagerInternal = this.mapEditor.getMap().getEditManagerInternal();
            Result result = this.saveTemporaryLayers();
            if (result == Result.NO_TEMP_LAYERS) {
                editManagerInternal.commitTransaction();
                this.success[0] = true;
            } else {
                this.success[0] = false;
            }
        }
        catch (IOException e) {
            ProjectUIPlugin.log("Error saving", e);
            this.success[0] = false;
        }
    }

    private Result saveTemporaryLayers() {
        ArrayList resources = new ArrayList();
        for (ILayer layer : this.mapEditor.getMap().getMapLayers()) {
            if (!layer.hasResource(ITransientResolve.class)) continue;
            resources.addAll(layer.getGeoResources());
        }
        if (resources.isEmpty()) {
            return Result.NO_TEMP_LAYERS;
        }
        StructuredSelection selection = new StructuredSelection(resources);
        ExportResourceSelectionState layerState = new ExportResourceSelectionState((ISelection)selection);
        MapPaletteSaveStrategy exp = new MapPaletteSaveStrategy(layerState, this.mapEditor);
        exp.open();
        return Result.EXPORT_WIZARD_RUNNING;
    }

    private static enum Result {
        NO_TEMP_LAYERS,
        EXPORT_WIZARD_RUNNING;

    }
}

