/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

class ReplaceableSelectionProvider
implements ISelectionProvider {
    private static final ISelection EMPTY = new ISelection(){

        public boolean isEmpty() {
            return true;
        }
    };
    private Set<ISelectionChangedListener> listeners = new CopyOnWriteArraySet<ISelectionChangedListener>();
    private ISelectionProvider wrapped;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() != ReplaceableSelectionProvider.this.wrapped) {
                event.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            ReplaceableSelectionProvider.this.notifyChange(event.getSelection());
        }
    };

    ReplaceableSelectionProvider() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.wrapped != null) {
            return this.wrapped.getSelection();
        }
        return EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.wrapped != null) {
            this.wrapped.setSelection(selection);
        }
    }

    public void setProvider(ISelectionProvider newProvider) {
        if (this.wrapped != null) {
            this.wrapped.removeSelectionChangedListener(this.listener);
        }
        newProvider.addSelectionChangedListener(this.listener);
        this.wrapped = newProvider;
        if (newProvider.getSelection() != null) {
            this.notifyChange(newProvider.getSelection());
        }
    }

    private void notifyChange(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(event);
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.wrapped;
    }
}

