/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.ContextModelListenerAdapter;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.MultiLayerRenderer;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderListenerAdapter;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.RenderManagerImpl;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.RenderManagerDynamic;
import net.refractions.udig.project.ui.internal.TiledRenderManagerDynamic;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.geotools.data.FeatureEvent;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class RenderManagerAdapters {
    static Adapter createViewportListener(final RenderManagerImpl manager) {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                manager.checkState();
                switch (msg.getFeatureID(ViewportModel.class)) {
                    case 1: {
                        if (ApplicationGIS.getActiveMap() == null || !ApplicationGIS.getVisibleMaps().contains(ApplicationGIS.getActiveMap())) break;
                        this.refreshDirtyArea(msg);
                        break;
                    }
                    case 0: {
                        manager.refresh(null);
                        break;
                    }
                    case 11: {
                        manager.refresh(null);
                        break;
                    }
                    case 13: {
                        manager.refresh(null);
                    }
                }
            }

            private void refreshDirtyArea(Notification msg) {
                manager.refresh(null);
            }
        };
    }

    static Adapter createViewportListener(final TiledRenderManagerDynamic manager) {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                manager.checkState();
                switch (msg.getFeatureID(ViewportModel.class)) {
                    case 1: {
                        manager.viewportChanged(msg);
                        break;
                    }
                    case 0: {
                        manager.crsChanged(msg);
                    }
                }
            }
        };
    }

    static ContextModelListenerAdapter createContextModelListener(final RenderManagerDynamic manager) {
        return new ContextModelListenerAdapter(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
            }

            protected void zorderChanged(Notification msg) {
                RenderManagerAdapters.synchronizeAndRefresh(msg, manager);
                this.updateImage();
            }

            protected void layerAdded(Notification msg) {
                RenderManagerAdapters.synchronizeAndRefresh(msg, manager);
                this.updateImage();
            }

            protected void layerRemoved(Notification msg) {
                RenderManagerAdapters.synchronizeAndRefresh(msg, manager);
                manager.validateRendererConfiguration();
                this.updateImage();
            }

            protected void manyLayersAdded(Notification msg) {
                RenderManagerAdapters.synchronizeAndRefresh(msg, manager);
                this.updateImage();
            }

            protected void manyLayersRemoved(Notification msg) {
                RenderManagerAdapters.synchronizeAndRefresh(msg, manager);
                manager.validateRendererConfiguration();
                this.updateImage();
            }

            public void updateImage() {
                try {
                    ((MultiLayerRenderer)manager.getRenderExecutor().getRenderer()).refreshImage();
                }
                catch (RenderException e) {
                    e.printStackTrace();
                }
                ((ViewportPane)manager.getMapDisplay()).renderDone();
            }
        };
    }

    private static void synchronizeAndRefresh(Notification msg, RenderManagerDynamic manager) {
        List<Layer> toRender = RenderManagerAdapters.synchronizeRenderers(msg, manager.configuration, manager.getRendererCreator());
        for (Layer layer : toRender) {
            layer.refresh(null);
        }
    }

    public static List<Layer> synchronizeRenderers(Notification msg, Collection<RenderContext> configuration, RendererCreator rendererCreator) {
        HashMap<RenderContext, RenderContext> oldToCopy = new HashMap<RenderContext, RenderContext>();
        Collection configuration2 = configuration;
        if (configuration2 != null) {
            for (RenderContext context : configuration2) {
                oldToCopy.put(context, context.copy());
            }
        }
        rendererCreator.changed(msg);
        configuration2 = rendererCreator.getConfiguration();
        ArrayList<Layer> toRender = new ArrayList<Layer>();
        for (RenderContext newcontext : configuration2) {
            if (!oldToCopy.containsKey(newcontext) && !(newcontext.getLayer() instanceof SelectionLayer)) {
                toRender.add(newcontext.getLayerInternal());
                continue;
            }
            if (newcontext instanceof CompositeRenderContext) {
                ArrayList oldLayers = new ArrayList(((CompositeRenderContext)oldToCopy.get(newcontext)).getLayersInternal());
                for (Layer layer : ((CompositeRenderContext)newcontext).getLayersInternal()) {
                    if (!oldLayers.contains(layer)) {
                        toRender.add(newcontext.getLayerInternal());
                        break;
                    }
                    oldLayers.remove(layer);
                }
                if (!oldLayers.isEmpty()) {
                    toRender.add(newcontext.getLayerInternal());
                }
            }
            oldToCopy.remove(newcontext);
        }
        return toRender;
    }

    static Adapter createViewportModelChangeListener(final RenderManagerImpl manager, final Adapter viewportListener, final ContextModelListenerAdapter contextModelListener) {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                manager.checkState();
                switch (msg.getFeatureID(RenderManager.class)) {
                    case 3: {
                        if (msg.getOldValue() != null) {
                            ((ViewportModel)msg.getOldValue()).eAdapters().remove((Object)viewportListener);
                        }
                        if (msg.getNewValue() == null) break;
                        ((ViewportModel)msg.getNewValue()).eAdapters().add((Object)viewportListener);
                        break;
                    }
                    case 2: {
                        if (msg.getOldValue() != null) {
                            ((Map)msg.getOldValue()).getContextModel().eAdapters().remove((Object)contextModelListener);
                        }
                        if (msg.getNewValue() == null) break;
                        ((Map)msg.getNewValue()).getContextModel().eAdapters().add((Object)contextModelListener);
                    }
                }
            }
        };
    }

    static Adapter createLayerListener(final RenderManagerDynamic manager) {
        return new AdapterImpl(){

            public void notifyChanged(Notification event) {
                manager.checkState();
                if (event.getNotifier() instanceof Map) {
                    if (2 == event.getFeatureID(Map.class)) {
                        if (event.getOldValue() != null) {
                            ((ContextModel)event.getOldValue()).removeDeepAdapter((Adapter)this);
                        }
                        if (event.getNewValue() != null) {
                            ((ContextModel)event.getNewValue()).addDeepAdapter((Adapter)this);
                        }
                    }
                } else if (event.getNotifier() instanceof Layer) {
                    switch (event.getFeatureID(Layer.class)) {
                        case 1: {
                            this.filterChanged(manager, event);
                            break;
                        }
                        case 2: {
                            RenderManagerAdapters.synchronizeRenderers(event, manager.configuration, manager.getRendererCreator());
                            if ((ILayer)event.getNotifier() instanceof SelectionLayer) {
                                return;
                            }
                            manager.refresh((ILayer)event.getNotifier(), null);
                            break;
                        }
                        case 11: {
                            if (event.getOldValue() != null && event.getOldValue().equals(event.getNewValue())) break;
                            ((Layer)event.getNotifier()).refresh(null);
                            break;
                        }
                        case 15: {
                            FeatureEvent featureEvent = (FeatureEvent)event.getNewValue();
                            if (featureEvent == null) break;
                            this.featureEvent(manager, event, featureEvent);
                            break;
                        }
                    }
                }
            }

            private void featureEvent(RenderManagerDynamic manager2, Notification event, FeatureEvent featureEvent) {
                ReferencedEnvelope refreshBounds = null;
                ILayer refreshLayer = null;
                if (ProjectPlugin.getPlugin().getPluginPreferences().getBoolean("P_FEATURE_EVENT_REFRESH_ALL")) {
                    ILayer notifier = (ILayer)event.getNotifier();
                    ReferencedEnvelope viewportBounds = notifier.getMap().getViewportModel().getBounds();
                    refreshLayer = notifier;
                    refreshBounds = viewportBounds;
                } else {
                    ReferencedEnvelope delta = featureEvent.getBounds();
                    if (delta != null) {
                        ILayer notifier = (ILayer)event.getNotifier();
                        if (delta.isNull()) {
                            manager2.refresh(notifier, null);
                        } else {
                            try {
                                MathTransform layerToMapTransform = notifier.layerToMapTransform();
                                Envelope mapDelta = new Envelope();
                                if (layerToMapTransform.isIdentity()) {
                                    mapDelta = delta;
                                } else {
                                    JTS.transform((Envelope)delta, (Envelope)mapDelta, (MathTransform)layerToMapTransform, (int)10);
                                }
                                CoordinateReferenceSystem mapCRS = notifier.getMap().getViewportModel().getCRS();
                                ReferencedEnvelope bounds = new ReferencedEnvelope(mapDelta, mapCRS);
                                bounds.expandBy(bounds.getWidth() * 0.2, bounds.getHeight() * 0.2);
                                refreshBounds = bounds;
                                refreshLayer = notifier;
                            }
                            catch (IOException e) {
                                ProjectPlugin.log((String)"", (Throwable)e);
                            }
                            catch (TransformException e) {
                                ProjectPlugin.log((String)"", (Throwable)e);
                            }
                        }
                    }
                }
                if (refreshLayer != null && refreshLayer.isVisible() && refreshBounds != null) {
                    manager2.refresh(refreshLayer, (Envelope)refreshBounds);
                }
            }

            private void filterChanged(RenderManagerDynamic manager2, Notification event) {
                if (!event.getOldValue().equals(event.getNewValue())) {
                    Filter newFilter = (Filter)event.getNewValue();
                    if (Filter.EXCLUDE.equals(newFilter)) {
                        manager2.clearSelection((ILayer)((Layer)event.getNotifier()));
                    } else {
                        manager2.refreshSelection((ILayer)((Layer)event.getNotifier()), null);
                    }
                }
            }
        };
    }

    static RenderExecutorListener getRenderExecutorListener(RenderManager manager) {
        return new RenderExecutorListener(manager);
    }

    static Adapter createLayerListener(final TiledRenderManagerDynamic manager) {
        return new AdapterImpl(){

            public void notifyChanged(Notification event) {
                manager.checkState();
                if (event.getNotifier() instanceof Map) {
                    if (2 == event.getFeatureID(Map.class)) {
                        if (event.getOldValue() != null) {
                            ((ContextModel)event.getOldValue()).removeDeepAdapter((Adapter)this);
                        }
                        if (event.getNewValue() != null) {
                            ((ContextModel)event.getNewValue()).addDeepAdapter((Adapter)this);
                        }
                    }
                } else if (event.getNotifier() instanceof Layer) {
                    switch (event.getFeatureID(Layer.class)) {
                        case 1: {
                            this.filterChanged(manager, event);
                            break;
                        }
                        case 2: {
                            Layer layer = (Layer)event.getNotifier();
                            manager.blackBoardChanged(layer);
                            break;
                        }
                        case 11: {
                            if (event.getOldValue() != null && event.getOldValue().equals(event.getNewValue())) break;
                            ((Layer)event.getNotifier()).refresh(null);
                            break;
                        }
                        case 15: {
                            FeatureEvent featureEvent = (FeatureEvent)event.getNewValue();
                            if (featureEvent == null) break;
                            this.featureEvent(manager, event, featureEvent);
                            break;
                        }
                    }
                }
            }

            private void featureEvent(TiledRenderManagerDynamic manager2, Notification event, FeatureEvent featureEvent) {
                ReferencedEnvelope refreshBounds = null;
                ILayer refreshLayer = null;
                if (ProjectPlugin.getPlugin().getPluginPreferences().getBoolean("P_FEATURE_EVENT_REFRESH_ALL")) {
                    ILayer notifier = (ILayer)event.getNotifier();
                    ReferencedEnvelope viewportBounds = notifier.getMap().getViewportModel().getBounds();
                    refreshLayer = notifier;
                    refreshBounds = viewportBounds;
                } else {
                    ReferencedEnvelope delta = featureEvent.getBounds();
                    if (delta != null) {
                        ILayer notifier = (ILayer)event.getNotifier();
                        if (delta.isNull()) {
                            manager2.refresh(notifier, null);
                        } else {
                            try {
                                MathTransform layerToMapTransform = notifier.layerToMapTransform();
                                Envelope mapDelta = new Envelope();
                                if (layerToMapTransform.isIdentity()) {
                                    mapDelta = delta;
                                } else {
                                    JTS.transform((Envelope)delta, (Envelope)mapDelta, (MathTransform)layerToMapTransform, (int)10);
                                }
                                CoordinateReferenceSystem mapCRS = notifier.getMap().getViewportModel().getCRS();
                                ReferencedEnvelope bounds = new ReferencedEnvelope(mapDelta, mapCRS);
                                bounds.expandBy(bounds.getWidth() * 0.2, bounds.getHeight() * 0.2);
                                refreshBounds = bounds;
                                refreshLayer = notifier;
                            }
                            catch (IOException e) {
                                ProjectPlugin.log((String)"", (Throwable)e);
                            }
                            catch (TransformException e) {
                                ProjectPlugin.log((String)"", (Throwable)e);
                            }
                        }
                    }
                }
                if (refreshLayer != null && refreshLayer.isVisible() && refreshBounds != null) {
                    manager2.refresh(refreshLayer, (Envelope)refreshBounds);
                }
            }

            private void filterChanged(TiledRenderManagerDynamic manager2, Notification event) {
                if (!event.getOldValue().equals(event.getNewValue())) {
                    Filter newFilter = (Filter)event.getNewValue();
                    if (Filter.EXCLUDE.equals(newFilter)) {
                        manager2.clearSelection((ILayer)((Layer)event.getNotifier()));
                    } else {
                        manager2.refreshSelection((ILayer)((Layer)event.getNotifier()), null);
                    }
                }
            }
        };
    }

    static Adapter createVisibilityChangedAdapater(final TiledRenderManagerDynamic manager) {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getNotifier() instanceof Layer && msg.getFeatureID(Layer.class) == 8 && msg.getNewBooleanValue() != msg.getOldBooleanValue()) {
                    manager.layerMadeVisible((Layer)msg.getNotifier());
                }
            }
        };
    }

    static ContextModelListenerAdapter createContextModelListener(final TiledRenderManagerDynamic manager) {
        return new ContextModelListenerAdapter(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
            }

            protected void zorderChanged(Notification msg) {
                manager.zorderChanged(msg);
            }

            protected void layerAdded(Notification msg) {
                manager.layersAdded(msg);
            }

            protected void layerRemoved(Notification msg) {
                manager.layersRemoved(msg);
            }

            protected void manyLayersAdded(Notification msg) {
                manager.layersAdded(msg);
            }

            protected void manyLayersRemoved(Notification msg) {
                manager.layersRemoved(msg);
            }
        };
    }

    static class RenderExecutorListener
    extends RenderListenerAdapter {
        private RenderManager manager;

        public RenderExecutorListener(RenderManager manager) {
            this.manager = manager;
        }

        protected void renderStarting() {
            ((ViewportPane)this.manager.getMapDisplay()).renderStarting();
        }

        protected void renderUpdate() {
            ((ViewportPane)this.manager.getMapDisplay()).renderUpdate();
        }

        protected void renderDone() {
            ((ViewportPane)this.manager.getMapDisplay()).renderDone();
        }
    }
}

