/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.core.AbstractUdigUIPlugin;
import net.refractions.udig.project.ui.feature.FeaturePanelProcessor;
import net.refractions.udig.project.ui.internal.ActiveMapTracker;
import net.refractions.udig.project.ui.internal.FeatureEditorExtensionProcessor;
import net.refractions.udig.project.ui.internal.LayerGeneratedGlyphDecorator;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.osgi.framework.BundleContext;

public class ProjectUIPlugin
extends AbstractUdigUIPlugin {
    public static final int DEFAULT_DOUBLECLICK_SPEED_MILLIS = 1000;
    private static final String ICONS_PATH = "icons/";
    public static final String ID = "net.refractions.udig.project.ui";
    public static final String PREF_OPEN_DIALOG_DIRECTORY = "udig.preferences.openDialog.lastDirectory";
    public static final int MAX_RESOURCES_IN_SERVICE = 1;
    private static ProjectUIPlugin INSTANCE;
    List<AdapterFactory> adapterFactories;
    private static final String ADAPTER_FACTORIES_ID = "net.refractions.udig.project.ui.itemProviderAdapterFactories";
    public static final String MOUSE_SPEED_KEY = "MOUSE_SPEED_KEY";
    private PropertySheetPage propertySheetPage;
    FeatureEditorExtensionProcessor featureEditProcessor = null;
    FeaturePanelProcessor featurePanelProcessor = null;
    Object mutex = new Object();
    private AdapterFactory adapterFactory;

    public ProjectUIPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        new ActiveMapTracker().startup();
    }

    public static ProjectUIPlugin getDefault() {
        return INSTANCE;
    }

    public List<AdapterFactory> getAdapterFactories() {
        if (this.adapterFactories == null) {
            this.adapterFactories = new ArrayList<AdapterFactory>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(ADAPTER_FACTORIES_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        Object adapterFactory = elements[j].createExecutableExtension("class");
                        if (adapterFactory instanceof AdapterFactory) {
                            this.adapterFactories.add((AdapterFactory)adapterFactory);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(this.adapterFactories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            Object object = this.mutex;
            synchronized (object) {
                this.propertySheetPage = new PropertySheetPage(){

                    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                        super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    }

                    public void setActionBars(IActionBars actionBars) {
                        super.setActionBars(actionBars);
                    }
                };
                this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
            }
        }
        return this.propertySheetPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            Object object = this.mutex;
            synchronized (object) {
                ArrayList<Object> factories = new ArrayList<Object>();
                factories.addAll(ProjectUIPlugin.getDefault().getAdapterFactories());
                factories.add(new ReflectiveItemProviderAdapterFactory());
                this.adapterFactory = new ComposedAdapterFactory(factories);
            }
        }
        return this.adapterFactory;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.featureEditProcessor != null) {
            this.featureEditProcessor.stopPartListener();
        }
        if (LayerGeneratedGlyphDecorator.getInstance() != null) {
            LayerGeneratedGlyphDecorator.getInstance().dispose();
        }
        super.stop(context);
    }

    public FeatureEditorExtensionProcessor getFeatureEditProcessor() {
        if (this.featureEditProcessor == null) {
            this.featureEditProcessor = new FeatureEditorExtensionProcessor();
            this.featureEditProcessor.startPartListener();
        }
        return this.featureEditProcessor;
    }

    public FeaturePanelProcessor getFeaturePanelProcessor() {
        if (this.featurePanelProcessor == null) {
            this.featurePanelProcessor = new FeaturePanelProcessor();
        }
        return this.featurePanelProcessor;
    }

    public static void log(String message2, Throwable e) {
        String message = message2;
        if (message == null) {
            message = String.valueOf(Messages.ProjectUIPlugin_error) + e;
        }
        ProjectUIPlugin.getDefault().getLog().log((IStatus)new Status(1, ID, 0, message, e));
    }

    private static void trace(String message, Throwable e) {
        if (ProjectUIPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace(System.out);
            }
        }
    }

    public static void trace(String traceID, Class caller, String message, Throwable e) {
        if (ProjectUIPlugin.isDebugging(traceID)) {
            ProjectUIPlugin.trace(caller, message, e);
        }
    }

    public static void trace(Class caller, String message, Throwable e) {
        ProjectUIPlugin.trace(String.valueOf(caller.getSimpleName()) + ": " + message, e);
    }

    public static boolean isDebugging(String trace) {
        return ProjectUIPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public int getDoubleClickSpeed() {
        IPreferenceStore store = ProjectUIPlugin.getDefault().getPreferenceStore();
        int mouseSpeed = store.getInt(MOUSE_SPEED_KEY);
        if (mouseSpeed == 0) {
            mouseSpeed = 1000;
        }
        return mouseSpeed;
    }

    public IPath getIconPath() {
        return new Path(ICONS_PATH);
    }
}

