/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.ui.internal.MapFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;

public class ProjectExplorerDropAdapter
extends ViewerDropAdapter {
    protected ProjectExplorerDropAdapter(Viewer viewer) {
        super(viewer);
    }

    public boolean performDrop(Object data) {
        List<Layer> layers = this.getLayers(data);
        if (this.getCurrentLocation() == 3 && this.getCurrentTarget() instanceof Map) {
            Map map = (Map)this.getCurrentTarget();
            if (map.getContextModel().getLayers().containsAll(layers)) {
                return false;
            }
            this.copyToMap(map, layers);
        }
        if (this.getCurrentLocation() == 3 && this.getCurrentTarget() instanceof Project) {
            this.createNewMap((Project)this.getCurrentTarget(), layers);
        }
        return true;
    }

    private void createNewMap(Project project, List<Layer> layers) {
        MapFactory.instance().process(project, layers, true);
    }

    private void copyToMap(Map map, List<Layer> layers) {
        Collection clonedLayers = EcoreUtil.copyAll(layers);
        map.getContextModel().getLayers().addAll(clonedLayers);
    }

    private List<Layer> getLayers(Object data) {
        ArrayList<Object> resources = new ArrayList<Object>();
        if (data instanceof String || data instanceof String[]) {
            if (data instanceof String) {
                resources.addAll(CorePlugin.stringsToURLs((String)((String)data)));
            } else {
                resources.addAll(CorePlugin.stringsToURLs((String[])((String[])data)));
            }
        } else if (data instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)data;
            resources.addAll(selection.toList());
        } else {
            resources.add(data);
        }
        return MapFactory.instance().processResources(null, resources);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return true;
    }
}

