/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.PaletteCombo;
import net.refractions.udig.project.ui.internal.PaletteDefaultChooserPanel;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.styling.Style;

public class PalettePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    PaletteDefaultChooserPanel panel = new PaletteDefaultChooserPanel();
    private Map map;

    public PalettePropertyPage() {
        this.setTitle(Messages.PalettePropertyPage_Title);
    }

    public void setElement(IAdaptable element) {
        Map map = element instanceof Map ? (Map)element : (Map)element.getAdapter(Map.class);
        this.map = map;
    }

    protected Control createContents(Composite parent) {
        Control c = this.panel.createPaletteDefaultChooserPanel(parent, this.map);
        return c;
    }

    public boolean performOk() {
        ArrayList<PaletteCombo> allLayerColourControls = this.panel.getAllLayerControls();
        this.map.setColourScheme(this.panel.getCurrentColourScheme());
        this.map.setColorPalette(this.panel.getCurrentColourScheme().getColourPalette());
        Iterator<PaletteCombo> iterator = allLayerColourControls.iterator();
        boolean needsrefresh = false;
        while (iterator.hasNext()) {
            Style style;
            PaletteCombo combo = iterator.next();
            Layer l = combo.layerReference;
            Button checkbox = combo.getCheckbox();
            if (!checkbox.getSelection()) continue;
            Combo colourLetterCombo = combo.getColourLetterCombo();
            String[] letters = colourLetterCombo.getItems();
            int index = colourLetterCombo.getSelectionIndex();
            Color colour = null;
            if (index >= 0) {
                colour = this.map.getColorPalette().getColors(letters.length)[index];
                l.setDefaultColor(colour);
            }
            if ((style = (Style)l.getStyleBlackboard().get("net.refractions.udig.style.sld")) != null) {
                SLDs.setLineColour((Style)style, (Color)colour);
                SLDs.setPointColour((Style)style, (Color)colour);
                SLDs.setPolyColour((Style)style, (Color)colour);
            }
            l.setStyleBlackboard(l.getStyleBlackboard());
            needsrefresh = true;
        }
        Color newColor = this.panel.getMapBackgroundColor();
        boolean changed = this.updateMapBackgroundColor(newColor);
        if (changed || needsrefresh) {
            this.map.getRenderManager().refresh(null);
        }
        return super.performOk();
    }

    private boolean updateMapBackgroundColor(Color newColor) {
        Color oldColor = (Color)this.map.getBlackboard().get("mapBackgroundColor");
        if (!oldColor.equals(newColor)) {
            this.map.getBlackboard().put("mapBackgroundColor", (Object)newColor);
            return true;
        }
        return false;
    }

    protected void performDefaults() {
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        RGB background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"backgroundColor");
        Color defaultColor = new Color(background.red, background.green, background.blue);
        this.updateMapBackgroundColor(defaultColor);
        this.panel.updateMapBackgroundColor(defaultColor);
        String defaultPalette = ProjectPlugin.getPlugin().getPreferenceStore().getString("defaultPalette");
        this.panel.updatePalette(defaultPalette);
        super.performDefaults();
    }

    protected Point doComputeSize() {
        return new Point(500, 500);
    }

    public void init(IWorkbench workbench) {
    }

    public IPreferenceStore getPreferenceStore() {
        return ProjectUIPlugin.getDefault().getPreferenceStore();
    }
}

