/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.HashMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.ui.palette.ColourScheme;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PaletteCombo {
    Point fExtent = null;
    Composite composite = null;
    Combo colourLetterCombo = null;
    Button colourIndicatorButton = null;
    Image image = null;
    Button checkbox = null;
    Layer layerReference = null;
    Color swtColour = null;

    public PaletteCombo(Composite parent) {
        this.composite = parent;
        this.fExtent = this.computeImageSize((Control)this.composite);
        this.image = new Image((Device)parent.getDisplay(), this.fExtent.x, this.fExtent.y);
    }

    public Control getPaletteCombo(Layer layer) {
        this.layerReference = layer;
        String layerName = layer.getName();
        ColourScheme layerScheme = layer.getColourScheme();
        ColourScheme mapScheme = layer.getMapInternal().getColourScheme();
        final ColourScheme currentScheme = layerScheme != null && !layerScheme.equals((Object)mapScheme) ? layerScheme : mapScheme;
        String[] colourLetters = this.getColourLetters(currentScheme);
        int currentColourIndex = layer.getMapInternal().getMapLayers().indexOf(layer);
        this.layerReference = layer;
        Label layerLabel = new Label(this.composite, 0);
        layerLabel.setText(String.valueOf(layerName) + ":");
        GridData data = new GridData();
        data.horizontalSpan = 1;
        layerLabel.setLayoutData((Object)data);
        this.colourIndicatorButton = new Button(this.composite, 0x820000);
        this.updateButtonColourDisplay(currentScheme, currentColourIndex);
        data = new GridData();
        this.colourIndicatorButton.setLayoutData((Object)data);
        this.colourLetterCombo = new Combo(this.composite, 12);
        this.colourLetterCombo.setItems(colourLetters);
        this.colourLetterCombo.select(currentColourIndex);
        this.colourLetterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectIndex = PaletteCombo.this.colourLetterCombo.getSelectionIndex();
                PaletteCombo.this.updateButtonColourDisplay(currentScheme, selectIndex);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData();
        this.colourLetterCombo.setLayoutData((Object)data);
        this.checkbox = new Button(this.composite, 32);
        this.checkbox.setSelection(true);
        data = new GridData();
        this.checkbox.setLayoutData((Object)data);
        return this.composite;
    }

    public void dispose() {
        if (this.composite != null) {
            Control[] kids = this.composite.getChildren();
            int i = 0;
            while (i < kids.length) {
                Image img;
                Control c = kids[i];
                if (c instanceof Button && (img = ((Button)c).getImage()) != null) {
                    img.dispose();
                    ((Button)c).getImage().dispose();
                }
                c.dispose();
                ++i;
            }
        }
        this.fExtent = null;
        this.composite = null;
        this.colourLetterCombo = null;
        this.colourIndicatorButton = null;
        this.image = null;
        this.checkbox = null;
        this.layerReference = null;
    }

    public void updateContents(ColourScheme scheme) {
        int index = this.colourLetterCombo.getSelectionIndex();
        String[] colourLetters = this.getColourLetters(scheme);
        this.colourLetterCombo.setItems(colourLetters);
        if (index == -1) {
            index = colourLetters.length - 1;
        }
        this.colourLetterCombo.select(index);
        this.updateButtonColourDisplay(scheme, index);
    }

    protected void updateButtonColourDisplay(ColourScheme scheme, int index) {
        GC gc = new GC((Drawable)this.image);
        gc.drawRectangle(0, 2, this.fExtent.x, this.fExtent.y);
        if (this.swtColour != null) {
            this.swtColour.dispose();
        }
        java.awt.Color clr = scheme.getColour(index);
        this.swtColour = new Color((Device)this.composite.getDisplay(), new RGB(clr.getRed(), clr.getGreen(), clr.getBlue()));
        gc.setBackground(this.swtColour);
        gc.fillRectangle(0, 2, this.fExtent.x, this.fExtent.y);
        gc.dispose();
        this.colourIndicatorButton.setImage(this.image);
    }

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }

    public Combo getColourLetterCombo() {
        return this.colourLetterCombo;
    }

    public Button getCheckbox() {
        return this.checkbox;
    }

    private String[] getColourLetters(ColourScheme scheme) {
        int size = scheme.getSizePalette();
        String[] allColourLetters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        int[] colourIndex = scheme.getColourPalette().getColorScheme().getSampleScheme(size);
        String[] colourLetters = new String[size];
        if (scheme.getSizeScheme() < size) {
            scheme.setSizeScheme(size);
        }
        HashMap colourMap = scheme.getColourMap();
        int i = 0;
        while (i < size) {
            int schemeIndex = (Integer)colourMap.get(i);
            int actualIndex = colourIndex[schemeIndex];
            colourLetters[i] = allColourLetters[actualIndex];
            ++i;
        }
        return colourLetters;
    }
}

