/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapToolEntry;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import net.refractions.udig.project.ui.internal.tool.display.ModalToolCategory;
import net.refractions.udig.project.ui.tool.IToolManager;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.preference.IPreferenceStore;

public class MapToolPaletteFactory {
    private static final String PREFIX = "MapToolPaletteFactory.";
    private static final String PALETTE_DOCK_LOCATION = "MapToolPaletteFactory.Location";
    private static final String PALETTE_STATE = "MapToolPaletteFactory.State";
    private static final String PALETTE_SIZE = "MapToolPaletteFactory.Size";
    private static final int DEFAULT_PALETTE_SIZE = 125;
    private static final String DEFAULT_ID = "net.refractions.udig.tools.Zoom";

    public static PaletteRoot createPalette() {
        PaletteRoot root = new PaletteRoot();
        IToolManager toolManager = ApplicationGIS.getToolManager();
        ArrayList<PaletteToolbar> categories = new ArrayList<PaletteToolbar>();
        PaletteToolbar navigation = new PaletteToolbar("Navigation");
        navigation.setUserModificationPermission(1);
        for (ModalToolCategory category : toolManager.getModalToolCategories()) {
            PaletteToolbar container;
            String shortcut = MapToolPaletteFactory.shortcut(category.getName());
            String name = MapToolPaletteFactory.fixLabel(category.getName());
            if (category.getId().equals("net.refractions.udig.tool.category.zoom") || category.getId().equals("net.refractions.udig.tool.category.pan")) {
                container = navigation;
            } else {
                PaletteDrawer drawer = new PaletteDrawer(name);
                drawer.setId(category.getId());
                if (category == toolManager.getActiveCategory()) {
                    drawer.setInitialState(0);
                } else {
                    drawer.setInitialState(1);
                }
                drawer.setDrawerType(ToolEntry.PALETTE_TYPE_TOOL);
                drawer.setUserModificationPermission(1);
                drawer.setShowDefaultIcon(false);
                if (shortcut != null) {
                    drawer.setDescription("(" + shortcut + ")");
                }
                container = drawer;
            }
            category.container((PaletteContainer)container);
            for (ModalItem modalItem : category) {
                String label = MapToolPaletteFactory.fixLabel(modalItem.getName());
                String keypress = MapToolPaletteFactory.shortcut(modalItem.getName());
                MapToolEntry tool = new MapToolEntry(label, modalItem, keypress, category.getId());
                if (modalItem.getId().equals(DEFAULT_ID)) {
                    root.setDefaultEntry((ToolEntry)tool);
                }
                container.add((PaletteEntry)tool);
            }
            if (container == navigation) continue;
            categories.add(container);
        }
        Comparator<PaletteContainer> sorter = new Comparator<PaletteContainer>(){
            List<String> preferredOrder = Arrays.asList("net.refractions.udig.tool.category.zoom", "net.refractions.udig.tool.category.pan", "net.refractions.udig.tool.category.info", "net.refractions.udig.tool.category.selection");

            int order(String id) {
                int index = this.preferredOrder.indexOf(id);
                if ("Other".equals(id)) {
                    return -2;
                }
                if (index == -1) {
                    return -1;
                }
                return 100 - index;
            }

            @Override
            public int compare(PaletteContainer o1, PaletteContainer o2) {
                int order2;
                String s1 = o1.getId();
                String s2 = o2.getId();
                int order1 = this.order(s1);
                if (order1 == (order2 = this.order(s2))) {
                    return 0;
                }
                if (order1 < order2) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(categories, sorter);
        categories.add(0, navigation);
        root.setUserModificationPermission(1);
        root.setChildren(categories);
        return root;
    }

    static String shortcut(String label) {
        int cut = label.indexOf("&");
        String shortcut = cut == -1 ? null : label.substring(cut + 1, cut + 2);
        return shortcut;
    }

    static String fixLabel(String label) {
        label = label.replace("&", "");
        label = label.replace("Tools", "");
        label = label.replace("Tool", "");
        return label;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("Actions");
        ArrayList<SelectionToolEntry> entries = new ArrayList<SelectionToolEntry>();
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setToolClass(SelectionToolWithDoubleClick.class);
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    private static IPreferenceStore getPreferenceStore() {
        return ProjectUIPlugin.getDefault().getPreferenceStore();
    }

    static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        MapToolPaletteFactory.getPreferenceStore().setDefault(PALETTE_DOCK_LOCATION, -1);
        MapToolPaletteFactory.getPreferenceStore().setDefault(PALETTE_STATE, 4);
        MapToolPaletteFactory.getPreferenceStore().setDefault(PALETTE_SIZE, 125);
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return MapToolPaletteFactory.getPreferenceStore().getInt(MapToolPaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return MapToolPaletteFactory.getPreferenceStore().getInt(MapToolPaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return MapToolPaletteFactory.getPreferenceStore().getInt(MapToolPaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                MapToolPaletteFactory.getPreferenceStore().setValue(MapToolPaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                MapToolPaletteFactory.getPreferenceStore().setValue(MapToolPaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                MapToolPaletteFactory.getPreferenceStore().setValue(MapToolPaletteFactory.PALETTE_SIZE, width);
            }
        };
    }

    public static void dispose(PaletteRoot paletteRoot) {
        if (paletteRoot == null) {
            return;
        }
        ApplicationGIS.getToolManager();
        for (Object child : paletteRoot.getChildren()) {
            if (!(child instanceof PaletteContainer)) continue;
            PaletteContainer container = (PaletteContainer)child;
            for (Object entry : container.getChildren()) {
                if (!(entry instanceof MapToolEntry)) continue;
                MapToolEntry mapEntry = (MapToolEntry)((Object)entry);
                mapEntry.dispose();
            }
        }
    }

    public static class SelectionToolWithDoubleClick
    extends SelectionTool {
        protected boolean handleDoubleClick(int button) {
            this.getTargetEditPart();
            return super.handleDoubleClick(button);
        }
    }
}

