/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import net.refractions.udig.project.ui.internal.tool.display.ToolProxy;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.project.ui.tool.ModalTool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;

public class MapToolEntry
extends ToolEntry {
    private String categoryId;
    private ModalItem item;

    public MapToolEntry(String label, ModalItem item, String shortcut, String categoryId) {
        super(label, MapToolEntry.description(item.getToolTipText(), shortcut), item.getImageDescriptor(), item.getLargeImageDescriptor());
        this.setId(item.getId());
        this.categoryId = categoryId;
        this.item = item;
        item.getMapToolEntries().add(this);
    }

    static String description(String tooltip, String shortcut) {
        if (shortcut == null) {
            return tooltip;
        }
        StringBuilder build = new StringBuilder();
        if (tooltip != null) {
            build.append(tooltip);
            build.append(" ");
        }
        build.append("(");
        build.append(shortcut);
        build.append(")");
        return build.toString();
    }

    public ModalTool getMapTool() {
        IToolManager tools = ApplicationGIS.getToolManager();
        ModalTool tool = (ModalTool)tools.findTool(this.getId());
        return tool;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public ToolProxy getMapToolProxy() {
        return (ToolProxy)this.item;
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        PaletteContainer parent = this.getParent();
        boolean doubleCheck = false;
        for (Object child : parent.getChildren()) {
            PaletteEntry entry = (PaletteEntry)child;
            if (!entry.isVisible()) continue;
            doubleCheck = true;
            break;
        }
        parent.setVisible(doubleCheck);
    }

    public void dispose() {
        this.item.getMapToolEntries().remove((Object)this);
    }
}

