/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class MapEditorSelectionProvider
extends AdapterImpl
implements IMapEditorSelectionProvider {
    IStructuredSelection selection;
    CopyOnWriteArraySet<ISelectionChangedListener> list = new CopyOnWriteArraySet();

    protected void fireSelectionChangedEvent(final SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source == this) {
            return;
        }
        for (final ISelectionChangedListener l : this.list) {
            PlatformGIS.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public void notifyChanged(Notification msg) {
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.list.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.list.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    @Override
    public void setActiveMap(IMap map2, MapPart editor) {
        this.selection = new StructuredSelection((Object)map2);
    }

    @Override
    public Set<ISelectionChangedListener> getListeners() {
        return this.list;
    }
}

