/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.ui.internal.LegendViewUtils;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class LegendViewRenameFolderAction
extends Action
implements ISelectionChangedListener {
    private IStructuredSelection selection;
    private Viewer viewer;

    public LegendViewRenameFolderAction(Viewer viewerSource) {
        this.viewer = viewerSource;
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setText(Messages.RenameFolderAction_label);
        this.setEnabled(true);
    }

    public void run() {
        if (LegendViewUtils.isFolderSelected((ISelection)this.selection)) {
            this.processRenameFolder();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection rawSelection = event.getSelection();
        if (rawSelection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)rawSelection;
        }
    }

    private void processRenameFolder() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Folder folder = (Folder)LegendViewRenameFolderAction.this.selection.getFirstElement();
                InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.RenameFolderAction_dialogTitle, Messages.RenameFolderAction_dialogMsg, folder.getName(), null);
                int folderNameDialogResult = dialog.open();
                if (folderNameDialogResult == 0) {
                    folder.setName(dialog.getValue());
                }
                LegendViewRenameFolderAction.this.viewer.refresh();
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }
}

