/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.internal.LegendView;
import net.refractions.udig.project.ui.internal.LegendViewCheckboxUtils;
import net.refractions.udig.project.ui.internal.LegendViewUtils;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class LegendViewFiltersHandler {
    private Action toggleMgLayerAction;
    private Action toggleBgLayerAction;
    private MapGraphicLayerFilter mgLayerFilter;
    private BackgroundLayerFilter bgLayerFilter;
    private LegendView view;
    private Map map;

    public MapGraphicLayerFilter getMgLayerFilter() {
        return this.mgLayerFilter;
    }

    public BackgroundLayerFilter getBgLayerFilter() {
        return this.bgLayerFilter;
    }

    public void setBgLayerFilter(boolean isOn) {
        this.bgLayerFilter.setShowLayer(isOn);
    }

    public boolean isBgInViewer(Viewer viewer, Object parent, Object element) {
        return this.bgLayerFilter.select(viewer, parent, element);
    }

    public LegendViewFiltersHandler(LegendView view) {
        this.view = view;
        this.mgLayerFilter = new MapGraphicLayerFilter();
        this.bgLayerFilter = new BackgroundLayerFilter();
    }

    public void setMap(Map map) {
        this.cleanHandler();
        this.initMap(map);
        this.setToggleLayersActionState();
    }

    public void disposeHandler() {
        this.cleanHandler();
        if (this.toggleBgLayerAction != null) {
            this.toggleBgLayerAction = null;
        }
        if (this.toggleMgLayerAction != null) {
            this.toggleMgLayerAction = null;
        }
        if (this.mgLayerFilter != null) {
            this.mgLayerFilter = null;
        }
        if (this.bgLayerFilter != null) {
            this.bgLayerFilter = null;
        }
        if (this.view != null) {
            this.view = null;
        }
    }

    private void cleanHandler() {
        if (this.map != null) {
            this.map = null;
        }
    }

    private void initMap(Map map) {
        this.map = map;
    }

    public Action getToggleMgAction() {
        if (this.toggleMgLayerAction == null) {
            this.toggleMgLayerAction = new FilterAction(null, 2){

                @Override
                public void run() {
                    LegendViewFiltersHandler.this.mgLayerFilter.setShowLayer(!this.isChecked());
                    super.run();
                }
            };
            this.toggleMgLayerAction.setToolTipText(Messages.LegendView_hide_mg_tooltip);
            this.toggleMgLayerAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/toggle_map_graphic_co.gif"));
        }
        return this.toggleMgLayerAction;
    }

    public Action getToggleBgAction() {
        if (this.toggleBgLayerAction == null) {
            this.toggleBgLayerAction = new FilterAction(null, 2){

                @Override
                public void run() {
                    LegendViewFiltersHandler.this.bgLayerFilter.setShowLayer(!this.isChecked());
                    super.run();
                }
            };
            this.toggleBgLayerAction.setToolTipText(Messages.LegendView_hide_bg_tooltip);
            this.toggleBgLayerAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/toggle_bg_layer_co.gif"));
        }
        return this.toggleBgLayerAction;
    }

    public void setToggleLayersActionState() {
        if (this.map == null) {
            this.setLayerActionsEnabled(false);
        } else if (LegendViewUtils.getLayers(this.map.getLegend(), false).size() > 0) {
            this.setLayerActionsEnabled(true);
        } else {
            this.setLayerActionsEnabled(false);
        }
    }

    private void setLayerActionsEnabled(boolean enabled) {
        if (this.toggleMgLayerAction != null) {
            this.toggleMgLayerAction.setEnabled(enabled);
        }
        if (this.toggleBgLayerAction != null) {
            this.toggleBgLayerAction.setEnabled(enabled);
        }
    }

    public ViewerFilter[] getFilters() {
        return new ViewerFilter[]{this.mgLayerFilter, this.bgLayerFilter};
    }

    public void refresh() {
        this.setToggleLayersActionState();
    }

    private abstract class AbstractLayerFilter
    extends ViewerFilter {
        private boolean showLayer = true;

        private AbstractLayerFilter() {
        }

        public void setShowLayer(boolean showLayer) {
            this.showLayer = showLayer;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof LayerLegendItem) {
                LayerLegendItem layerItem = (LayerLegendItem)element;
                Layer layer = layerItem.getLayer();
                if (!this.showLayer && this.isLayerType(layer)) {
                    return false;
                }
            }
            return true;
        }

        protected abstract boolean isLayerType(Layer var1);
    }

    private class BackgroundLayerFilter
    extends AbstractLayerFilter {
        private BackgroundLayerFilter() {
        }

        @Override
        protected boolean isLayerType(Layer layer) {
            return LegendViewUtils.isBackgroundLayer((ILayer)layer);
        }
    }

    private class FilterAction
    extends Action {
        public FilterAction(String text, int style) {
            super(text, style);
        }

        public void run() {
            LegendViewFiltersHandler.this.view.getViewer().refresh();
            LegendViewCheckboxUtils.updateCheckboxesAsync(LegendViewFiltersHandler.this.view);
        }
    }

    private class MapGraphicLayerFilter
    extends AbstractLayerFilter {
        private MapGraphicLayerFilter() {
        }

        @Override
        protected boolean isLayerType(Layer layer) {
            return LegendViewUtils.isMapGraphicLayer((ILayer)layer);
        }
    }
}

