/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.Arrays;
import java.util.List;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.ui.internal.LegendView;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.ui.PlatformUI;

public final class LegendViewCheckboxUtils {
    public static void updateCheckboxesAsync(final LegendView view) {
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LegendViewCheckboxUtils.updateCheckboxes(view);
            }
        }, (boolean)true);
    }

    public static void updateCheckboxes(LegendView view) {
        if (!PlatformUI.getWorkbench().isClosing()) {
            CheckboxTreeViewer viewer = view.getViewer();
            List items = view.getCurrentMap().getLegend();
            for (ILegendItem item : items) {
                LegendViewCheckboxUtils.updateCheckbox(viewer, item);
            }
        }
    }

    private static void updateCheckbox(CheckboxTreeViewer viewer, ILegendItem item) {
        if (item instanceof Folder) {
            Folder folder = (Folder)item;
            LegendViewCheckboxUtils.updateCheckbox(viewer, folder);
        } else if (item instanceof LayerLegendItem) {
            LayerLegendItem layerItem = (LayerLegendItem)item;
            LegendViewCheckboxUtils.updateCheckbox(viewer, layerItem);
        }
    }

    private static void updateCheckbox(CheckboxTreeViewer viewer, Folder folder) {
        for (ILegendItem item : folder.getItems()) {
            LegendViewCheckboxUtils.updateCheckbox(viewer, item);
        }
        LegendViewCheckboxUtils.setFolderCheckbox(viewer, folder);
        LegendViewCheckboxUtils.setFolderExpansion(viewer, folder);
    }

    private static void updateCheckbox(CheckboxTreeViewer viewer, LayerLegendItem layerItem) {
        LegendViewCheckboxUtils.setLayerCheckbox(viewer, layerItem);
    }

    private static void setLayerCheckbox(CheckboxTreeViewer viewer, LayerLegendItem layerItem) {
        Layer layer = layerItem.getLayer();
        viewer.setChecked((Object)layerItem, layer.isVisible());
    }

    private static void setFolderExpansion(CheckboxTreeViewer viewer, Folder folder) {
        boolean isEmpty = folder.getItems().size() == 0;
        viewer.setExpandedState((Object)folder, !isEmpty);
    }

    private static void setFolderCheckbox(CheckboxTreeViewer viewer, Folder folder) {
        switch (LegendViewCheckboxUtils.getFolderCheckboxDisplay(viewer, folder)) {
            case CHECKED: {
                viewer.setChecked((Object)folder, true);
                viewer.setGrayed((Object)folder, false);
                break;
            }
            case BLOCKED: {
                viewer.setGrayChecked((Object)folder, true);
                break;
            }
            case UNCHECKED: {
                viewer.setChecked((Object)folder, false);
                viewer.setGrayed((Object)folder, false);
                break;
            }
        }
    }

    private static FolderState getFolderCheckboxDisplay(CheckboxTreeViewer viewer, Folder folder) {
        List items = folder.getItems();
        if (items.size() == 0) {
            boolean isGrayed = viewer.getGrayed((Object)folder);
            if (isGrayed) {
                return FolderState.BLOCKED;
            }
            boolean isChecked = viewer.getChecked((Object)folder);
            if (isChecked) {
                return FolderState.CHECKED;
            }
        } else {
            int checkedCnt = 0;
            int grayedCnt = 0;
            List<Object> grayedElements = Arrays.asList(viewer.getGrayedElements());
            List<Object> checkedElements = Arrays.asList(viewer.getCheckedElements());
            for (ILegendItem item : items) {
                if (grayedElements.contains(item)) {
                    ++grayedCnt;
                    continue;
                }
                if (!checkedElements.contains(item)) continue;
                ++checkedCnt;
            }
            if (checkedCnt > 0) {
                if (checkedCnt == items.size()) {
                    return FolderState.CHECKED;
                }
                return FolderState.BLOCKED;
            }
            if (grayedCnt > 0) {
                return FolderState.BLOCKED;
            }
        }
        return FolderState.UNCHECKED;
    }

    static enum FolderState {
        UNCHECKED,
        CHECKED,
        BLOCKED;

    }
}

