/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.map.LayerMoveDownCommand;
import net.refractions.udig.project.command.map.LayerMoveUpCommand;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.ui.AdapterFactoryLabelProviderDecorator;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.LayerApplicabilityMenuCreator;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectExplorer;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.ViewerLayerSorter;
import net.refractions.udig.project.ui.internal.actions.Delete;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import net.refractions.udig.ui.ZoomingDialog;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class LayersView
extends ViewPart
implements IDropTargetProvider,
IDoubleClickListener,
ISelectionChangedListener {
    public static final String ID = "net.refractions.udig.project.ui.layerManager";
    IMap placeholder = ApplicationGIS.NO_MAP;
    private EditManagerListener editManagerListener;
    private IBlackboardListener mylarListener = new IBlackboardListener(){

        public void blackBoardChanged(BlackboardEvent event) {
            if (event.getKey() == "MYLAR" && event.getOldValue() != event.getNewValue()) {
                LayersView.this.updateViewer();
            }
        }

        public void blackBoardCleared(IBlackboard source) {
            LayersView.this.updateViewer();
        }
    };
    private IViewportModelListener zoomListener = new IViewportModelListener(){

        public void changed(ViewportModelEvent event) {
            LayersView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).LayersView.this.viewer.update((this).LayersView.this.currentMap.getMapLayers().toArray(), null);
                }
            });
        }
    };
    CheckboxTreeViewer viewer;
    LayerAction downAction;
    Map currentMap;
    LayerAction upAction;
    private MapEditorListener partServiceListener = new MapEditorListener();
    Adapter checkboxContextListener = new AdapterImpl(){

        public void notifyChanged(final Notification msg) {
            if (msg.getNotifier() instanceof ContextModel) {
                ContextModel contextModel = (ContextModel)msg.getNotifier();
                Map map = contextModel.getMap();
                if (LayersView.this.getCurrentMap() != map) {
                    map.removeDeepAdapter((Adapter)this);
                    return;
                }
                if (PlatformUI.getWorkbench().isClosing()) {
                    contextModel.eAdapters().remove((Object)this);
                }
                if (msg.getFeatureID(ContextModel.class) == 0) {
                    switch (msg.getEventType()) {
                        case 3: {
                            Layer layer = (Layer)msg.getNewValue();
                            LayersView.this.updateCheckbox(layer);
                            break;
                        }
                        case 5: {
                            LayersView.this.updateCheckboxes();
                            break;
                        }
                        case 1: {
                            Layer layer = (Layer)msg.getNewValue();
                            LayersView.this.updateCheckbox(layer);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (msg.getNotifier() instanceof Layer) {
                Layer layer = (Layer)msg.getNotifier();
                if (LayersView.this.getCurrentMap() != layer.getMapInternal()) {
                    layer.getMapInternal().removeDeepAdapter((Adapter)this);
                    return;
                }
                if (msg.getFeatureID(Layer.class) == 8 && msg.getNewBooleanValue() != msg.getOldBooleanValue()) {
                    if (Display.getCurrent() == null) {
                        LayersView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).LayersView.this.viewer.setChecked(msg.getNotifier(), msg.getNewBooleanValue());
                            }
                        });
                    } else {
                        LayersView.this.viewer.setChecked(msg.getNotifier(), msg.getNewBooleanValue());
                    }
                }
            }
        }
    };
    private AdapterFactoryContentProvider contentProvider;
    private AdapterFactoryLabelProviderDecorator labelProvider;
    private Action propertiesAction;
    private IAction deleteAction;
    private static LayersView instance;
    private ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            LayersView.this.updateLabels();
        }
    };

    public void dispose() {
        this.disposeInternal();
        super.dispose();
    }

    protected void disposeInternal() {
        if (PlatformUI.getWorkbench().isClosing()) {
            ProjectPlugin.getPlugin().turnOffEvents();
        }
        if (this.currentMap != null) {
            this.currentMap.removeDeepAdapter(this.checkboxContextListener);
            IViewportModel viewportModel = this.currentMap.getViewportModel();
            if (viewportModel != null) {
                viewportModel.removeViewportModelListener(this.zoomListener);
            }
        }
        this.labelProvider.dispose();
        this.labelProvider.removeListener(this.labelProviderListener);
        this.labelProvider = null;
        this.labelProviderListener = null;
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.partServiceListener);
    }

    public synchronized Map getCurrentMap() {
        return this.currentMap;
    }

    private void updateViewer() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LayersView.this.viewer.update(LayersView.this.getCurrentMap().getMapLayers().toArray(), new String[]{"MYLAR"});
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public synchronized void setCurrentMap(Map currentMap) {
        if (this.currentMap != null) {
            this.currentMap.removeDeepAdapter(this.checkboxContextListener);
            this.currentMap.getBlackboard().removeListener(this.mylarListener);
            this.currentMap.getViewportModel().removeViewportModelListener(this.zoomListener);
        }
        this.currentMap = currentMap;
        if (this.viewer != null) {
            this.viewer.setInput(currentMap == null ? this.placeholder : currentMap);
        }
        if (this.editManagerListener == null) {
            this.editManagerListener = new EditManagerListener();
        }
        if (currentMap != null) {
            ILayer selectedLayer;
            this.currentMap.getViewportModel().addViewportModelListener(this.zoomListener);
            this.editManagerListener.setCurrentMap(currentMap);
            this.currentMap.getBlackboard().addListener(this.mylarListener);
            currentMap.addDeepAdapter(this.checkboxContextListener);
            if (!currentMap.getEditManager().containsListener((IEditManagerListener)this.editManagerListener)) {
                currentMap.getEditManager().addListener((IEditManagerListener)this.editManagerListener);
            }
            if ((selectedLayer = currentMap.getEditManager().getSelectedLayer()) != null && this.viewer != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)selectedLayer));
            }
            this.updateCheckboxes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLabels() {
        Map currentMap;
        LayersView layersView = this;
        synchronized (layersView) {
            currentMap = this.currentMap;
        }
        if (currentMap == null) {
            return;
        }
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                if (LayersView.this.viewer != null) {
                    LayersView.this.viewer.refresh(true);
                }
            }
        });
    }

    void updateCheckboxes() {
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map currentMap;
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                7 var2_1 = this;
                synchronized (var2_1) {
                    currentMap = LayersView.this.currentMap;
                }
                if (currentMap == null) {
                    return;
                }
                List layers = currentMap.getLayersInternal();
                if (!LayersView.this.requiresCheckboxUpdate(layers)) {
                    return;
                }
                ArrayList<Layer> checkedLayers = new ArrayList<Layer>();
                for (Layer layer : layers) {
                    if (!layer.isVisible()) continue;
                    checkedLayers.add(layer);
                }
                if (LayersView.this.viewer != null) {
                    LayersView.this.viewer.setCheckedElements(checkedLayers.toArray());
                    ILayer selectedLayer = currentMap.getEditManager().getSelectedLayer();
                    if (selectedLayer != null) {
                        LayersView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)selectedLayer), true);
                    }
                }
            }
        }, (boolean)true);
    }

    private boolean requiresCheckboxUpdate(List<Layer> layers) {
        for (Layer layer : layers) {
            if (layer.isVisible() == this.viewer.getChecked((Object)layer)) continue;
            return true;
        }
        return false;
    }

    void updateCheckbox(final Layer layer) {
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                LayersView.this.viewer.setChecked((Object)layer, layer.isVisible());
            }
        }, (boolean)true);
    }

    public void createPartControl(Composite parent) {
        Object obj;
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.partServiceListener);
        this.viewer = new CheckboxTreeViewer(parent, 2);
        this.contentProvider = new AdapterFactoryContentProvider(ProjectUIPlugin.getDefault().getAdapterFactory()){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                switch (notification.getFeatureID(Map.class)) {
                    case 2: {
                        if (notification.getNotifier() != LayersView.this.getCurrentMap()) break;
                        LayersView.this.updateCheckboxes();
                    }
                }
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new AdapterFactoryLabelProviderDecorator(ProjectExplorer.getProjectExplorer().getAdapterFactory(), (StructuredViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.labelProvider.addListener(this.labelProviderListener);
        if (this.getSite().getPage().getActiveEditor() != null && this.getSite().getPage().getActiveEditor() instanceof IAdaptable && (obj = this.getSite().getPage().getActiveEditor().getAdapter(Map.class)) != null) {
            this.setCurrentMap((Map)obj);
        }
        this.viewer.setSorter((ViewerSorter)new ViewerLayerSorter());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (((Layer)event.getElement()).isVisible() != event.getChecked()) {
                    ((Layer)event.getElement()).setVisible(event.getChecked());
                }
            }
        });
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.createContextMenuFor((Viewer)this.viewer);
        this.addMenuActions();
        this.addToobarActions();
        this.setGlobalActions();
        UDIGDragDropUtilities.addDragDropSupport((StructuredViewer)this.viewer, (IDropTargetProvider)this);
    }

    protected void updateSelection(final ILayer newSelection) {
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                if (LayersView.this.getCurrentMap().getLayersInternal().size() > 0 && LayersView.this.getCurrentMap() != null && LayersView.this.getCurrentMap().getLayersInternal().contains(newSelection)) {
                    LayersView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newSelection));
                }
            }
        });
    }

    private void setGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolManager toolManager = ApplicationGIS.getToolManager();
        toolManager.contributeGlobalActions((IWorkbenchPart)this, actionBars);
        toolManager.registerActionsWithPart((IWorkbenchPart)this);
        IKeyBindingService keyBindings = this.getSite().getKeyBindingService();
        IAction delAction = this.getDeleteAction();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), delAction);
        keyBindings.registerAction(delAction);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return ProjectUIPlugin.getDefault().getPropertySheetPage();
        }
        if (key.isAssignableFrom(IMap.class)) {
            return this.getCurrentMap();
        }
        return super.getAdapter(key);
    }

    private void addToobarActions() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.upAction());
        mgr.add((IAction)this.downAction());
    }

    private LayerAction downAction() {
        this.downAction = new LayerAction(){

            public void run() {
                if (this.selection.isEmpty()) {
                    return;
                }
                Map map = LayersView.this.getCurrentMap();
                map.sendCommandASync((MapCommand)new LayerMoveDownCommand(this.selection));
            }
        };
        this.downAction.setEnabled(false);
        this.downAction.setToolTipText(Messages.LayersView_down_tooltip);
        this.downAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/down_co.gif"));
        return this.downAction;
    }

    private LayerAction upAction() {
        this.upAction = new LayerAction(){

            public void run() {
                if (this.selection.isEmpty()) {
                    return;
                }
                Map map = LayersView.this.getCurrentMap();
                map.sendCommandASync((MapCommand)new LayerMoveUpCommand(this.selection));
            }
        };
        this.upAction.setEnabled(false);
        this.upAction.setToolTipText(Messages.LayersView_up_tooltip);
        this.upAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/up_co.gif"));
        return this.upAction;
    }

    private void addMenuActions() {
    }

    private void createContextMenuFor(final Viewer viewer2) {
        final MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){
            private LayerApplicabilityMenuCreator applicabilityCreator;

            public void menuAboutToShow(IMenuManager mgr) {
                contextMenu.add(ApplicationGIS.getToolManager().getCOPYAction((IWorkbenchPart)LayersView.this));
                contextMenu.add(ApplicationGIS.getToolManager().getPASTEAction((IWorkbenchPart)LayersView.this));
                contextMenu.add(LayersView.this.getDeleteAction());
                contextMenu.add((IContributionItem)new Separator());
                contextMenu.add((IContributionItem)new GroupMarker("additions"));
                contextMenu.add((IContributionItem)ApplicationGIS.getToolManager().createOperationsContextMenu(LayersView.this.viewer.getSelection()));
                contextMenu.add((IContributionItem)new Separator());
                contextMenu.add((IAction)ActionFactory.EXPORT.create(LayersView.this.getSite().getWorkbenchWindow()));
                contextMenu.add((IContributionItem)new Separator());
                if (LayersView.this.viewer.getTree().getSelectionCount() == 1) {
                    contextMenu.add(LayersView.this.getPropertiesAction());
                }
            }

            private LayerApplicabilityMenuCreator getApplicabilityMenu() {
                if (this.applicabilityCreator == null) {
                    this.applicabilityCreator = new LayerApplicabilityMenuCreator();
                }
                IStructuredSelection selection = (IStructuredSelection)viewer2.getSelection();
                for (Object element : selection) {
                    if (element instanceof Layer) continue;
                    return null;
                }
                return this.applicabilityCreator;
            }
        });
        Menu menu = contextMenu.createContextMenu(viewer2.getControl());
        viewer2.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer2);
    }

    private IAction getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new Action(){

                public void run() {
                    Delete delete = new Delete(false);
                    ISelection s = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
                    delete.selectionChanged((IAction)this, s);
                    delete.run((IAction)this);
                }
            };
            this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
            ActionFactory.IWorkbenchAction actionTemplate = ActionFactory.DELETE.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            this.deleteAction.setText(actionTemplate.getText());
            this.deleteAction.setToolTipText(actionTemplate.getToolTipText());
            this.deleteAction.setImageDescriptor(actionTemplate.getImageDescriptor());
            this.deleteAction.setDescription(actionTemplate.getDescription());
            this.deleteAction.setDisabledImageDescriptor(actionTemplate.getDisabledImageDescriptor());
        }
        return this.deleteAction;
    }

    protected IAction getPropertiesAction() {
        if (this.propertiesAction == null) {
            final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            final PropertyDialogAction tmp = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), (ISelectionProvider)LayersView.getViewer());
            this.propertiesAction = new Action(){

                public void runWithEvent(Event event) {
                    ZoomingDialog dialog = new ZoomingDialog(shell, (Dialog)tmp.createDialog(), ZoomingDialog.calculateBounds((TreeItem)LayersView.this.viewer.getTree().getSelection()[0], (int)-1));
                    dialog.open();
                }
            };
            this.propertiesAction.setText(tmp.getText());
            this.propertiesAction.setActionDefinitionId(tmp.getActionDefinitionId());
            this.propertiesAction.setDescription(tmp.getDescription());
            this.propertiesAction.setHoverImageDescriptor(tmp.getHoverImageDescriptor());
            this.propertiesAction.setImageDescriptor(tmp.getImageDescriptor());
            this.propertiesAction.setToolTipText(tmp.getToolTipText());
        }
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        return this.propertiesAction;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static Viewer getViewer() {
        LayersView viewPart = LayersView.getViewPart();
        if (viewPart == null) {
            return null;
        }
        return viewPart.viewer;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        instance = this;
    }

    public static LayersView getViewPart() {
        return instance;
    }

    public Object getTarget(DropTargetEvent event) {
        if (this.getCurrentMap() == null) {
            return this;
        }
        List mapLayers = this.getCurrentMap().getMapLayers();
        if (mapLayers.isEmpty()) {
            return this;
        }
        return mapLayers.get(mapLayers.size() - 1);
    }

    public void doubleClick(DoubleClickEvent event) {
        Object obj = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (!(obj instanceof IProjectElement)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
            return;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        if (!(event.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)event.getSelection();
        Object firstElement = structured.getFirstElement();
        if (firstElement instanceof ILayer) {
            ILayer layer = (ILayer)firstElement;
            if (layer.getStatus() == 2) {
                this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(layer.getStatusMessage());
            } else {
                this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
                this.getViewSite().getActionBars().getStatusLineManager().setMessage(layer.getStatusMessage());
            }
        } else {
            this.getViewSite().getActionBars().getStatusLineManager().setMessage(null);
            this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        }
    }

    class EditManagerListener
    implements IEditManagerListener {
        Map map;

        EditManagerListener() {
        }

        synchronized void setCurrentMap(Map currentMap) {
            this.map = currentMap;
        }

        public void changed(final EditManagerEvent event) {
            if (LayersView.this.getCurrentMap() != this.map) {
                this.map.getEditManager().removeListener((IEditManagerListener)this);
                return;
            }
            if (event.getType() == 5) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (((IStructuredSelection)((EditManagerListener)EditManagerListener.this).LayersView.this.viewer.getSelection()).getFirstElement() != event.getNewValue()) {
                            StructuredSelection structuredSelection = new StructuredSelection(event.getNewValue());
                            LayersView.this.getSite().getSelectionProvider().setSelection((ISelection)structuredSelection);
                        }
                        if (this.mylarOn()) {
                            ((EditManagerListener)EditManagerListener.this).LayersView.this.viewer.update(EditManagerListener.this.map.getLayersInternal().toArray(), null);
                        }
                    }

                    private boolean mylarOn() {
                        Object on = EditManagerListener.this.map.getBlackboard().get("MYLAR");
                        if (on instanceof Boolean) {
                            return (Boolean)on;
                        }
                        return false;
                    }
                };
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(runnable);
                } else {
                    runnable.run();
                }
            }
        }
    }

    private abstract class LayerAction
    extends Action
    implements ISelectionListener {
        protected IStructuredSelection selection;

        public LayerAction() {
            LayersView.this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            this.selection = (IStructuredSelection)selection;
            if (part instanceof LayersView && selection != null && !selection.isEmpty()) {
                this.setEnabled(true);
            }
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(false);
            if (!enabled || this.selection == null || this.selection.isEmpty()) {
                return;
            }
            for (Object obj : this.selection) {
                if (obj instanceof Layer) continue;
                return;
            }
            super.setEnabled(true);
        }
    }

    private class MapEditorListener
    implements IPartListener,
    ISelectionChangedListener {
        private IWorkbenchPart currentPart;

        private MapEditorListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            IWorkbenchPart adaptable;
            Object obj;
            if (part == this.currentPart) {
                return;
            }
            if (part instanceof IAdaptable && (obj = (adaptable = part).getAdapter(Map.class)) instanceof Map) {
                this.currentPart = part;
                LayersView.this.setCurrentMap((Map)obj);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            this.partActivated(part);
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == this) {
                LayersView.this.disposeInternal();
                return;
            }
            if (part != this.currentPart) {
                return;
            }
            this.currentPart = null;
            LayersView.this.setCurrentMap(null);
            if (part.getSite().getPage().getEditorReferences().length == 0 && part instanceof EditorPart) {
                this.removeApplicabilityMenu((EditorPart)part);
            }
            LayersView.this.viewer.refresh(true);
        }

        private void removeApplicabilityMenu(EditorPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }
    }
}

