/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class LayerStateDecorator
implements ILightweightLabelDecorator {
    private Adapter hack = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof Layer) {
                Layer layer = (Layer)msg.getNotifier();
                LayerStateDecorator.this.refresh(layer);
            }
        }
    };
    Set<ILabelProviderListener> listeners = new CopyOnWriteArraySet<ILabelProviderListener>();

    void refresh(Layer layer) {
        if (this.listeners.isEmpty()) {
            return;
        }
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)layer);
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    void refresh() {
        if (this.listeners.isEmpty()) {
            return;
        }
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        Layer layer = (Layer)element;
        decoration.addOverlay(ProjectUIPlugin.getDefault().getImageDescriptor("ovr16/write_ovr.gif"));
        if (!layer.eAdapters().contains((Object)this.hack)) {
            layer.eAdapters().add((Object)this.hack);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }
}

