/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.ITransientResolve;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.ui.ImageCache;
import net.refractions.udig.ui.graphics.Glyph;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.geotools.data.FeatureSource;
import org.geotools.data.wms.WebMapServer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class LayerGeneratedGlyphDecorator
implements ILabelDecorator {
    LinkedList<Layer> queue = new LinkedList<Layer>(){
        private static final long serialVersionUID = 3834874663317747760L;

        @Override
        public void add(int index, Layer aLayer) {
            if (!this.contains(aLayer)) {
                super.add(index, aLayer);
            }
        }

        @Override
        public boolean add(Layer aLayer) {
            if (!this.contains(aLayer)) {
                return super.add(aLayer);
            }
            return false;
        }

        @Override
        public void addFirst(Layer aLayer) {
            if (!this.contains(aLayer)) {
                super.addFirst(aLayer);
            }
        }

        @Override
        public void addLast(Layer aLayer) {
            if (!this.contains(aLayer)) {
                super.addFirst(aLayer);
            }
        }
    };
    private volatile boolean disposed = false;
    Job picasso = new Job(Messages.LayerGeneratedGlyphDecorator_jobName){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Layer layer = null;
            while (!LayerGeneratedGlyphDecorator.this.disposed) {
                LinkedList<Layer> linkedList = LayerGeneratedGlyphDecorator.this.queue;
                synchronized (linkedList) {
                    block9: {
                        if (LayerGeneratedGlyphDecorator.this.queue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        try {
                            layer = LayerGeneratedGlyphDecorator.this.queue.removeFirst();
                            if (layer.eAdapters().contains((Object)LayerGeneratedGlyphDecorator.this.hack)) break block9;
                            layer.eAdapters().add((Object)LayerGeneratedGlyphDecorator.this.hack);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            continue;
                        }
                    }
                }
                try {
                    boolean notifyIcon = this.refreshIcon(layer);
                    boolean notifyLabel = this.refreshLabel(layer);
                    if (!notifyIcon && !notifyLabel) continue;
                    LayerGeneratedGlyphDecorator.this.refresh(layer);
                }
                catch (Throwable throwable) {}
            }
            return Status.OK_STATUS;
        }

        private boolean refreshIcon(Layer layer) {
            try {
                ImageDescriptor icon = LayerGeneratedGlyphDecorator.generateIcon(layer);
                if (icon != null) {
                    layer.getProperties().put("generated icon", (Object)icon);
                    return true;
                }
            }
            catch (Throwable problem) {
                ProjectUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.project.ui", 1, "Could not generate layer glyph " + layer, problem));
            }
            return false;
        }

        private boolean refreshLabel(Layer layer) {
            String label = LayerGeneratedGlyphDecorator.label(layer);
            if (label == null || label.length() == 0) {
                try {
                    String gen = LayerGeneratedGlyphDecorator.generateLabel(layer);
                    if (gen != null) {
                        layer.getProperties().putString("generated title", gen);
                        return true;
                    }
                }
                catch (Throwable problem) {
                    ProjectUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.project.ui", 1, "Could not generate name for " + layer, problem));
                }
            }
            return false;
        }
    };
    private static LayerGeneratedGlyphDecorator instance = null;
    Set<ILabelProviderListener> listeners = new CopyOnWriteArraySet<ILabelProviderListener>();
    Adapter hack = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof Layer) {
                Layer layer = (Layer)msg.getNotifier();
                if (LayerGeneratedGlyphDecorator.this.queue == null) {
                    layer.eAdapters().remove((Object)this);
                    return;
                }
                switch (msg.getFeatureID(Layer.class)) {
                    case 2: 
                    case 5: 
                    case 10: 
                    case 20: {
                        layer.getProperties().put("generated icon", null);
                        layer.getProperties().put("generated title", null);
                        LayerGeneratedGlyphDecorator.this.refresh(layer);
                    }
                }
            }
        }
    };
    static ImageCache cache = new ImageCache();

    public static LayerGeneratedGlyphDecorator getInstance() {
        return instance;
    }

    public LayerGeneratedGlyphDecorator() {
        this.picasso.setSystem(true);
        this.picasso.setPriority(50);
        this.picasso.schedule();
        instance = this;
    }

    void refresh(Layer layer) {
        if (this.listeners.isEmpty()) {
            return;
        }
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)layer);
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    static String label(Layer layer) {
        String label = layer.getName();
        if (label != null && label.length() > 0) {
            return label;
        }
        label = layer.getProperties().getString("generated title");
        if (label != null) {
            return label;
        }
        return null;
    }

    public static String generateLabel(Layer layer) {
        String layerName;
        String name = layer.getName();
        if (name != null) {
            return name;
        }
        IGeoResource resource = layer.getGeoResource();
        if (resource == null) {
            return null;
        }
        String title = resource.getTitle();
        if (title == null) {
            IGeoResourceInfo info = null;
            try {
                info = resource.getInfo(null);
                title = info.getTitle();
                if (title == null) {
                    title = info.getName();
                }
            }
            catch (IOException iOException) {}
        }
        if ((layerName = title) == null) {
            layerName = resource.getID().toBaseFile();
        }
        if (layer.hasResource(ITransientResolve.class)) {
            layerName = String.valueOf(layerName) + " *";
        }
        return layerName;
    }

    public static ImageDescriptor generateIcon(Layer layer) {
        ImageDescriptor icon;
        StyleBlackboard style = layer.getStyleBlackboard();
        if (style != null && !style.getContent().isEmpty() && (icon = LayerGeneratedGlyphDecorator.generateStyledIcon(layer)) != null) {
            return icon;
        }
        icon = LayerGeneratedGlyphDecorator.generateDefaultIcon(layer);
        if (icon != null) {
            return icon;
        }
        return null;
    }

    public static ImageDescriptor generateStyledIcon(Layer layer) {
        StyleBlackboard blackboard = layer.getStyleBlackboard();
        if (blackboard == null) {
            return null;
        }
        Style sld = (Style)blackboard.lookup(Style.class);
        if (sld != null) {
            Rule rule = LayerGeneratedGlyphDecorator.getRule(sld);
            return LayerGeneratedGlyphDecorator.generateStyledIcon((ILayer)layer, rule);
        }
        if (layer.hasResource(WebMapServer.class)) {
            return null;
        }
        return null;
    }

    private static Rule getRule(Style sld) {
        Rule rule = null;
        int size = 0;
        FeatureTypeStyle[] featureTypeStyleArray = sld.getFeatureTypeStyles();
        int n = featureTypeStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureTypeStyle style = featureTypeStyleArray[n2];
            Rule[] ruleArray = style.getRules();
            int n3 = ruleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Rule potentialRule = ruleArray[n4];
                if (potentialRule != null) {
                    Symbolizer[] symbs = potentialRule.getSymbolizers();
                    int m = 0;
                    while (m < symbs.length) {
                        int newSize;
                        if (symbs[m] instanceof PointSymbolizer) {
                            newSize = SLDs.pointSize((PointSymbolizer)((PointSymbolizer)symbs[m]));
                            if (newSize > 16 && size != 0) {
                                return rule;
                            }
                        } else {
                            return potentialRule;
                        }
                        size = newSize;
                        rule = potentialRule;
                        ++m;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return rule;
    }

    public static ImageDescriptor generateStyledIcon(ILayer layer, Rule rule) {
        ImageDescriptor icon;
        ImageDescriptor infoIcon;
        IGeoResourceInfo info;
        IGeoResource resource;
        SimpleFeatureType type;
        GeometryDescriptor geom;
        if (layer.hasResource(FeatureSource.class) && rule != null && (geom = (type = layer.getSchema()).getGeometryDescriptor()) != null) {
            Class geom_type = geom.getType().getBinding();
            if (geom_type == Point.class || geom_type == MultiPoint.class) {
                return Glyph.point((Rule)rule);
            }
            if (geom_type == LineString.class || geom_type == MultiLineString.class) {
                return Glyph.line((Rule)rule);
            }
            if (geom_type == Polygon.class || geom_type == MultiPolygon.class) {
                return Glyph.polygon((Rule)rule);
            }
            if (geom_type == Geometry.class || geom_type == GeometryCollection.class) {
                return Glyph.geometry((Rule)rule);
            }
        }
        if ((resource = layer.findGeoResource(FeatureSource.class)) == null) {
            return null;
        }
        try {
            info = resource.getInfo(null);
        }
        catch (IOException iOException) {
            info = null;
        }
        if (info != null && (infoIcon = info.getImageDescriptor()) != null) {
            return infoIcon;
        }
        if (resource.canResolve(GridCoverageReader.class) && (icon = Glyph.grid(null, null, null, null)) != null) {
            return icon;
        }
        if (resource.canResolve(FeatureSource.class) && (icon = Glyph.geometry((Rule)rule)) != null) {
            return icon;
        }
        return null;
    }

    static ImageDescriptor generateDefaultIcon(Layer layer) {
        ImageDescriptor icon;
        ImageDescriptor infoIcon;
        SimpleFeatureType type;
        GeometryDescriptor geom;
        if (layer.hasResource(WebMapServer.class) && layer.hasResource(ImageDescriptor.class)) {
            try {
                ImageDescriptor legendGraphic = (ImageDescriptor)layer.getResource(ImageDescriptor.class, null);
                if (legendGraphic != null) {
                    return legendGraphic;
                }
            }
            catch (IOException iOException) {}
        }
        if (layer.hasResource(FeatureSource.class) && (geom = (type = layer.getSchema()).getGeometryDescriptor()) != null) {
            Class geom_type = geom.getType().getBinding();
            if (geom_type == Point.class || geom_type == MultiPoint.class) {
                return Glyph.point(null, null);
            }
            if (geom_type == LineString.class || geom_type == MultiLineString.class) {
                return Glyph.line(null, (int)-1);
            }
            if (geom_type == Polygon.class || geom_type == MultiPolygon.class) {
                return Glyph.polygon(null, null, (int)-1);
            }
            if (geom_type == Geometry.class || geom_type == GeometryCollection.class) {
                return Glyph.geometry(null, null);
            }
            return Glyph.geometry(null, null);
        }
        IGeoResourceInfo info = null;
        try {
            if (!layer.getGeoResources().isEmpty()) {
                info = ((IGeoResource)layer.getGeoResources().get(0)).getInfo(null);
            }
        }
        catch (IOException iOException) {}
        if (info != null && (infoIcon = info.getImageDescriptor()) != null) {
            return infoIcon;
        }
        if (layer.hasResource(GridCoverageReader.class) && (icon = Glyph.grid(null, null, null, null)) != null) {
            return icon;
        }
        if (layer.hasResource(FeatureSource.class) && (icon = Glyph.geometry(null, null)) != null) {
            return icon;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decorateText(String text, Object element) {
        if (!(element instanceof Layer)) {
            return null;
        }
        Layer layer = (Layer)element;
        try {
            String label = LayerGeneratedGlyphDecorator.label(layer);
            if (label != null && label.length() != 0) {
                return label;
            }
            LinkedList<Layer> linkedList = this.queue;
            synchronized (linkedList) {
                if (!this.queue.contains(layer)) {
                    this.queue.add(layer);
                    this.picasso.schedule();
                }
            }
        }
        catch (Throwable problem) {
            ProjectUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.project.ui", 1, "Generated name unavailable " + layer, problem));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image decorateImage(Image origionalImage, Object element) {
        if (!(element instanceof Layer)) {
            return null;
        }
        Layer layer = (Layer)element;
        if (layer.getIcon() != null) {
            return null;
        }
        ImageDescriptor icon = (ImageDescriptor)layer.getProperties().get("generated icon");
        if (icon == null) {
            LinkedList<Layer> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.add(layer);
                this.picasso.schedule();
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.picasso.cancel();
        Thread.yield();
        this.disposed = true;
        this.queue.clear();
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (cache != null) {
            cache.dispose();
            cache = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }
}

