/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.List;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.tool.display.ModalToolCategory;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public class LayerApplicabilityMenuCreator {
    MenuManager manager = new MenuManager(Messages.LayerApplicabilityMenuCreator_ApplicabilityMenuName);

    public LayerApplicabilityMenuCreator() {
        List<ModalToolCategory> list = ApplicationGIS.getToolManager().getModalToolCategories();
        for (ModalToolCategory element : list) {
            this.manager.add((IContributionItem)new ApplicabilityAction(element));
        }
    }

    public MenuManager getMenuManager() {
        return this.manager;
    }

    private static class ApplicabilityAction
    extends ContributionItem {
        private MenuItem menuItem;
        private ModalToolCategory category;

        public ApplicabilityAction(ModalToolCategory category) {
            this.category = category;
        }

        public void runWithEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            for (Layer layer : selection) {
                layer.setInteraction(Interaction.getInteraction((String)this.category.getId()), !this.menuItem.getSelection());
            }
        }

        public void fill(Menu menu, int index) {
            if (this.menuItem != null && !this.menuItem.isDisposed()) {
                this.menuItem.dispose();
            }
            this.menuItem = new MenuItem(menu, 32, index);
            IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            Layer layer = (Layer)selection.getFirstElement();
            ModalToolCategory modalToolCategory = this.category;
            if (this.category != null) {
                Interaction key = Interaction.getInteraction((String)modalToolCategory.getId());
                boolean interaction = layer.getInteraction(key);
                this.menuItem.setSelection(interaction);
                this.menuItem.setText(modalToolCategory.getName());
            }
        }

        public void dispose() {
            super.dispose();
            this.menuItem.dispose();
        }
    }
}

