/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class FeatureTypeMatch {
    public static final FeatureTypeMatch ALL = new FeatureTypeMatch(){

        @Override
        public int matches(Object firstElement) {
            if (firstElement == null) {
                return -1;
            }
            return 0x7FFFFFFE;
        }
    };
    private URI namespace;
    private String typeName;
    private AttributeMatcher[] attributes;
    public static int PERFECT = 0;
    public static int NO_MATCH = -1;

    FeatureTypeMatch() {
    }

    public FeatureTypeMatch(IConfigurationElement element) {
        if (element.getChildren("typeName").length == 1) {
            IConfigurationElement typeName = element.getChildren("typeName")[0];
            this.typeName = typeName.getAttribute("name");
            try {
                this.namespace = new URI(typeName.getAttribute("namespace"));
            }
            catch (Exception e) {
                ProjectUIPlugin.log(Messages.FeatureTypeMatch_BadURI, e);
            }
        } else {
            IConfigurationElement[] attributes = element.getChildren("attribute");
            this.attributes = new AttributeMatcher[attributes.length];
            int i = 0;
            while (i < attributes.length) {
                IConfigurationElement attr = attributes[i];
                this.attributes[i] = new AttributeMatcher(attr);
                ++i;
            }
        }
    }

    public boolean isMatch(Object element) {
        int matches = this.matches(element);
        return matches > -1;
    }

    public int matches(Object element) {
        SimpleFeatureType schema = null;
        if (element instanceof SimpleFeature) {
            schema = ((SimpleFeature)element).getFeatureType();
        } else if (element instanceof SimpleFeatureType) {
            schema = (SimpleFeatureType)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            if (adaptable.getAdapter(SimpleFeatureType.class) != null) {
                schema = (SimpleFeatureType)adaptable.getAdapter(SimpleFeatureType.class);
            } else if (adaptable.getAdapter(SimpleFeature.class) != null) {
                schema = ((SimpleFeature)adaptable.getAdapter(SimpleFeatureType.class)).getFeatureType();
            }
        }
        if (schema != null) {
            AttributeDescriptor currentMatch;
            AttributeMatcher current;
            Name featureName = schema.getName();
            if (this.namespace != null) {
                if (this.namespace.compareTo(URI.create(featureName.getNamespaceURI())) == 0 && this.typeName.equals(featureName.getLocalPart())) {
                    return PERFECT;
                }
                return NO_MATCH;
            }
            if (this.attributes.length == 0) {
                return NO_MATCH;
            }
            int accuracy = 0;
            ++accuracy;
            ArrayList<AttributeDescriptor> matched = new ArrayList<AttributeDescriptor>();
            AttributeMatcher[] attributeMatcherArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                current = attributeMatcherArray[n2];
                if (current.name != null) {
                    currentMatch = current.match(schema, matched);
                    if (currentMatch == null) {
                        return NO_MATCH;
                    }
                    matched.add(currentMatch);
                }
                ++n2;
            }
            attributeMatcherArray = this.attributes;
            n = this.attributes.length;
            n2 = 0;
            while (n2 < n) {
                current = attributeMatcherArray[n2];
                if (current.name == null) {
                    ++accuracy;
                    currentMatch = current.match(schema, matched);
                    if (currentMatch == null) {
                        return NO_MATCH;
                    }
                    matched.add(currentMatch);
                }
                ++n2;
            }
            return accuracy += schema.getAttributeCount() - matched.size();
        }
        return NO_MATCH;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FeatureTypeMatch ");
        if (this.namespace != null) {
            buf.append(this.namespace);
        }
        buf.append(this.typeName);
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.length) {
                buf.append(this.attributes[i]);
                if (i < this.attributes.length - 1) {
                    buf.append(",");
                }
                ++i;
            }
        }
        return buf.toString();
    }

    protected static class AttributeMatcher {
        String name;
        Class<?> type;

        public AttributeMatcher(IConfigurationElement attr) {
            this.name = attr.getAttribute("name");
            try {
                this.type = Class.forName(attr.getAttribute("type"));
            }
            catch (Exception e) {
                ProjectUIPlugin.log("Extension declaration incorrect:" + attr.getDeclaringExtension().getUniqueIdentifier(), e);
            }
        }

        public AttributeDescriptor match(SimpleFeatureType featureType, List<AttributeDescriptor> used) {
            if (this.name != null) {
                AttributeDescriptor attr = featureType.getDescriptor(this.name);
                if (this.type == null || attr == null) {
                    return null;
                }
                if (this.type != attr.getType().getBinding()) {
                    return null;
                }
                return attr;
            }
            int i = 0;
            while (i < featureType.getAttributeCount()) {
                if (!used.contains(featureType.getDescriptor(i)) && this.type == featureType.getDescriptor(i).getType().getBinding()) {
                    return featureType.getDescriptor(i);
                }
                ++i;
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("match(");
            if (this.name != null) {
                buf.append(this.name);
            }
            if (this.type != null) {
                buf.append(" ");
                buf.append(this.type.getSimpleName());
            }
            buf.append(")");
            return buf.toString();
        }
    }
}

