/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.IUDIGDialogPage;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.internal.FeatureEditorLoader;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.ToolContext;
import net.refractions.udig.project.ui.internal.tool.impl.ToolContextImpl;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureEditorExtensionProcessor {
    FeatureEditorViewpartListener partListener;
    Map<SimpleFeatureType, EditActionContribution> selectedEditors = new HashMap<SimpleFeatureType, EditActionContribution>();
    List<FeatureEditorLoader> editorLoaders = new ArrayList<FeatureEditorLoader>();
    static final String CURRENT_LOADER_ID = "FeatureEditorCurrentLoader";
    private static final String FEATURE_EDITOR_ID = "net.refractions.udig.project.ui.featureEditor";
    private boolean running;

    public FeatureEditorExtensionProcessor() {
        List list = ExtensionPointList.getExtensionPointList((String)FEATURE_EDITOR_ID);
        for (IConfigurationElement element : list) {
            FeatureEditorLoader loader = new FeatureEditorLoader(this, element);
            ScopedPreferenceStore preferences = ProjectPlugin.getPlugin().getPreferenceStore();
            if (loader.id.equals(preferences.getString("P_DEFAULT_FEATURE_EDITOR"))) {
                this.editorLoaders.add(0, loader);
                continue;
            }
            this.editorLoaders.add(loader);
        }
    }

    public IContributionItem getEditFeatureAction(ISelection selection) {
        if (selection.isEmpty()) {
            return new GroupMarker("editAction");
        }
        if (!(selection instanceof IStructuredSelection)) {
            return new GroupMarker("editAction");
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (!this.sameFeatureTypes(structuredSelection)) {
            return new GroupMarker("editAction");
        }
        SimpleFeature feature = (SimpleFeature)structuredSelection.getFirstElement();
        IContributionItem item = (IContributionItem)this.selectedEditors.get(feature.getFeatureType());
        if (item != null) {
            return item;
        }
        FeatureEditorLoader loader = this.getClosestMatch(selection);
        if (loader != null) {
            return this.createEditAction(loader, selection, feature);
        }
        return new GroupMarker("editAction");
    }

    public FeatureEditorLoader getClosestMatch(ISelection selection) {
        int bestValue = Integer.MAX_VALUE;
        FeatureEditorLoader best = null;
        for (FeatureEditorLoader loader : this.editorLoaders) {
            int value = loader.match(selection);
            if (value == -1) continue;
            if (value == 0) {
                return loader;
            }
            if (value >= bestValue) continue;
            bestValue = value;
            best = loader;
        }
        return best;
    }

    EditActionContribution createEditAction(FeatureEditorLoader loader, ISelection selection, SimpleFeature feature) {
        EditActionContribution item = new EditActionContribution((IAction)new EditAction(loader, selection));
        this.selectedEditors.put(feature.getFeatureType(), item);
        return item;
    }

    boolean sameFeatureTypes(IStructuredSelection structuredSelection) {
        SimpleFeatureType type = null;
        for (Object obj : structuredSelection) {
            if (!(obj instanceof SimpleFeature)) {
                return false;
            }
            SimpleFeature feature = (SimpleFeature)obj;
            if (type == null) {
                type = feature.getFeatureType();
                continue;
            }
            if (type.equals((Object)feature.getFeatureType())) continue;
            return false;
        }
        return true;
    }

    public IContributionItem getEditWithFeatureMenu(ISelection selection) {
        if (selection.isEmpty()) {
            return new GroupMarker("editWithMenu");
        }
        MenuManager editWithMenu = new MenuManager(Messages.FeatureEditorExtensionProcessor_editWithMenu);
        for (FeatureEditorLoader loader : this.editorLoaders) {
            IAction editorAction = loader.getAction(selection);
            if (editorAction == null) continue;
            editWithMenu.add(editorAction);
        }
        editWithMenu.setVisible(true);
        if (editWithMenu.getItems().length == 0) {
            return new GroupMarker("editWithMenu");
        }
        return editWithMenu;
    }

    public void startPartListener() {
        if (this.partListener == null) {
            this.partListener = new FeatureEditorViewpartListener();
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.partListener);
            this.running = true;
        }
        catch (Exception e) {
            ProjectUIPlugin.log(null, e);
        }
    }

    public void stopPartListener() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.partListener);
        }
        catch (Exception exception) {}
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public FeatureEditorLoader[] getEditorLoaders() {
        return this.editorLoaders.toArray(new FeatureEditorLoader[0]);
    }

    static class EditAction
    extends Action {
        private ISelection selection;
        private final FeatureEditorLoader loader;

        public EditAction(FeatureEditorLoader loader, ISelection selection) {
            super(Messages.FeatureEditorExtensionProcessor_editMenu, loader.icon);
            this.selection = selection;
            this.loader = loader;
            this.setId(loader.id);
        }

        public void runWithEvent(Event event) {
            this.loader.open(event.display, this.selection);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }
    }

    static class EditActionContribution
    extends ActionContributionItem {
        private EditAction editAction;

        public EditActionContribution(IAction action) {
            super(action);
            this.editAction = (EditAction)action;
        }

        public void setSelection(ISelection selection) {
            this.editAction.setSelection(selection);
        }
    }

    static class EditorDialog
    extends Dialog {
        private IUDIGDialogPage page;

        protected EditorDialog(Shell parentShell, IUDIGDialogPage page) {
            super(parentShell);
            this.page = page;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.page.createControl(composite);
            GridData data = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)data);
            this.page.getControl().setLayoutData((Object)data);
            return composite;
        }
    }

    static class FeatureEditorViewpartListener
    extends AdapterImpl
    implements IPartListener2 {
        ToolContext currentContext;
        private List<IUDIGView> views = new ArrayList<IUDIGView>();

        FeatureEditorViewpartListener() {
            IViewReference[] refs;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                IWorkbenchPart part = reference.getPart(false);
                if (page.isPartVisible(part) && part instanceof IUDIGView) {
                    this.views.add((IUDIGView)part);
                }
                ++n2;
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            this.partVisible(partRef);
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            this.partVisible(partRef);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) instanceof IUDIGView) {
                this.views.remove(partRef.getPart(false));
            } else if (partRef.getPart(false) instanceof MapPart) {
                MapPart editor = (MapPart)partRef.getPart(false);
                FeatureEditorViewpartListener featureEditorViewpartListener = this;
                synchronized (featureEditorViewpartListener) {
                    if (this.currentContext == null || this.currentContext.getMapInternal() != editor.getMap()) {
                        return;
                    }
                    this.currentContext.getEditManagerInternal().eAdapters().remove((Object)this);
                    this.currentContext = null;
                }
                for (IUDIGView view : this.views) {
                    view.setContext(null);
                }
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public synchronized void partOpened(IWorkbenchPartReference partRef) {
            this.partVisible(partRef);
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) instanceof IUDIGView) {
                SimpleFeature editFeature;
                ToolContext copy;
                IUDIGView udigview = (IUDIGView)partRef.getPart(false);
                if (!this.views.contains(udigview)) {
                    this.views.add(udigview);
                }
                FeatureEditorViewpartListener featureEditorViewpartListener = this;
                synchronized (featureEditorViewpartListener) {
                    if (!this.validateContext(this.currentContext)) {
                        return;
                    }
                    copy = this.currentContext.copy();
                    editFeature = this.currentContext.getEditManager().getEditFeature();
                }
                try {
                    udigview.setContext(copy);
                    if (editFeature != null) {
                        udigview.editFeatureChanged(editFeature);
                    }
                }
                catch (Throwable e) {
                    UiPlugin.log((String)(udigview + " threw an exception"), (Throwable)e);
                }
            } else if (partRef.getPart(false) instanceof MapPart) {
                MapPart editor = (MapPart)partRef.getPart(false);
                FeatureEditorViewpartListener featureEditorViewpartListener = this;
                synchronized (featureEditorViewpartListener) {
                    if (this.currentContext != null && this.currentContext.getMapInternal() == editor.getMap()) {
                        return;
                    }
                    if (this.currentContext != null) {
                        this.currentContext.getEditManagerInternal().eAdapters().remove((Object)this);
                    }
                    this.currentContext = new ToolContextImpl();
                    this.currentContext.setMapInternal(editor.getMap());
                    this.currentContext.setRenderManagerInternal(editor.getMap().getRenderManagerInternal());
                    this.currentContext.getEditManagerInternal().eAdapters().add((Object)this);
                    for (IUDIGView view : this.views) {
                        try {
                            view.setContext(this.currentContext);
                        }
                        catch (Throwable e) {
                            UiPlugin.log((String)(view + " threw an exception"), (Throwable)e);
                        }
                    }
                }
            }
        }

        private boolean validateContext(ToolContext currentContext2) {
            if (currentContext2 == null) {
                return false;
            }
            if (currentContext2.getMap() == null) {
                return false;
            }
            if (currentContext2.getViewportModel() == null) {
                return false;
            }
            if (currentContext2.getRenderManager() == null) {
                return false;
            }
            if (currentContext2.getDisplay() == null) {
                return false;
            }
            return currentContext2.getEditManager() != null;
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void notifyChanged(final Notification msg) {
            if (msg.getNotifier() instanceof EditManager && msg.getFeatureID(EditManager.class) == 0) {
                PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FeatureEditorViewpartListener.this.updateEditFeatureViews(msg);
                    }
                });
            }
        }

        private void updateEditFeatureViews(Notification msg) {
            SimpleFeature newFeature = (SimpleFeature)msg.getNewValue();
            for (IUDIGView view : this.views) {
                try {
                    view.editFeatureChanged(newFeature);
                }
                catch (Throwable e) {
                    UiPlugin.log((String)(view + " threw an exception"), (Throwable)e);
                }
            }
        }
    }
}

