/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.awt.Rectangle;
import java.util.List;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import org.eclipse.core.runtime.IProgressMonitor;

public class FeatureAnimation
extends AbstractDrawCommand
implements IAnimation {
    private int runs = 0;
    private final List<? extends IDrawCommand> commands;
    private final Rectangle validArea;

    public FeatureAnimation(List<? extends IDrawCommand> commands, Rectangle validArea) {
        this.commands = commands;
        this.validArea = validArea;
    }

    @Override
    public short getFrameInterval() {
        return 300;
    }

    @Override
    public void nextFrame() {
        ++this.runs;
    }

    @Override
    public boolean hasNext() {
        return this.runs < 6;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (this.runs % 2 == 0) {
            for (IDrawCommand iDrawCommand : this.commands) {
                iDrawCommand.setGraphics(this.graphics, this.display);
                iDrawCommand.setMap((IMap)this.getMap());
                iDrawCommand.run(monitor);
            }
        }
    }

    @Override
    public Rectangle getValidArea() {
        return this.validArea;
    }

    @Override
    public void setValid(boolean valid) {
        super.setValid(valid);
        for (IDrawCommand iDrawCommand : this.commands) {
            iDrawCommand.setValid(valid);
        }
    }
}

