/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.commands.CreateMapCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapEditorSelectionProvider;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.project.ui.viewers.MapEditDomain;
import net.refractions.udig.project.ui.viewers.MapViewer;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class DefaultMapViewPart
extends ViewPart
implements MapPart,
IDropTargetProvider {
    protected Map map;
    MapViewer viewer;
    private MapEditorSelectionProvider selectionProvider;
    private UDIGDragDropUtilities.DropTargetDescriptor dropTarget;
    private IToolManager toolManager;
    private MapEditDomain editDomain;

    @Override
    public Map getMap() {
        return this.viewer.getMap();
    }

    @Override
    public void openContextMenu() {
        this.viewer.openContextMenu();
    }

    @Override
    public void setFont(Control textArea) {
        this.viewer.setFont(textArea);
    }

    @Override
    public void setSelectionProvider(IMapEditorSelectionProvider selectionProvider) {
        this.viewer.setSelectionProvider(selectionProvider);
    }

    public final void createPartControl(Composite parent) {
        this.editDomain = new MapEditDomain(null);
        try {
            IProgressMonitor monitor = this.getViewSite().getActionBars().getStatusLineManager().getProgressMonitor();
            this.viewer = new MapViewer(parent, 0x20000000);
            ArrayList<IGeoResource> resources = new ArrayList<IGeoResource>();
            this.createResources(resources, monitor);
            IProject activeProject = ApplicationGIS.getActiveProject();
            CreateMapCommand command = new CreateMapCommand("NewMap", resources, activeProject);
            activeProject.sendSync((Command)command);
            Map createdMap = (Map)command.getCreatedMap();
            this.viewer.setMap(createdMap);
            this.viewer.init((IWorkbenchPart)this);
            this.selectionProvider = new MapEditorSelectionProvider();
            this.selectionProvider.setActiveMap((IMap)createdMap, this);
            this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(new Object[]{createdMap}));
            this.createContextMenu();
            if (this.acquireToolbar()) {
                this.toolManager = ApplicationGIS.getToolManager();
                IActionBars bars = this.getViewSite().getActionBars();
                IToolBarManager toolbarManager = bars.getToolBarManager();
                this.toolManager.contributeModalTools(toolbarManager, bars);
                toolbarManager.add((IContributionItem)new Separator());
                this.toolManager.contributeActionTools(toolbarManager, bars);
                this.toolManager.setCurrentEditor(this);
            }
            if (createdMap.getLayersInternal().size() > 0) {
                createdMap.getEditManagerInternal().setSelectedLayer((Layer)createdMap.getLayersInternal().get(createdMap.getMapLayers().size() - 1));
            }
            this.enableDropSupport();
            this.initMap(createdMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected void initMap(Map createdMap) {
        this.viewer.getMap().getViewportModelInternal().zoomToExtent();
    }

    protected abstract void createResources(List<IGeoResource> var1, IProgressMonitor var2) throws IOException;

    protected boolean acquireToolbar() {
        return false;
    }

    public void setFocus() {
        if (this.acquireToolbar()) {
            this.toolManager.setCurrentEditor(this);
        }
        this.viewer.getControl().setFocus();
    }

    public Object getTarget(DropTargetEvent event) {
        return this;
    }

    private void enableDropSupport() {
        this.dropTarget = UDIGDragDropUtilities.addDropSupport((Control)this.viewer.getViewport().getControl(), (IDropTargetProvider)this);
    }

    public void dispose() {
        super.dispose();
        this.dropTarget.target.dispose();
    }

    protected void createContextMenu() {
        Menu menu = this.viewer.getMenu();
        if (menu == null) {
            final MenuManager contextMenu = new MenuManager();
            contextMenu.setRemoveAllWhenShown(true);
            contextMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager mgr) {
                    IToolManager tm = ApplicationGIS.getToolManager();
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add(tm.getBACKWARD_HISTORYAction());
                    contextMenu.add(tm.getFORWARD_HISTORYAction());
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add((IContributionItem)ApplicationGIS.getToolManager().createOperationsContextMenu(DefaultMapViewPart.this.selectionProvider.getSelection()));
                }
            });
            menu = contextMenu.createContextMenu(this.viewer.getViewport().getControl());
            this.viewer.setMenu(menu);
            this.getSite().registerContextMenu(contextMenu, this.getSite().getSelectionProvider());
        }
    }
}

