/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.commands;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.commands.IMapTransformCommand;
import net.refractions.udig.project.ui.commands.IPreMapDrawCommand;
import org.eclipse.core.runtime.IProgressMonitor;

public class TransformDrawCommand
extends AbstractDrawCommand
implements IMapTransformCommand,
IPreMapDrawCommand {
    private double scaleFactorY = 1.0;
    private double scaleFactorX = 1.0;
    private int translateY;
    private int translateX;
    private double rotation;
    private Point fixedPoint;

    @Override
    public Rectangle getValidArea() {
        return null;
    }

    public synchronized void run(IProgressMonitor monitor) throws Exception {
        if (this.fixedPoint == null) {
            this.fixedPoint = new Point(this.display.getWidth() / 2, this.display.getHeight() / 2);
        }
        AffineTransform t = new AffineTransform();
        t.translate(this.fixedPoint.getX(), this.fixedPoint.getY());
        t.rotate(this.rotation);
        t.scale(this.scaleFactorX, this.scaleFactorY);
        t.translate(-this.fixedPoint.getX(), -this.fixedPoint.getY());
        t.translate(this.translateX, this.translateY);
        t.concatenate(this.graphics.getTransform());
        this.graphics.setTransform(t);
    }

    public synchronized void fixPoint(Point fixedPoint) {
        this.fixedPoint = fixedPoint;
    }

    public synchronized void zoom(double scaleFactorX, double scaleFactorY) {
        this.scaleFactorX = scaleFactorX;
        this.scaleFactorY = scaleFactorY;
    }

    public synchronized void pan(int x, int y) {
        this.translateX = x;
        this.translateY = y;
    }

    public synchronized void rotate(double theta) {
        this.rotation = theta;
    }

    public synchronized AffineTransform getTransform() {
        AffineTransform t = new AffineTransform();
        t.translate((double)this.display.getWidth() / 2.0, (double)this.display.getHeight() / 2.0);
        t.rotate(this.rotation);
        t.scale(this.scaleFactorX, this.scaleFactorY);
        t.translate((double)(-this.display.getWidth()) / 2.0, (double)(-this.display.getHeight()) / 2.0);
        t.translate(this.translateX, this.translateY);
        return t;
    }
}

