/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.UDIGEditorInput;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectExplorer;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenProjectElementCommand
implements UndoableCommand {
    IProjectElement element;
    private IEditorPart previous;

    public OpenProjectElementCommand(IProjectElement element) {
        this.element = element;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            monitor.beginTask(Messages.OpenMapCommand_taskName, -1);
            final UDIGEditorInput input = ApplicationGIS.getInput(this.element);
            if (input == null) {
                return;
            }
            input.setProjectElement(this.element);
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    IEditorReference[] editors;
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorReference[] iEditorReferenceArray = editors = activePage.getEditorReferences();
                    int n = editors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference reference = iEditorReferenceArray[n2];
                        try {
                            if (reference.getEditorInput().equals(input)) {
                                OpenProjectElementCommand.this.previous = activePage.getActiveEditor();
                                activePage.activate(reference.getPart(true));
                                return;
                            }
                        }
                        catch (PartInitException partInitException) {}
                        ++n2;
                    }
                    OpenProjectElementCommand.this.openMap(input);
                }
            });
        }
        finally {
            monitor.done();
        }
    }

    private void openMap(UDIGEditorInput input) {
        try {
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, input.getEditorId(), true, 0);
            ProjectExplorer explorer = ProjectExplorer.getProjectExplorer();
            explorer.setSelection(Collections.singleton(input.getProjectElement()), true);
            if (part instanceof MapEditorPart) {
                MapEditorPart mapEditor = (MapEditorPart)part;
                while (!mapEditor.getComposite().isVisible() || !mapEditor.getComposite().isEnabled()) {
                    if (Display.getCurrent().readAndDispatch()) continue;
                    Thread.sleep(300L);
                }
            }
        }
        catch (PartInitException e) {
            ProjectUIPlugin.log(e.getLocalizedMessage(), e);
        }
        catch (InterruptedException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public String getName() {
        return Messages.OpenMapCommand_commandName;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.previous != null) {
            this.previous.getEditorSite().getPage().activate((IWorkbenchPart)this.previous);
            return;
        }
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UDIGEditorInput input = ApplicationGIS.getInput(OpenProjectElementCommand.this.element);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorReference[] editors = activePage.getEditorReferences();
                ArrayList<IEditorReference> matches = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = editors;
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    try {
                        if (reference.getEditorInput().equals(input)) {
                            matches.add(reference);
                        }
                    }
                    catch (PartInitException partInitException) {}
                    ++n2;
                }
                activePage.closeEditors(matches.toArray(new IEditorReference[matches.size()]), true);
            }
        });
    }

    public Command copy() {
        return null;
    }
}

