/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.commands;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.internal.commands.draw.CompositeDrawCommand;
import net.refractions.udig.project.ui.internal.commands.draw.DrawEditFeatureCommand;
import net.refractions.udig.project.ui.internal.commands.draw.DrawFeatureCommand;
import net.refractions.udig.project.ui.internal.commands.draw.DrawShapeCommand;
import net.refractions.udig.project.ui.internal.commands.draw.StartAnimationCommand;
import net.refractions.udig.project.ui.internal.commands.draw.StopAnimationCommand;
import net.refractions.udig.project.ui.internal.commands.draw.TranslateCommand;
import net.refractions.udig.project.ui.internal.commands.draw.ZoomDrawCommand;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DrawCommandFactory {
    private static final DrawCommandFactory instance = new DrawCommandFactory();

    private DrawCommandFactory() {
    }

    public static DrawCommandFactory getInstance() {
        return instance;
    }

    public DrawShapeCommand createDrawShapeCommand(Shape shape, Color paint, int lineStyle, int lineWidth) {
        return new DrawShapeCommand(shape, paint, lineStyle, lineWidth);
    }

    public DrawShapeCommand createDrawShapeCommand(Shape shape, Color paint) {
        return this.createDrawShapeCommand(shape, paint, -1, 1);
    }

    public DrawShapeCommand createDrawShapeCommand(Shape shape) {
        return this.createDrawShapeCommand(shape, null, -1, 1);
    }

    public IDrawCommand createEditFeaturesCommand(IViewportModel model) {
        return new DrawEditFeatureCommand(model);
    }

    public TranslateCommand createTranslateCommand(Point offset) {
        return new TranslateCommand(offset);
    }

    public TranslateCommand createTranslateCommand(int x, int y) {
        return new TranslateCommand(x, y);
    }

    public ZoomDrawCommand createZoomDrawCommand(int centerx, int centery, double amount) {
        return new ZoomDrawCommand(centerx, centery, amount);
    }

    public DrawFeatureCommand createDrawFeatureCommand(SimpleFeature feature, ILayer layer) {
        try {
            return new DrawFeatureCommand(feature, layer);
        }
        catch (IOException iOException) {
            return new DrawFeatureCommand(feature);
        }
    }

    public DrawFeatureCommand createDrawFeatureCommand(SimpleFeature feature) {
        return new DrawFeatureCommand(feature);
    }

    public DrawFeatureCommand createDrawFeatureCommand(SimpleFeature feature, CoordinateReferenceSystem crs) {
        return new DrawFeatureCommand(feature, crs);
    }

    public UndoableMapCommand createStartAnimationCommand(IMapDisplay display, List<IAnimation> animations) {
        return new StartAnimationCommand(display, animations);
    }

    public UndoableMapCommand createStopAnimationCommand(IMapDisplay display, List<IAnimation> animations) {
        return new StopAnimationCommand(display, animations);
    }

    public IDrawCommand createCompositeDrawCommand(IDrawCommand[] commandsArray) {
        return new CompositeDrawCommand(commandsArray);
    }

    public IDrawCommand createCompositeDrawCommand(List<? extends IDrawCommand> commandsList) {
        return new CompositeDrawCommand(commandsList);
    }
}

