/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import java.util.ArrayList;
import net.refractions.udig.core.filter.AdaptingFilter;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectElement;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.opengis.feature.simple.SimpleFeature;

public abstract class UDIGGenericAction
extends WorkbenchWindowActionDelegate {
    public void run(IAction action) {
        Object stateData;
        ISelection sel = this.getSelection();
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        ArrayList<Layer> layers = new ArrayList<Layer>(selection.size());
        Object firstElem = selection.iterator().next();
        if (firstElem instanceof Project) {
            stateData = this.showErrorMessage(selection.size(), (Project)firstElem);
        } else if (firstElem instanceof IProjectElement) {
            stateData = this.showErrorMessage(selection.size(), (ProjectElement)firstElem);
        } else if (firstElem instanceof Layer) {
            stateData = this.showErrorMessage(selection.size(), (Layer)firstElem);
        } else if (firstElem instanceof SimpleFeature) {
            stateData = this.showErrorMessage(selection.size(), (SimpleFeature)firstElem);
        } else if (firstElem instanceof AdaptingFilter) {
            AdaptingFilter f = (AdaptingFilter)firstElem;
            ILayer layer = (ILayer)f.getAdapter(ILayer.class);
            stateData = this.showErrorMessage(selection.size(), layer, f);
        } else {
            stateData = null;
        }
        for (Object element : selection) {
            if (element instanceof Project) {
                this.operate((Project)element, stateData);
                continue;
            }
            if (element instanceof IProjectElement) {
                this.operate((ProjectElement)element, stateData);
                continue;
            }
            if (element instanceof Layer) {
                layers.add((Layer)element);
                continue;
            }
            if (element instanceof SimpleFeature) {
                this.operate((SimpleFeature)element, stateData);
                continue;
            }
            if (!(element instanceof AdaptingFilter)) continue;
            AdaptingFilter f = (AdaptingFilter)element;
            ILayer layer = (ILayer)f.getAdapter(ILayer.class);
            this.operate(layer, f, stateData);
        }
        if (!layers.isEmpty()) {
            this.operate(layers.toArray(new Layer[layers.size()]), stateData);
        }
    }

    protected Object showErrorMessage(int size, Project firstElement) {
        return null;
    }

    protected Object showErrorMessage(int size, Layer firstElement) {
        return null;
    }

    protected Object showErrorMessage(int size, SimpleFeature firstElement) {
        return null;
    }

    protected Object showErrorMessage(int size, ProjectElement firstElement) {
        return null;
    }

    protected Object showErrorMessage(int size, ILayer layer, AdaptingFilter firstElement) {
        return null;
    }

    protected void operate(ILayer layer, AdaptingFilter filter, Object context) {
    }

    protected void operate(SimpleFeature feature, Object context) {
    }

    protected void operate(Layer[] layers, Object context) {
    }

    protected void operate(ProjectElement element, Object context) {
    }

    protected void operate(Project project, Object context) {
    }
}

