/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.refractions.udig.project.geoselection.AbstractGeoSelectionManager;
import net.refractions.udig.project.geoselection.GeoSelectionChangedEvent;
import net.refractions.udig.project.geoselection.GeoSelectionEntry;
import net.refractions.udig.project.geoselection.IGeoSelection;
import net.refractions.udig.project.geoselection.IGeoSelectionChangedListener;
import net.refractions.udig.project.geoselection.IGeoSelectionEntry;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PlatformGeoSelectionManager
extends AbstractGeoSelectionManager {
    public static final String ID = "net.refractions.udig.project.ui.platformGeoSelectionManager";
    public static Logger LOGGER = Logger.getLogger("net.refractions.udig.project.geoselection");
    public static final String PLATFORM_SELECTION_BAG = "net.refractions.udig.project.ui.PLATFORM_SELECTION_BAG";
    public static final String PLATFORM_SELECTION_CACHE_KEY = "net.refractions.udig.project.ui.PLATFORM_SELECTION_CACHE";
    private MapEditorPartListener partListener = new MapEditorPartListener();
    private List<IGeoSelectionEntry> cachedSelections;
    private IGeoSelectionEntry latestGeoSelection = null;
    private boolean initialized = false;
    protected Map currentMap;

    public PlatformGeoSelectionManager() {
        this.initialize();
    }

    private void initialize() {
        if (!this.initialized) {
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage activePage;
                    IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (ww != null && (activePage = ww.getActivePage()) != null) {
                        activePage.addPartListener((IPartListener2)PlatformGeoSelectionManager.this.partListener);
                        PlatformGeoSelectionManager.this.initialized = true;
                        LOGGER.info("PlatformGeoSelectionManager is INITIALIZED.");
                        Map activeMap = ApplicationGISInternal.getActiveMap();
                        if (activeMap != ApplicationGIS.NO_MAP) {
                            PlatformGeoSelectionManager.this.setCurrentMap(activeMap);
                        }
                    }
                }
            });
        }
    }

    protected void setCurrentMap(Map activeMap) {
        HashMap selectionBag = (HashMap)activeMap.getBlackBoardInternal().get(PLATFORM_SELECTION_BAG);
        if (selectionBag == null) {
            selectionBag = new HashMap();
            activeMap.getBlackBoardInternal().put(PLATFORM_SELECTION_BAG, selectionBag);
            this.cachedSelections = Collections.EMPTY_LIST;
        } else {
            ArrayList cache = new ArrayList(selectionBag.values());
            this.cachedSelections = Collections.unmodifiableList(cache);
        }
        this.currentMap = activeMap;
    }

    private void clearSelections() {
        if (this.currentMap != null) {
            HashMap selectionBag = (HashMap)this.currentMap.getBlackBoardInternal().get(PLATFORM_SELECTION_BAG);
            for (Map.Entry entry : selectionBag.entrySet()) {
                String context = (String)entry.getKey();
                IGeoSelectionEntry selectionEntry = (IGeoSelectionEntry)entry.getValue();
                IGeoSelection oldSelection = selectionEntry.getSelection();
                GeoSelectionChangedEvent event = new GeoSelectionChangedEvent(context, (Object)this.currentMap, oldSelection, null);
                this.fireSelectionChanged(event);
            }
            this.cachedSelections = null;
            this.currentMap = null;
            this.latestGeoSelection = null;
        }
    }

    protected Map getCurrentMap() {
        return this.currentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(String context, IGeoSelection selection) {
        if (this.currentMap == null && !this.initialized) {
            PlatformGeoSelectionManager platformGeoSelectionManager = this;
            synchronized (platformGeoSelectionManager) {
                if (!this.initialized) {
                    this.initialize();
                }
            }
        }
        if (this.currentMap != null) {
            PlatformGeoSelectionManager platformGeoSelectionManager;
            HashMap selectionBag = (HashMap)this.currentMap.getBlackBoardInternal().get(PLATFORM_SELECTION_BAG);
            GeoSelectionEntry entry = (GeoSelectionEntry)selectionBag.get(context);
            IGeoSelection oldSelection = null;
            if (entry == null && selection != null) {
                entry = new GeoSelectionEntry(context);
                entry.setSelection(selection);
                platformGeoSelectionManager = this;
                synchronized (platformGeoSelectionManager) {
                    selectionBag.put(context, entry);
                    ArrayList cache = new ArrayList(selectionBag.values());
                    this.cachedSelections = Collections.unmodifiableList(cache);
                }
            }
            if (entry != null && selection != null) {
                oldSelection = entry.getSelection();
                entry.setSelection(selection);
            } else if (entry != null && selection == null) {
                oldSelection = entry.getSelection();
                platformGeoSelectionManager = this;
                synchronized (platformGeoSelectionManager) {
                    selectionBag.remove(context);
                    ArrayList cache = new ArrayList(selectionBag.values());
                    this.cachedSelections = Collections.unmodifiableList(cache);
                }
            }
            this.latestGeoSelection = selection != null ? entry : null;
            GeoSelectionChangedEvent event = new GeoSelectionChangedEvent(context, (Object)this.currentMap, oldSelection, selection);
            this.fireSelectionChanged(event);
        } else {
            LOGGER.info("PlatformGeoSelectionManager: there is no active Map or manager is not initialized properly");
        }
    }

    public IGeoSelection getSelection(String context) {
        if (this.currentMap != null) {
            HashMap selectionBag = (HashMap)this.currentMap.getBlackBoardInternal().get(PLATFORM_SELECTION_BAG);
            IGeoSelectionEntry entry = (IGeoSelectionEntry)selectionBag.get(context);
            if (entry == null) {
                return null;
            }
            IGeoSelection selection = entry.getSelection();
            return selection;
        }
        return null;
    }

    protected void fireSelectionChanged(GeoSelectionChangedEvent event) {
        Object[] listenersArray;
        LOGGER.fine("PlatformGeoSelectionManager: new IGeoSelection is set and an event is fired to listeners");
        Object[] objectArray = listenersArray = this.listeners.getListeners();
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            try {
                IGeoSelectionChangedListener listener = (IGeoSelectionChangedListener)listenerObj;
                listener.geoSelectionChanged(event);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.getMessage(), t);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<IGeoSelectionEntry> getSelections() {
        Iterator<IGeoSelectionEntry> it;
        PlatformGeoSelectionManager platformGeoSelectionManager = this;
        synchronized (platformGeoSelectionManager) {
            it = this.cachedSelections.iterator();
        }
        return it;
    }

    public IGeoSelectionEntry getLatestSelection() {
        return this.latestGeoSelection;
    }

    class MapEditorPartListener
    implements IPartListener2 {
        MapEditorPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) instanceof MapEditorPart) {
                Map activeMap = ((MapEditorPart)partRef.getPart(false)).getMap();
                PlatformGeoSelectionManager.this.setCurrentMap(activeMap);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) instanceof MapEditorPart) {
                IEditorPart part;
                System.out.println("MapEditor is closed");
                if (!PlatformUI.getWorkbench().isClosing() && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) == null) {
                    LOGGER.log(Level.FINE, "The last MapEditor was closed. Notify listeners with NULL geoselection");
                    PlatformGeoSelectionManager.this.clearSelections();
                }
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }
}

