/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import java.util.ArrayList;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.internal.FeatureEditorLoader;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class FeatureEditorFieldEditor
extends FieldEditor {
    private Combo combo;
    private GridData data;
    private ArrayList<String> choices = new ArrayList();
    private ArrayList<String> ids = new ArrayList();

    public FeatureEditorFieldEditor(Composite parent) {
        FeatureEditorLoader[] loaders;
        this.setPreferenceStore((IPreferenceStore)ProjectPlugin.getPlugin().getPreferenceStore());
        FeatureEditorLoader[] featureEditorLoaderArray = loaders = ProjectUIPlugin.getDefault().getFeatureEditProcessor().getEditorLoaders();
        int n = loaders.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEditorLoader loader = featureEditorLoaderArray[n2];
            this.choices.add(loader.getName());
            this.ids.add(loader.getId());
            ++n2;
        }
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.data != null) {
            this.data.horizontalSpan = numColumns - 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FeatureEditorFieldEditor_label);
        label.setLayoutData((Object)new GridData(4, 128, true, true));
        this.combo = new Combo(parent, -1);
        this.data = new GridData(4, 128, true, true);
        this.data.horizontalSpan = numColumns - 1;
        this.combo.setLayoutData((Object)this.data);
        this.combo.setItems(this.choices.toArray(new String[0]));
    }

    protected void doLoad() {
        if (this.combo != null) {
            int indexOf = this.ids.indexOf(this.getPreferenceStore().getString("P_DEFAULT_FEATURE_EDITOR"));
            if (indexOf == -1) {
                this.doLoadDefault();
            } else {
                this.combo.select(indexOf);
            }
        }
    }

    protected void doLoadDefault() {
        int indexOf = this.ids.indexOf(this.getPreferenceStore().getDefaultString("P_DEFAULT_FEATURE_EDITOR"));
        if (indexOf == -1) {
            this.combo.select(0);
        } else {
            this.combo.select(indexOf);
        }
    }

    protected void doStore() {
        int selectionIndex = this.combo.getSelectionIndex();
        String defaultEditorID = "";
        if (selectionIndex != -1) {
            defaultEditorID = this.ids.get(selectionIndex);
        }
        this.getPreferenceStore().setValue("P_DEFAULT_FEATURE_EDITOR", defaultEditorID);
    }

    public int getNumberOfControls() {
        return 2;
    }
}

