/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class BoundsStrategy {
    protected double scaleDenominator;
    protected ReferencedEnvelope boundsToDisplay;

    protected BoundsStrategy() {
    }

    public BoundsStrategy(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
        this.boundsToDisplay = null;
    }

    public BoundsStrategy(ReferencedEnvelope boundsToDisplay) {
        this.scaleDenominator = -1.0;
        this.boundsToDisplay = boundsToDisplay;
    }

    public void setBounds(ViewportModel model, ReferencedEnvelope currentBounds) {
        if (this.boundsToDisplay != null) {
            ReferencedEnvelope destinationBox = this.boundsToDisplay;
            try {
                destinationBox = this.boundsToDisplay.transform(model.getCRS(), true);
            }
            catch (TransformException e) {
                ProjectUIPlugin.log("Unable to transform to the viewport's CRS (ApplicationGIS#drawMap()", e);
            }
            catch (FactoryException e) {
                ProjectUIPlugin.log("Unable to transform to the viewport's CRS (ApplicationGIS#drawMap()", e);
            }
            model.zoomToBox((Envelope)destinationBox);
        } else {
            model.setBounds(currentBounds);
            if (this.scaleDenominator > 0.0) {
                model.setScale(this.scaleDenominator);
            }
        }
    }
}

