/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class AnimationUpdater {
    private static boolean testing = false;
    final List<IAnimation> animations = new CopyOnWriteArrayList<IAnimation>();
    private ViewportPane display;
    private short frameInterval;
    private static TreeMap<Short, List<AnimationUpdater>> displayToTaskMap = new TreeMap();
    private static final short MIN_INTERVAL = 100;

    public AnimationUpdater(ViewportPane display, short frameInterval) {
        this.display = display;
        this.frameInterval = frameInterval;
    }

    public void run() {
        LinkedList<IAnimation> toRemove = new LinkedList<IAnimation>();
        for (IAnimation anim : this.animations) {
            if (anim.hasNext()) {
                anim.nextFrame();
            } else {
                anim.setValid(false);
                anim.dispose();
                toRemove.add(anim);
            }
            this.animations.removeAll(toRemove);
            if (!AnimationUpdater.isTesting()) continue;
            try {
                anim.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        if (!AnimationUpdater.isTesting()) {
            this.display.repaint();
        }
        if (this.animations.size() == 0) {
            this.remove(this);
        } else {
            RunUpdaters next = this.next();
            if (next != null) {
                short elapseTime = next.frameinterval <= this.frameInterval ? next.frameinterval : (short)(next.frameinterval - this.frameInterval);
                AnimationUpdater.runTimer(elapseTime, next);
            }
        }
    }

    static boolean isTesting() {
        return testing;
    }

    public static void setTesting(boolean isTesting) {
        testing = isTesting;
    }

    private static void runTimer(final short frameInterval, final RunUpdaters next) {
        if (Display.getCurrent() == null) {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Display.getCurrent().timerExec((int)frameInterval, (Runnable)next);
                }
            });
        } else {
            Display display = Display.getCurrent();
            display.timerExec((int)frameInterval, (Runnable)next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunUpdaters next() {
        Class<AnimationUpdater> clazz = AnimationUpdater.class;
        synchronized (AnimationUpdater.class) {
            SortedMap<Short, List<AnimationUpdater>> tailMap = displayToTaskMap.tailMap(this.frameInterval);
            if (tailMap.isEmpty()) {
                if (displayToTaskMap.size() > 0) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return new RunUpdaters(displayToTaskMap.firstKey());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new RunUpdaters(this.frameInterval);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new RunUpdaters(tailMap.keySet().iterator().next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(AnimationUpdater updater) {
        Class<AnimationUpdater> clazz = AnimationUpdater.class;
        synchronized (AnimationUpdater.class) {
            List<AnimationUpdater> hashMap = displayToTaskMap.get(updater.frameInterval);
            if (hashMap != null) {
                hashMap.remove(updater);
                if (hashMap.isEmpty()) {
                    displayToTaskMap.remove(this.frameInterval);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void runTimer(IMapDisplay mapDisplay, IAnimation animation) {
        if (!ProjectPlugin.getPlugin().getPreferenceStore().getBoolean("P_SHOW_ANIMATIONS")) {
            return;
        }
        if (!(mapDisplay instanceof ViewportPane)) {
            ProjectUIPlugin.log("Map Display provided is not a ViewportPane and therefore does not support animation", new RuntimeException());
            return;
        }
        short frameInterval = AnimationUpdater.calculateFrameInterval(animation);
        ViewportPane viewport = (ViewportPane)mapDisplay;
        List<AnimationUpdater> tasks = displayToTaskMap.get(frameInterval);
        boolean requiresRun = false;
        if (tasks == null) {
            requiresRun = true;
            tasks = new CopyOnWriteArrayList<AnimationUpdater>();
            displayToTaskMap.put(frameInterval, tasks);
        }
        AnimationUpdater updater = AnimationUpdater.findUpdater(frameInterval, viewport);
        viewport.addDrawCommand(animation);
        if (updater != null) {
            updater.getAnimations().add(animation);
        } else {
            AnimationUpdater task = new AnimationUpdater(viewport, frameInterval);
            task.getAnimations().add(animation);
            tasks.add(task);
            if (requiresRun) {
                AnimationUpdater.runTimer(frameInterval, new RunUpdaters(frameInterval));
            }
        }
        Rectangle bounds = animation.getValidArea();
        if (bounds == null) {
            viewport.repaint();
        } else {
            viewport.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    private static AnimationUpdater findUpdater(short frameInterval2, ViewportPane viewport) {
        List<AnimationUpdater> updaters = displayToTaskMap.get(frameInterval2);
        if (updaters == null) {
            return null;
        }
        for (AnimationUpdater updater : updaters) {
            if (updater.display != viewport) continue;
            return updater;
        }
        return null;
    }

    private static short calculateFrameInterval(IAnimation animation) {
        short frameInterval = animation.getFrameInterval();
        int i = frameInterval - 100 * (frameInterval / 100);
        if ((frameInterval = (short)(frameInterval - i)) < 100) {
            frameInterval = 100;
        }
        return (short)frameInterval;
    }

    public List<IAnimation> getAnimations() {
        return this.animations;
    }

    public short getFrameInterval() {
        return this.frameInterval;
    }

    private static class RunUpdaters
    implements Runnable {
        private short frameinterval;

        public RunUpdaters(short frameInterval) {
            this.frameinterval = frameInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<AnimationUpdater> clazz = AnimationUpdater.class;
            synchronized (AnimationUpdater.class) {
                List updaters = (List)displayToTaskMap.get(this.frameinterval);
                for (AnimationUpdater updater : updaters) {
                    if (!updater.display.isDisposed() && updater.display.isVisible()) {
                        updater.run();
                        continue;
                    }
                    for (IAnimation anim : updater.getAnimations()) {
                        anim.setValid(false);
                        anim.dispose();
                    }
                    updater.remove(updater);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

