/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import net.refractions.udig.project.internal.provider.LoadingPlaceHolder;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class AdapterFactoryLabelProviderDecorator
extends DecoratingLabelProvider {
    StructuredViewer viewer;

    public AdapterFactoryLabelProviderDecorator(AdapterFactory factory, StructuredViewer viewer) {
        super((ILabelProvider)new LabelProvider(factory), AdapterFactoryLabelProviderDecorator.getWorkbenchDecorators());
        this.viewer = viewer;
    }

    static final ILabelDecorator getWorkbenchDecorators() {
        IDecoratorManager manager = PlatformUI.getWorkbench().getDecoratorManager();
        ILabelDecorator decorator = manager.getLabelDecorator();
        return decorator;
    }

    public String getText(Object element) {
        if (element instanceof LoadingPlaceHolder) {
            return ((LoadingPlaceHolder)element).getText();
        }
        if (!this.viewer.getControl().isDisposed()) {
            return super.getText(element);
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof LoadingPlaceHolder) {
            return ((LoadingPlaceHolder)element).getImage();
        }
        if (!this.viewer.getControl().isDisposed()) {
            return super.getImage(element);
        }
        return null;
    }

    public void dispose() {
        this.getLabelProvider().dispose();
        super.dispose();
    }

    private static class LabelProvider
    extends AdapterFactoryLabelProvider
    implements IColorProvider {
        public LabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Color getForeground(Object object) {
            IColorProvider colorProvider = (IColorProvider)this.adapterFactory.adapt(object, IColorProvider.class);
            if (colorProvider != null) {
                return colorProvider.getForeground(object);
            }
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
            if (itemLabelProvider instanceof IColorProvider) {
                colorProvider = (IColorProvider)itemLabelProvider;
                return colorProvider.getForeground(object);
            }
            return null;
        }

        public Color getBackground(Object object) {
            IColorProvider colorProvider = (IColorProvider)this.adapterFactory.adapt(object, IColorProvider.class);
            if (colorProvider != null) {
                return colorProvider.getBackground(object);
            }
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
            if (itemLabelProvider instanceof IColorProvider) {
                colorProvider = (IColorProvider)itemLabelProvider;
                return colorProvider.getBackground(object);
            }
            return null;
        }
    }
}

