/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.PostgisGeoResource2;
import net.refractions.udig.catalog.PostgisService2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PostgisServiceInfo
extends IServiceInfo {
    private PostgisService2 service;

    public PostgisServiceInfo(PostgisService2 service) throws IOException {
        this.service = service;
        ArrayList<String> tmpKeywords = new ArrayList<String>();
        tmpKeywords.add("Postgis");
        List<PostgisGeoResource2> resources = service.resources((IProgressMonitor)new NullProgressMonitor());
        for (PostgisGeoResource2 postgisGeoResource2 : resources) {
            tmpKeywords.add(postgisGeoResource2.typename);
        }
        this.keywords = tmpKeywords.toArray(new String[0]);
        try {
            this.schema = new URI("jdbc://postgis/gml");
        }
        catch (URISyntaxException e) {
            PostgisPlugin.log(null, e);
        }
        this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.catalog.internal.postgis", (String)"icons/obj16/postgis_16.gif");
    }

    public String getDescription() {
        return this.service.getIdentifier().toString();
    }

    public URI getSource() {
        try {
            return this.service.getIdentifier().toURI();
        }
        catch (URISyntaxException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public String getTitle() {
        return this.service.getTitle();
    }
}

