/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.AbstractDataStoreServiceExtension;
import net.refractions.udig.catalog.PostgisService2;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import net.refractions.udig.catalog.internal.postgis.ui.PostgisServiceDialect;
import net.refractions.udig.catalog.postgis.internal.Messages;
import net.refractions.udig.core.Pair;
import org.eclipse.core.runtime.Platform;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class PostgisServiceExtension2
extends AbstractDataStoreServiceExtension
implements ServiceExtension2 {
    public static final String TYPE = (String)JDBCDataStoreFactory.DBTYPE.sample;
    private static final String IN_TESTING = "testing";
    public static final PostgisServiceDialect DIALECT = new PostgisServiceDialect();
    private static PostgisNGDataStoreFactory factory;

    public PostgisService2 createService(URL id, Map<String, Serializable> params) {
        Pair<Map<String, Serializable>, String> split;
        URL finalID;
        block10: {
            block9: {
                try {
                    if (PostgisServiceExtension2.getFactory() != null && PostgisServiceExtension2.getFactory().isAvailable()) break block9;
                    return null;
                }
                catch (Exception unexpected) {
                    if (Platform.inDevelopmentMode()) {
                        PostgisPlugin.log("PostGISExtension canProcess errored out with: " + unexpected, unexpected);
                    }
                    return null;
                }
            }
            if (!PostgisServiceExtension2.getFactory().canProcess(params)) {
                return null;
            }
            if (this.reasonForFailure(params) != null) {
                return null;
            }
            Map<String, Serializable> params2 = params;
            this.ensurePortIsInt(params2);
            try {
                finalID = DIALECT.toURL(params2);
                split = this.processParams(params2);
                if (split.getRight() == null) break block10;
                return null;
            }
            catch (MalformedURLException e) {
                PostgisPlugin.log("Unable to construct proper service URL.", e);
                return null;
            }
        }
        return new PostgisService2(finalID, (Map)split.getLeft());
    }

    private void ensurePortIsInt(Map<String, Serializable> params) {
        if (params != null && params.containsKey(PostgisNGDataStoreFactory.PORT.key) && params.get(PostgisNGDataStoreFactory.PORT.key) instanceof String) {
            int val = new Integer((String)((Object)params.get(PostgisNGDataStoreFactory.PORT.key)));
            params.put(PostgisNGDataStoreFactory.PORT.key, Integer.valueOf(val));
        }
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!PostgisServiceExtension2.isPostGIS(url)) {
            return null;
        }
        AbstractDataStoreServiceExtension.ParamInfo info = this.parseParamInfo(url);
        HashMap<String, Serializable> postGISParams = new HashMap<String, Serializable>();
        postGISParams.put(JDBCDataStoreFactory.DBTYPE.key, (Serializable)JDBCDataStoreFactory.DBTYPE.sample);
        postGISParams.put(JDBCDataStoreFactory.USER.key, (Serializable)((Object)info.username));
        postGISParams.put(JDBCDataStoreFactory.PASSWD.key, (Serializable)((Object)info.password));
        postGISParams.put(JDBCDataStoreFactory.HOST.key, (Serializable)((Object)info.host));
        postGISParams.put(JDBCDataStoreFactory.DATABASE.key, (Serializable)((Object)info.the_database));
        postGISParams.put(PostgisNGDataStoreFactory.PORT.key, info.the_port);
        postGISParams.put(PostgisNGDataStoreFactory.SCHEMA.key, (Serializable)((Object)info.the_schema));
        return postGISParams;
    }

    public static synchronized PostgisNGDataStoreFactory getFactory() {
        if (factory == null) {
            factory = new PostgisNGDataStoreFactory();
        }
        return factory;
    }

    public static DataAccessFactory.Param getPram(String key) {
        DataAccessFactory.Param[] paramArray = PostgisServiceExtension2.getFactory().getParametersInfo();
        int n = paramArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataAccessFactory.Param param = paramArray[n2];
            if (key.equals(param.key)) {
                return param;
            }
            ++n2;
        }
        return null;
    }

    public static final boolean isPostGIS(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().toLowerCase().equals("postgis") || url.getProtocol().toLowerCase().equals("postgis.jdbc") || url.getProtocol().toLowerCase().equals("jdbc.postgis");
    }

    public String reasonForFailure(URL url) {
        if (!PostgisServiceExtension2.isPostGIS(url)) {
            return Messages.PostGISServiceExtension_badURL;
        }
        return this.reasonForFailure(this.createParams(url));
    }

    protected String doOtherChecks(Map<String, Serializable> params) {
        if (!"postgis".equals(params.get(JDBCDataStoreFactory.DBTYPE.key))) {
            return MessageFormat.format("Parameter DBTYPE is required to be \"{0}\"", JDBCDataStoreFactory.DBTYPE.sample);
        }
        if (params.containsKey(IN_TESTING)) {
            return null;
        }
        Pair<Map<String, Serializable>, String> resultOfSplit = this.processParams(params);
        if (resultOfSplit.getRight() != null) {
            String reason = (String)resultOfSplit.getRight();
            return reason;
        }
        return null;
    }

    private Pair<Map<String, Serializable>, String> processParams(Map<String, Serializable> params) {
        String[] schemas;
        String schemasString = (String)((Object)params.get(PostgisNGDataStoreFactory.SCHEMA.key));
        HashSet<String> goodSchemas = new HashSet<String>();
        HashMap<String, Serializable> testedParams = new HashMap<String, Serializable>(params);
        testedParams.put(PostgisNGDataStoreFactory.SCHEMA.key, (Serializable)((Object)"public"));
        testedParams.put(IN_TESTING, Boolean.valueOf(true));
        String reason = super.reasonForFailure(testedParams);
        if (reason == null) {
            goodSchemas.add("public");
        }
        String[] stringArray = schemas = schemasString.split(",");
        int n = schemas.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!goodSchemas.contains(string)) {
                testedParams = new HashMap<String, Serializable>(testedParams);
                String trimmedSchema = string.trim();
                testedParams.put(PostgisNGDataStoreFactory.SCHEMA.key, (Serializable)((Object)trimmedSchema));
                String reasonForFailure = super.reasonForFailure(testedParams);
                if (reasonForFailure == null) {
                    goodSchemas.add(string);
                } else {
                    reason = reasonForFailure;
                }
            }
            ++n2;
        }
        if (!goodSchemas.isEmpty()) {
            testedParams.put(PostgisNGDataStoreFactory.SCHEMA.key, this.combineSchemaStrings(goodSchemas));
        }
        testedParams.remove(IN_TESTING);
        Pair result = new Pair(testedParams, (Object)reason);
        return result;
    }

    protected DataStoreFactorySpi getDataStoreFactory() {
        return PostgisServiceExtension2.getFactory();
    }

    private Serializable combineSchemaStrings(Set<String> goodSchemas) {
        StringBuilder builder = new StringBuilder();
        for (String string : goodSchemas) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(string);
        }
        return builder.toString();
    }
}

