/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.PostgisGeoResource2;
import net.refractions.udig.catalog.PostgisSchemaFolder;
import net.refractions.udig.catalog.PostgisServiceInfo;
import net.refractions.udig.catalog.internal.postgis.ui.PostgisLookUpSchemaRunnable;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class PostgisService2
extends IService {
    private final URL id;
    private Map<String, Serializable> params;
    private IResolve.Status status;
    private final List<IResolve> members = new ArrayList<IResolve>();
    private Lock lock = new UDIGDisplaySafeLock();
    private Throwable message;

    public PostgisService2(URL finalID, Map<String, Serializable> map) {
        this.id = finalID;
        this.params = new HashMap<String, Serializable>(map);
        this.status = IResolve.Status.NOTCONNECTED;
    }

    public String getTitle() {
        URL id = this.getIdentifier();
        return ("PostGIS " + id.getHost() + "/" + id.getPath()).replaceAll("//", "/");
    }

    public Map<String, Serializable> getConnectionParams() {
        if (this.members.isEmpty()) {
            return this.params;
        }
        StringBuilder builder = new StringBuilder();
        for (IResolve member : this.members) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            PostgisSchemaFolder folder = (PostgisSchemaFolder)member;
            builder.append(folder.getSchemaName());
        }
        this.params.put(PostgisNGDataStoreFactory.SCHEMA.key, (Serializable)((Object)builder.toString()));
        this.params.put(PostgisNGDataStoreFactory.LOOSEBBOX.key, Boolean.TRUE);
        return this.params;
    }

    public PostgisServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (PostgisServiceInfo)super.getInfo(monitor);
    }

    protected PostgisServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        this.members(monitor);
        return new PostgisServiceInfo(this);
    }

    public List<PostgisGeoResource2> resources(IProgressMonitor monitor) throws IOException {
        List<IResolve> resolves = this.members(monitor);
        ArrayList<PostgisGeoResource2> resources = new ArrayList<PostgisGeoResource2>();
        for (IResolve resolve : resolves) {
            List folderChildren = resolve.members(monitor);
            for (IResolve resolve2 : folderChildren) {
                resources.add((PostgisGeoResource2)resolve2);
            }
        }
        return resources;
    }

    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        this.lock.lock();
        try {
            if (this.members.isEmpty()) {
                Map<String, Collection<TableDescriptor>> schemas = this.lookupSchemasInDB((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"looking up schemas", (int)1));
                if (schemas == null) {
                    String commaSeperated = (String)((Object)this.params.get(PostgisNGDataStoreFactory.SCHEMA.key));
                    String[] schemaNames = commaSeperated.split(",");
                    schemas = new HashMap<String, Collection<TableDescriptor>>();
                    String[] stringArray = schemaNames;
                    int n = schemaNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        schemas.put(name, Collections.emptyList());
                        ++n2;
                    }
                }
                this.createSchemaFolder(schemas);
                this.message = null;
                this.status = IResolve.Status.CONNECTED;
            }
            List<IResolve> list = Collections.unmodifiableList(this.members);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Map<String, Collection<TableDescriptor>> lookupSchemasInDB(IProgressMonitor monitor) {
        String host = (String)((Object)this.params.get(JDBCDataStoreFactory.HOST.key));
        Integer port = (Integer)this.params.get(PostgisNGDataStoreFactory.PORT.key);
        String database = (String)((Object)this.params.get(JDBCDataStoreFactory.DATABASE.key));
        String user = (String)((Object)this.params.get(JDBCDataStoreFactory.USER.key));
        String pass = (String)((Object)this.params.get(JDBCDataStoreFactory.PASSWD.key));
        PostgisLookUpSchemaRunnable runnable = new PostgisLookUpSchemaRunnable(host, port, user, pass, database);
        runnable.run(monitor);
        if (runnable.getError() != null) {
            this.message = new Exception(runnable.getError());
            this.status = IResolve.Status.BROKEN;
            return null;
        }
        Set<TableDescriptor> tables = runnable.getTableDescriptors();
        HashMultimap schemas = Multimaps.newHashMultimap();
        for (TableDescriptor schema : tables) {
            schemas.put((Object)schema.schema, (Object)schema);
        }
        return schemas.asMap();
    }

    private void createSchemaFolder(Map<String, Collection<TableDescriptor>> schemas) {
        for (Map.Entry<String, Collection<TableDescriptor>> schema : schemas.entrySet()) {
            String trimmed = schema.getKey().trim();
            if (trimmed.length() == 0) continue;
            this.members.add((IResolve)new PostgisSchemaFolder(this, trimmed, schema.getValue()));
        }
    }

    public URL getIdentifier() {
        return this.id;
    }

    public Throwable getMessage() {
        return this.message;
    }

    public IResolve.Status getStatus() {
        return this.status;
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        this.status = IResolve.Status.DISPOSED;
    }
}

