/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.PostgisResourceInfo;
import net.refractions.udig.catalog.PostgisSchemaFolder;
import net.refractions.udig.catalog.PostgisService2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCDataStore;
import org.opengis.feature.simple.SimpleFeatureType;

public class PostgisGeoResource2
extends IGeoResource {
    final TableDescriptor desc;
    final String typename;
    private volatile IResolve.Status status;
    private volatile Throwable message;
    private final URL identifier;
    private final PostgisSchemaFolder parent;
    private Boolean readOnly = null;

    public PostgisGeoResource2(PostgisService2 service, PostgisSchemaFolder postgisSchemaFolder, TableDescriptor desc) {
        this.service = service;
        this.parent = postgisSchemaFolder;
        this.desc = desc;
        this.typename = desc.name;
        try {
            URL identifier2 = service.getIdentifier();
            this.identifier = new URL(identifier2, String.valueOf(identifier2.toExternalForm()) + "#" + this.typename, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The service URL must not contain a #", e);
        }
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public String getTitle() {
        return this.typename;
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.parent;
    }

    public IResolve.Status getStatus() {
        if (this.status != null) {
            return this.status;
        }
        return this.service.getStatus();
    }

    public Throwable getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return this.service.getMessage();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        JDBCDataStore dataStore = this.parent.getDataStore();
        if (adaptee.isAssignableFrom(DataStore.class)) {
            return adaptee.cast(dataStore);
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class)) {
            ContentFeatureSource fs = dataStore.getFeatureSource(this.typename);
            if (fs instanceof FeatureStore) {
                this.readOnly = false;
                return adaptee.cast(fs);
            }
            this.readOnly = true;
            if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
                return adaptee.cast(dataStore.getFeatureSource(this.typename));
            }
        }
        if (adaptee.isAssignableFrom(Connection.class)) {
            return (T)this.service.resolve(adaptee, monitor);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        boolean isFeatureStore = adaptee.isAssignableFrom(SimpleFeatureStore.class) && (this.readOnly == null || this.readOnly == false);
        boolean isFeatureSource = adaptee.isAssignableFrom(SimpleFeatureSource.class);
        boolean isGeoResource = adaptee.isAssignableFrom(IGeoResourceInfo.class);
        boolean isIService = adaptee.isAssignableFrom(IService.class);
        boolean isConnection = adaptee.isAssignableFrom(Connection.class);
        return isGeoResource || isFeatureStore || isFeatureSource || isIService || isConnection || super.canResolve(adaptee);
    }

    protected PostgisResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        try {
            return new PostgisResourceInfo(this);
        }
        catch (Exception e) {
            PostgisPlugin.log("Error creating a PostgisInfo object", e);
            return null;
        }
    }

    public SimpleFeatureType getSchema() throws IOException {
        return this.parent.getDataStore().getSchema(this.typename);
    }

    public void setStatus(IResolve.Status status, Throwable message) {
        this.status = status;
        this.message = message;
    }
}

