/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.profile.borrowedfromjgrasstools;

import com.vividsolutions.jts.geom.Coordinate;

public class ProfilePoint
implements Comparable<ProfilePoint> {
    private static final double DELTA = 1.0E-5;
    private double progressive;
    private double elevation;
    private Coordinate position;

    public ProfilePoint(double progressive, double elevation, Coordinate position) {
        this.progressive = progressive;
        this.elevation = elevation;
        this.position = position;
    }

    public ProfilePoint(double progressive, double elevation, double easting, double northing) {
        this.progressive = progressive;
        this.elevation = elevation;
        this.position = new Coordinate(easting, northing);
    }

    public double getProgressive() {
        return this.progressive;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Coordinate getPosition() {
        return this.position;
    }

    @Override
    public int compareTo(ProfilePoint o) {
        if (Math.abs(this.progressive - o.progressive) < 1.0E-5) {
            return 0;
        }
        if (this.progressive > o.progressive) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return String.valueOf(this.progressive) + ", " + this.elevation;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.elevation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        temp = Double.doubleToLongBits(this.progressive);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfilePoint other = (ProfilePoint)obj;
        Coordinate otherPosition = other.position;
        return Math.abs(this.elevation - other.elevation) < 1.0E-5 && Math.abs(this.position.x - otherPosition.x) < 1.0E-5 && Math.abs(this.position.y - otherPosition.y) < 1.0E-5;
    }
}

