/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.profile.borrowedfromjgrasstools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.ProfilePoint;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.RegionMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;

public class CoverageUtilities {
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String EAST = "EAST";
    public static final String XRES = "XRES";
    public static final String YRES = "YRES";
    public static final String ROWS = "ROWS";
    public static final String COLS = "COLS";
    private static GeometryFactory gf = new GeometryFactory();

    public static RegionMap getRegionParamsFromGridCoverage(GridCoverage2D gridCoverage) {
        RegionMap envelopeParams = new RegionMap();
        Envelope envelope = gridCoverage.getEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static List<ProfilePoint> doProfile(GridCoverage2D coverage, double step, Coordinate ... coordinates) throws Exception {
        ArrayList<ProfilePoint> profilePointsList = new ArrayList<ProfilePoint>();
        LineString line = gf.createLineString(coordinates);
        double lineLength = line.getLength();
        LengthIndexedLine indexedLine = new LengthIndexedLine((Geometry)line);
        double progressive = 0.0;
        Point2D.Double point = new Point2D.Double();
        while (progressive < lineLength + step) {
            Coordinate c = indexedLine.extractPoint(progressive);
            double value = Double.NaN;
            try {
                ((Point2D)point).setLocation(c.x, c.y);
                double[] evaluated = coverage.evaluate((Point2D)point, null);
                value = evaluated[0];
            }
            catch (Exception exception) {}
            ProfilePoint profilePoint = new ProfilePoint(progressive, value, c.x, c.y);
            profilePointsList.add(profilePoint);
            progressive += step;
        }
        return profilePointsList;
    }
}

