/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.profile;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class ProfileView
extends ViewPart {
    public static final String ID = "eu.udig.tools.jgrass.profileview";
    private XYSeries series;
    private XYItemRenderer renderer;
    private XYPlot plot;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private List<Marker> markers = new ArrayList<Marker>();

    public void createPartControl(Composite parent) {
        this.series = new XYSeries((Comparable)((Object)"profile"));
        XYSeriesCollection lineDataset = new XYSeriesCollection();
        lineDataset.addSeries(this.series);
        JFreeChart result = ChartFactory.createXYAreaChart((String)"", (String)"Progressive distance", (String)"Elevation", (XYDataset)lineDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.plot = (XYPlot)result.getPlot();
        ValueAxis axis = this.plot.getDomainAxis();
        axis.setAutoRange(true);
        this.renderer = this.plot.getRenderer();
        this.renderer.setSeriesPaint(0, (Paint)Color.black);
        new ChartComposite(parent, 0, result);
        ExportChartData action = new ExportChartData();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager dropDownMenu = actionBars.getMenuManager();
        dropDownMenu.add((IAction)action);
    }

    public void setFocus() {
    }

    public void addToSeries(double x, double y) {
        if (Math.abs(y - -9999.0) >= 1.0E-7 && !Double.isNaN(y)) {
            this.max = Math.max(this.max, y);
            this.min = Math.min(this.min, y);
        }
        this.series.add(x, y);
    }

    public void setRangeToDataBounds() {
        ValueAxis rangeAxis = this.plot.getRangeAxis();
        rangeAxis.setRange(this.min - 1.0, this.max + 1.0);
    }

    public void clearSeries() {
        this.max = Double.NEGATIVE_INFINITY;
        this.min = Double.POSITIVE_INFINITY;
        this.series.clear();
    }

    public boolean seriesIsEmpty() {
        return this.series.isEmpty();
    }

    public void addStopLine(double x) {
        DecimalFormat formatter = new DecimalFormat("0.0");
        ValueMarker marker = new ValueMarker(x, (Paint)Color.red, (Stroke)new BasicStroke(1.0f));
        marker.setAlpha(0.6f);
        marker.setLabel(formatter.format(x));
        marker.setLabelFont(new Font("Dialog", 0, 8));
        marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        marker.setLabelOffset(new RectangleInsets(2.0, 5.0, 2.0, 5.0));
        this.plot.addDomainMarker((Marker)marker, Layer.BACKGROUND);
        this.markers.add((Marker)marker);
    }

    public void clearMarkers() {
        for (Marker m : this.markers) {
            this.plot.removeDomainMarker(m, Layer.BACKGROUND);
        }
    }

    private class ExportChartData
    extends Action {
        public ExportChartData() {
            this.setText("Export chart data to file");
        }

        public void run() {
            double[][] data = ProfileView.this.series.toArray();
            FileDialog fileDialog = new FileDialog(ProfileView.this.getSite().getShell(), 8192);
            fileDialog.setText("Choose the output data file");
            String path = fileDialog.open();
            if (path == null || path.length() < 1) {
                return;
            }
            try {
                BufferedWriter bW = new BufferedWriter(new FileWriter(path));
                bW.write("Progressive\tElevation\n");
                int j = 0;
                while (j < data[0].length) {
                    int i = 0;
                    while (i < data.length) {
                        bW.write(String.valueOf(data[i][j]) + "\t");
                        ++i;
                    }
                    bW.write("\n");
                    ++j;
                }
                bW.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

