/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.orientationview;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import eu.udig.tools.jgrass.utils.ArrowDrawCommand;
import java.awt.Point;
import java.util.ArrayList;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ViewFeatureOrientation
implements IOp {
    public void op(Display display, Object target, IProgressMonitor monitor) throws Exception {
        ILayer selectedLayer = (ILayer)target;
        SimpleFeatureSource featureSource = (SimpleFeatureSource)selectedLayer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (featureSource == null) {
            return;
        }
        GeometryDescriptor geometryDescriptor = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor();
        ReferencedEnvelope bounds = ApplicationGIS.getActiveMap().getViewportModel().getBounds();
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        ReferencedEnvelope featureBounds = featureSource.getBounds();
        if (featureBounds == null || featureBounds.isNull()) {
            return;
        }
        CoordinateReferenceSystem featureCrs = featureBounds.getCoordinateReferenceSystem();
        ReferencedEnvelope tBounds = bounds.transform(featureCrs, true);
        boolean crsEqual = CRS.equalsIgnoreMetadata((Object)featureCrs, (Object)mapCrs);
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)featureCrs, (CoordinateReferenceSystem)mapCrs, (boolean)true);
        String name = geometryDescriptor.getLocalName();
        Filter bboxFilter = ViewFeatureOrientation.getBboxFilter(name, (BoundingBox)tBounds);
        SimpleFeatureCollection featureCollection = featureSource.getFeatures(bboxFilter);
        SimpleFeatureIterator featureIterator = featureCollection.features();
        IViewportModel viewPort = ApplicationGIS.getActiveMap().getViewportModel();
        ArrayList<ArrowDrawCommand> commands = new ArrayList<ArrowDrawCommand>();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry fGeom = (Geometry)feature.getDefaultGeometry();
            if (!crsEqual) {
                fGeom = JTS.transform((Geometry)fGeom, (MathTransform)mathTransform);
            }
            Coordinate[] coords = fGeom.getCoordinates();
            Point start = viewPort.worldToPixel(coords[0]);
            Point end = viewPort.worldToPixel(coords[coords.length - 1]);
            commands.add(new ArrowDrawCommand(new Coordinate((double)start.x, (double)start.y), new Coordinate((double)end.x, (double)end.y)));
        }
        IToolContext toolContext = ApplicationGIS.createContext((IMap)ApplicationGIS.getActiveMap());
        IDrawCommand compositeCommand = toolContext.getDrawFactory().createCompositeDrawCommand(commands);
        toolContext.sendASyncCommand((Command)compositeCommand);
    }

    public static Filter getBboxFilter(String attribute, BoundingBox bbox) throws CQLException {
        double w = bbox.getMinX();
        double e = bbox.getMaxX();
        double s = bbox.getMinY();
        double n = bbox.getMaxY();
        return ViewFeatureOrientation.getBboxFilter(attribute, w, e, s, n);
    }

    public static Filter getBboxFilter(String attribute, double west, double east, double south, double north) throws CQLException {
        if (attribute == null) {
            attribute = "the_geom";
        }
        StringBuilder sB = new StringBuilder();
        sB.append("BBOX(");
        sB.append(attribute);
        sB.append(",");
        sB.append(west);
        sB.append(",");
        sB.append(south);
        sB.append(",");
        sB.append(east);
        sB.append(",");
        sB.append(north);
        sB.append(")");
        Filter bboxFilter = CQL.toFilter((String)sB.toString());
        return bboxFilter;
    }
}

