/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.orientationview;

import com.vividsolutions.jts.geom.Geometry;
import eu.udig.tools.jgrass.i18n.Messages;
import eu.udig.tools.jgrass.utils.OperationUtils;
import java.util.LinkedList;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.CompositeCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;

public class ReverseFeatureOrientation
extends OperationUtils
implements IOp {
    private int count = 0;

    public void op(Display display, Object target, IProgressMonitor monitor) throws Exception {
        ILayer selectedLayer = (ILayer)target;
        SimpleFeatureSource featureSource = (SimpleFeatureSource)selectedLayer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (featureSource == null) {
            return;
        }
        SimpleFeatureCollection featureCollection = featureSource.getFeatures(selectedLayer.getQuery(true));
        SimpleFeatureIterator featureIterator = featureCollection.features();
        EditCommandFactory cmdFactory = EditCommandFactory.getInstance();
        LinkedList<UndoableMapCommand> cmdList = new LinkedList<UndoableMapCommand>();
        this.count = 0;
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            Geometry newGeometry = geometry.reverse();
            UndoableMapCommand setGeometryCmd = cmdFactory.createSetGeomteryCommand(feature, selectedLayer, newGeometry);
            cmdList.add(setGeometryCmd);
            ++this.count;
        }
        CompositeCommand compositeCommand = new CompositeCommand(cmdList);
        IToolContext toolContext = ApplicationGIS.createContext((IMap)ApplicationGIS.getActiveMap());
        toolContext.sendSyncCommand((Command)compositeCommand);
        this.showMessage(display, Messages.getString("ReverseFeatureOrientation_info"), String.valueOf(Messages.getString("ReverseFeatureOrientation_infomsg")) + this.count, OperationUtils.MSGTYPE.INFO);
    }
}

