/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.navigationview;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.IMapListener;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.MapEvent;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.factory.NavigationCommandFactory;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class NavigationView
extends ViewPart
implements SelectionListener,
IMapListener,
IMapCompositionListener {
    private static DateTimeFormatter ISO_DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static DateTimeFormatter ISO_DATE_TIME_PARSER = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
    private Image worldImage;
    private Text lowerLeftText;
    private Text upperRightText;
    private Canvas canvas;
    private Combo scaleCombo;
    private Combo dateTimeCombo;
    private Combo verticalCombo;
    private DecimalFormat numFormatter = new DecimalFormat("0.00");
    private Button verticalDownButton;
    private Button verticalUpButton;
    private Button scaleDownButton;
    private Button scaleUpButton;
    private Button dtUpButton;
    private Button dtDownButton;
    private Color color;
    private static final String ENTER_SEARCH_STRING = "enter search string";
    private Set<String> keySet;
    private Combo placesCombo;
    private HashMap<String, Coordinate> placesMap;
    private File folderFile;
    private File first;
    private Combo countriesCombo;

    public NavigationView() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/worldoverview2.png");
        this.worldImage = imageDescriptor.createImage();
        this.color = Display.getDefault().getSystemColor(3);
    }

    public void createPartControl(Composite theparent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(theparent, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        Composite parent = new Composite((Composite)scrolledComposite, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        parent.setLayout((Layout)new GridLayout(1, true));
        Point point = parent.computeSize(-1, -1);
        parent.setSize(point);
        scrolledComposite.setMinSize(280, 575);
        scrolledComposite.setContent((Control)parent);
        Group boundsGroup = new Group(parent, 0);
        boundsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        boundsGroup.setLayout((Layout)new GridLayout(2, false));
        boundsGroup.setText("Corners");
        Label lowerLeftLabel = new Label((Composite)boundsGroup, 0);
        lowerLeftLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lowerLeftLabel.setText("Lower left (w,s)");
        this.lowerLeftText = new Text((Composite)boundsGroup, 18436);
        this.lowerLeftText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lowerLeftText.setText("");
        this.lowerLeftText.setEditable(false);
        Label upperRightLabel = new Label((Composite)boundsGroup, 0);
        upperRightLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        upperRightLabel.setText("Upper right (e,n)");
        this.upperRightText = new Text((Composite)boundsGroup, 18436);
        this.upperRightText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.upperRightText.setText("");
        this.upperRightText.setEditable(false);
        Group scaleGroup = new Group(parent, 0);
        scaleGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        scaleGroup.setLayout((Layout)new GridLayout(3, false));
        scaleGroup.setText("Scale");
        this.scaleDownButton = new Button((Composite)scaleGroup, 1028);
        this.scaleDownButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.scaleDownButton.addSelectionListener((SelectionListener)this);
        this.scaleCombo = new Combo((Composite)scaleGroup, 2060);
        this.scaleCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scaleCombo.addSelectionListener((SelectionListener)this);
        this.scaleUpButton = new Button((Composite)scaleGroup, 132);
        this.scaleUpButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.scaleUpButton.addSelectionListener((SelectionListener)this);
        Group dateTimeGroup = new Group(parent, 0);
        dateTimeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        dateTimeGroup.setLayout((Layout)new GridLayout(3, false));
        dateTimeGroup.setText("Date and Time");
        this.dtDownButton = new Button((Composite)dateTimeGroup, 1028);
        this.dtDownButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.dtDownButton.addSelectionListener((SelectionListener)this);
        this.dateTimeCombo = new Combo((Composite)dateTimeGroup, 2060);
        this.dateTimeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dateTimeCombo.addSelectionListener((SelectionListener)this);
        this.dtUpButton = new Button((Composite)dateTimeGroup, 132);
        this.dtUpButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.dtUpButton.addSelectionListener((SelectionListener)this);
        Group verticalGroup = new Group(parent, 0);
        verticalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        verticalGroup.setLayout((Layout)new GridLayout(3, false));
        verticalGroup.setText("Vertical axis");
        this.verticalDownButton = new Button((Composite)verticalGroup, 1028);
        this.verticalDownButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.verticalDownButton.addSelectionListener((SelectionListener)this);
        this.verticalCombo = new Combo((Composite)verticalGroup, 2060);
        this.verticalCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.verticalCombo.addSelectionListener((SelectionListener)this);
        this.verticalUpButton = new Button((Composite)verticalGroup, 132);
        this.verticalUpButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.verticalUpButton.addSelectionListener((SelectionListener)this);
        Group overviewGroups = new Group(parent, 0);
        GridData gd1 = new GridData(0x1000000, 0x1000000, false, false);
        overviewGroups.setLayoutData((Object)gd1);
        overviewGroups.setLayout((Layout)new GridLayout(1, false));
        overviewGroups.setText("Overview");
        this.canvas = new Canvas((Composite)overviewGroups, 0);
        GridData gd2 = new GridData(4, 4, false, false);
        gd2.widthHint = 250;
        gd2.heightHint = 121;
        this.canvas.setLayoutData((Object)gd2);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle canvasBounds = NavigationView.this.canvas.getBounds();
                Rectangle imageBounds = NavigationView.this.worldImage.getBounds();
                int h = (int)((float)canvasBounds.width * (float)imageBounds.height / (float)imageBounds.width);
                e.gc.drawImage(NavigationView.this.worldImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, canvasBounds.width, h);
                IMap activeMap = ApplicationGIS.getActiveMap();
                ViewportModel viewportModel = (ViewportModel)activeMap.getViewportModel();
                ReferencedEnvelope bounds = viewportModel.getBounds();
                CoordinateReferenceSystem mapCrs = viewportModel.getCRS();
                DefaultGeographicCRS imageCrs = DefaultGeographicCRS.WGS84;
                try {
                    int fh;
                    MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)mapCrs, (CoordinateReferenceSystem)imageCrs);
                    Envelope targetEnv = JTS.transform((Envelope)bounds, (MathTransform)transform);
                    double west = targetEnv.getMinX();
                    double north = targetEnv.getMaxY();
                    double east = targetEnv.getMaxX();
                    double south = targetEnv.getMinY();
                    if (west < -180.0) {
                        west = -180.0;
                    }
                    if (west > 180.0) {
                        west = 180.0;
                    }
                    if (north < -90.0) {
                        north = -90.0;
                    }
                    if (north > 90.0) {
                        north = 90.0;
                    }
                    if (east < -180.0) {
                        east = -180.0;
                    }
                    if (east > 180.0) {
                        east = 180.0;
                    }
                    if (south < -90.0) {
                        south = -90.0;
                    }
                    if (south > 90.0) {
                        south = 90.0;
                    }
                    double width = (east += 180.0) - (west += 180.0);
                    double height = (north += 90.0) - (south += 90.0);
                    if (width < 1.0) {
                        width = 1.0;
                    }
                    if (height < 1.0) {
                        height = 1.0;
                    }
                    int x = (int)((double)canvasBounds.width * west / 360.0);
                    int y = (int)((double)h * north / 180.0);
                    int fw = (int)((double)canvasBounds.width * width / 360.0);
                    if (fw <= 1) {
                        fw = 2;
                    }
                    if ((fh = (int)((double)h * height / 180.0)) <= 1) {
                        fh = 2;
                    }
                    int newy = h - y;
                    e.gc.setForeground(NavigationView.this.color);
                    e.gc.setBackground(NavigationView.this.color);
                    e.gc.setAlpha(80);
                    e.gc.fillRectangle(x, newy, fw, fh);
                    e.gc.drawLine(x + fw / 2, 0, x + fw / 2, newy);
                    e.gc.drawLine(0, newy + fh / 2, x, newy + fh / 2);
                    e.gc.drawLine(x + fw, newy + fh / 2, canvasBounds.width, newy + fh / 2);
                }
                catch (FactoryException e1) {
                    e1.printStackTrace();
                }
                catch (TransformException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Group geonamesGroup = new Group(parent, 0);
        geonamesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        geonamesGroup.setLayout((Layout)new GridLayout(4, false));
        geonamesGroup.setText("Geonames");
        Label availableLabel = new Label((Composite)geonamesGroup, 0);
        availableLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        availableLabel.setText("Available geonames data");
        URL folderUrl = Platform.getBundle((String)"eu.udig.tools.jgrass").getResource("/geonamesfiles");
        String folderPath = null;
        try {
            folderPath = FileLocator.toFileURL((URL)folderUrl).getPath();
            this.folderFile = new File(folderPath);
            String[] namesArray = this.loadGeonamesFiles();
            this.countriesCombo = new Combo((Composite)geonamesGroup, 12);
            this.countriesCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.countriesCombo.setItems(namesArray);
            this.countriesCombo.select(0);
            this.countriesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = NavigationView.this.countriesCombo.getSelectionIndex();
                    String item = NavigationView.this.countriesCombo.getItem(selectionIndex);
                    final String file = String.valueOf(NavigationView.this.folderFile.getAbsolutePath()) + File.separator + item + ".txt";
                    IRunnableWithProgress operation = new IRunnableWithProgress(){

                        public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                            try {
                                NavigationView.this.populatePlacesMap(NavigationView.this.placesMap, file);
                            }
                            catch (FileNotFoundException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                    };
                    PlatformGIS.runInProgressDialog((String)"Loading geonames data...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
                }
            });
            Button addNewButton = new Button((Composite)geonamesGroup, 8);
            addNewButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            addNewButton.setText("+");
            addNewButton.setToolTipText("Add a new geonames file (get it at http://download.geonames.org/export/dump/)");
            addNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(NavigationView.this.countriesCombo.getShell(), 4096);
                    fileDialog.setFilterExtensions(new String[]{"*.txt"});
                    String newFilePath = fileDialog.open();
                    try {
                        String[] geonamesFiles;
                        File newFile;
                        if (newFilePath != null && (newFile = new File(newFilePath)).exists()) {
                            File copiedFile = new File(NavigationView.this.folderFile, newFile.getName());
                            FileUtils.copyFile((File)newFile, (File)copiedFile);
                        }
                        if ((geonamesFiles = NavigationView.this.loadGeonamesFiles()).length > 0) {
                            NavigationView.this.countriesCombo.setItems(geonamesFiles);
                            NavigationView.this.countriesCombo.select(0);
                        } else {
                            NavigationView.this.countriesCombo.setItems(new String[]{"   --   "});
                        }
                    }
                    catch (IOException e1) {
                        String message = "An error occurred while copying the new geonames file into the application.";
                        ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e1);
                        e1.printStackTrace();
                    }
                }
            });
            Button removeButton = new Button((Composite)geonamesGroup, 8);
            removeButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            removeButton.setText("-");
            removeButton.setToolTipText("Remove a geonames file");
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = NavigationView.this.countriesCombo.getSelectionIndex();
                    String item = NavigationView.this.countriesCombo.getItem(selectionIndex);
                    try {
                        String[] geonamesFiles;
                        File namesFile = new File(NavigationView.this.folderFile, String.valueOf(item) + ".txt");
                        if (namesFile.exists()) {
                            FileUtils.forceDelete((File)namesFile);
                        }
                        if ((geonamesFiles = NavigationView.this.loadGeonamesFiles()).length > 0) {
                            NavigationView.this.countriesCombo.setItems(geonamesFiles);
                            NavigationView.this.countriesCombo.select(0);
                        } else {
                            NavigationView.this.countriesCombo.setItems(new String[]{"   --   "});
                        }
                    }
                    catch (IOException e1) {
                        String message = "An error occurred while removing the old geonames file into the application.";
                        ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e1);
                        e1.printStackTrace();
                    }
                }
            });
            Group placesGroup = new Group((Composite)geonamesGroup, 0);
            GridData layoutData = new GridData(4, 4, true, false);
            layoutData.horizontalSpan = 4;
            placesGroup.setLayoutData((Object)layoutData);
            placesGroup.setLayout((Layout)new GridLayout(2, false));
            placesGroup.setText("places");
            this.placesMap = new HashMap(1000);
            this.populatePlacesMap(this.placesMap, this.first.getAbsolutePath());
            this.keySet = this.placesMap.keySet();
            final Text placesText = new Text((Composite)placesGroup, 18436);
            placesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            placesText.setText("");
            Button searchButton = new Button((Composite)placesGroup, 8);
            searchButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            searchButton.setText("search");
            searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String text = placesText.getText();
                    if (text.length() < 3) {
                        MessageBox msgBox = new MessageBox(placesText.getShell(), 8);
                        msgBox.setMessage("At least 3 letters are needed to do a search.");
                        msgBox.open();
                        return;
                    }
                    ArrayList<String> matchedList = new ArrayList<String>();
                    for (String name : NavigationView.this.keySet) {
                        if (!name.toLowerCase().matches(".*" + text.toLowerCase() + ".*")) continue;
                        matchedList.add(name);
                    }
                    Object[] matchedArray = matchedList.toArray(new String[matchedList.size()]);
                    Arrays.sort(matchedArray);
                    NavigationView.this.placesCombo.setItems((String[])matchedArray);
                    NavigationView.this.placesCombo.select(0);
                }
            });
            this.placesCombo = new Combo((Composite)placesGroup, 4);
            this.placesCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.placesCombo.setItems(new String[]{ENTER_SEARCH_STRING});
            Button goButton = new Button((Composite)placesGroup, 8);
            goButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            goButton.setText("go");
            goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IMap map = ApplicationGIS.getActiveMap();
                    if (map.getMapLayers().size() < 1) {
                        return;
                    }
                    ReferencedEnvelope bounds = map.getViewportModel().getBounds();
                    CoordinateReferenceSystem mapCrs = map.getViewportModel().getCRS();
                    try {
                        GeometryFactory gF = new GeometryFactory();
                        CoordinateReferenceSystem placeCrs = CRS.decode((String)"EPSG:4326");
                        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)placeCrs, (CoordinateReferenceSystem)mapCrs, (boolean)true);
                        int selectionIndex = NavigationView.this.placesCombo.getSelectionIndex();
                        String item = NavigationView.this.placesCombo.getItem(selectionIndex);
                        Coordinate coordinate = (Coordinate)NavigationView.this.placesMap.get(item);
                        com.vividsolutions.jts.geom.Point pt = gF.createPoint(coordinate);
                        Geometry targetGeometry = JTS.transform((Geometry)pt, (MathTransform)transform);
                        Coordinate position = targetGeometry.getCoordinate();
                        Coordinate centre = bounds.centre();
                        double xTrans = position.x - centre.x;
                        double yTrans = position.y - centre.y;
                        bounds.translate(xTrans, yTrans);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    map.sendCommandASync((MapCommand)NavigationCommandFactory.getInstance().createSetViewportBBoxCommand((Envelope)bounds));
                }
            });
            Button loadShapeButton = new Button((Composite)placesGroup, 8);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = 2;
            loadShapeButton.setLayoutData((Object)gridData);
            loadShapeButton.setText("Load all places as feature layer");
            loadShapeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IRunnableWithProgress operation = new IRunnableWithProgress(){

                        public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                            try {
                                GeometryFactory gF = new GeometryFactory();
                                SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
                                b.setName("places");
                                b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                                b.add("the_geom", MultiPoint.class);
                                b.add("name", String.class);
                                SimpleFeatureType type = b.buildFeatureType();
                                SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
                                int size = NavigationView.this.keySet.size();
                                pm.beginTask("Converting geometries of places...", size);
                                int id = 0;
                                for (String name : NavigationView.this.keySet) {
                                    Coordinate coordinate = (Coordinate)NavigationView.this.placesMap.get(name);
                                    MultiPoint point = gF.createMultiPoint(new Coordinate[]{coordinate});
                                    SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
                                    Object[] values = new Object[]{point, name};
                                    builder.addAll(values);
                                    SimpleFeature feature = builder.buildFeature(String.valueOf(type.getTypeName()) + "." + id);
                                    ++id;
                                    newCollection.add((Feature)feature);
                                    pm.worked(1);
                                }
                                pm.done();
                                IGeoResource resource = CatalogPlugin.getDefault().getLocalCatalog().createTemporaryResource((Object)type);
                                ((FeatureStore)resource.resolve(FeatureStore.class, pm)).addFeatures((FeatureCollection)newCollection);
                                ApplicationGIS.addLayersToMap((IMap)ApplicationGIS.getActiveMap(), Collections.singletonList(resource), (int)-1);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                String message = "An error occurred while loading the places to map";
                                ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
                            }
                        }
                    };
                    PlatformGIS.runInProgressDialog((String)"Loading places in temporary layer...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updateData();
    }

    private String[] loadGeonamesFiles() {
        File[] listFiles = this.folderFile.listFiles();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < listFiles.length) {
            String name = listFiles[i].getName();
            if (!name.startsWith(".svn")) {
                if (this.first == null) {
                    this.first = listFiles[i];
                }
                names.add(name.replaceFirst(".txt", ""));
            }
            ++i;
        }
        String[] namesArray = names.toArray(new String[names.size()]);
        return namesArray;
    }

    private void updateData() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                List availableElevation;
                List availableTimesteps;
                IMap activeMap = ApplicationGIS.getActiveMap();
                ViewportModel viewportModel = (ViewportModel)activeMap.getViewportModel();
                activeMap.addMapListener((IMapListener)NavigationView.this);
                activeMap.addMapCompositionListener((IMapCompositionListener)NavigationView.this);
                ReferencedEnvelope bounds = viewportModel.getBounds();
                double west = bounds.getMinX();
                double east = bounds.getMaxX();
                double north = bounds.getMaxY();
                double south = bounds.getMinY();
                if (NavigationView.this.lowerLeftText.isDisposed()) {
                    return;
                }
                NavigationView.this.lowerLeftText.setText(String.valueOf(NavigationView.this.numFormatter.format(west)) + ", " + NavigationView.this.numFormatter.format(south));
                NavigationView.this.upperRightText.setText(String.valueOf(NavigationView.this.numFormatter.format(east)) + ", " + NavigationView.this.numFormatter.format(north));
                NavigationView.this.canvas.redraw();
                SortedSet preferredScaleDenominators = viewportModel.getPreferredScaleDenominators();
                Double[] scalesArray = preferredScaleDenominators.toArray(new Double[preferredScaleDenominators.size()]);
                String[] scales = new String[scalesArray.length];
                int i = 0;
                while (i < scales.length) {
                    scales[i] = "1:" + String.valueOf(scalesArray[i]);
                    ++i;
                }
                int itemCount = NavigationView.this.scaleCombo.getItemCount();
                int selectionIndex = NavigationView.this.scaleCombo.getSelectionIndex();
                NavigationView.this.scaleCombo.setItems(scales);
                if (scales.length == itemCount) {
                    NavigationView.this.scaleCombo.select(selectionIndex);
                }
                if ((availableTimesteps = viewportModel.getAvailableTimesteps()) != null) {
                    NavigationView.this.dateTimeCombo.setEnabled(true);
                    NavigationView.this.dtDownButton.setEnabled(true);
                    NavigationView.this.dtUpButton.setEnabled(true);
                    String[] dates = new String[availableTimesteps.size()];
                    int i2 = 0;
                    while (i2 < dates.length) {
                        dates[i2] = ISO_DATE_TIME_FORMATTER.print((ReadableInstant)availableTimesteps.get(i2));
                        ++i2;
                    }
                    itemCount = NavigationView.this.dateTimeCombo.getItemCount();
                    selectionIndex = NavigationView.this.dateTimeCombo.getSelectionIndex();
                    NavigationView.this.dateTimeCombo.setItems(dates);
                    if (dates.length == itemCount) {
                        NavigationView.this.dateTimeCombo.select(selectionIndex);
                    }
                } else {
                    NavigationView.this.dateTimeCombo.setEnabled(false);
                    NavigationView.this.dtDownButton.setEnabled(false);
                    NavigationView.this.dtUpButton.setEnabled(false);
                }
                if ((availableElevation = viewportModel.getAvailableElevation()) != null) {
                    NavigationView.this.verticalCombo.setEnabled(true);
                    NavigationView.this.verticalDownButton.setEnabled(true);
                    NavigationView.this.verticalUpButton.setEnabled(true);
                    String[] elev = new String[availableElevation.size()];
                    int i3 = 0;
                    while (i3 < elev.length) {
                        elev[i3] = String.valueOf(availableElevation.get(i3));
                        ++i3;
                    }
                    itemCount = NavigationView.this.verticalCombo.getItemCount();
                    selectionIndex = NavigationView.this.verticalCombo.getSelectionIndex();
                    NavigationView.this.verticalCombo.setItems(elev);
                    if (elev.length == itemCount) {
                        NavigationView.this.verticalCombo.select(selectionIndex);
                    }
                } else {
                    NavigationView.this.verticalCombo.setEnabled(false);
                    NavigationView.this.verticalDownButton.setEnabled(false);
                    NavigationView.this.verticalUpButton.setEnabled(false);
                }
            }
        });
    }

    public void widgetSelected(SelectionEvent e) {
        int selectionIndex;
        String item;
        int index;
        ViewportModel viewportModel = (ViewportModel)ApplicationGIS.getActiveMap().getViewportModel();
        Object source = e.getSource();
        if (source.equals(this.scaleCombo)) {
            index = this.scaleCombo.getSelectionIndex();
            item = this.scaleCombo.getItem(index);
            String scaleString = item.split(":")[1];
            double scale = Double.parseDouble(scaleString);
            viewportModel.setScale(scale);
        }
        if (source.equals(this.dateTimeCombo)) {
            index = this.dateTimeCombo.getSelectionIndex();
            item = this.dateTimeCombo.getItem(index);
            DateTime date = ISO_DATE_TIME_PARSER.parseDateTime(item);
            viewportModel.setCurrentTimestep(date);
        }
        if (source.equals(this.verticalCombo)) {
            index = this.verticalCombo.getSelectionIndex();
            item = this.verticalCombo.getItem(index);
            try {
                double vertical = Double.parseDouble(item);
                viewportModel.setCurrentElevation(Double.valueOf(vertical));
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
            }
        }
        if (source.equals(this.verticalDownButton)) {
            selectionIndex = this.verticalCombo.getSelectionIndex();
            if (++selectionIndex > this.verticalCombo.getItemCount() - 1) {
                selectionIndex = this.verticalCombo.getItemCount() - 1;
            }
            item = this.verticalCombo.getItem(selectionIndex);
            double vertical = Double.parseDouble(item);
            viewportModel.setCurrentElevation(Double.valueOf(vertical));
            this.verticalCombo.select(selectionIndex);
        }
        if (source.equals(this.verticalUpButton)) {
            selectionIndex = this.verticalCombo.getSelectionIndex();
            if (--selectionIndex < 0) {
                selectionIndex = 0;
            }
            item = this.verticalCombo.getItem(selectionIndex);
            double vertical = Double.parseDouble(item);
            viewportModel.setCurrentElevation(Double.valueOf(vertical));
            this.verticalCombo.select(selectionIndex);
        }
        if (source.equals(this.scaleDownButton)) {
            selectionIndex = this.scaleCombo.getSelectionIndex();
            if (--selectionIndex < 0) {
                selectionIndex = 0;
            }
            item = this.scaleCombo.getItem(selectionIndex);
            double scale = Double.parseDouble(item.split(":")[1]);
            viewportModel.setScale(scale);
            this.scaleCombo.select(selectionIndex);
        }
        if (source.equals(this.scaleUpButton)) {
            selectionIndex = this.scaleCombo.getSelectionIndex();
            if (++selectionIndex > this.scaleCombo.getItemCount() - 1) {
                selectionIndex = this.scaleCombo.getItemCount() - 1;
            }
            item = this.scaleCombo.getItem(selectionIndex);
            double scale = Double.parseDouble(item.split(":")[1]);
            viewportModel.setScale(scale);
            this.scaleCombo.select(selectionIndex);
        }
        if (source.equals(this.dtDownButton)) {
            selectionIndex = this.dateTimeCombo.getSelectionIndex();
            if (--selectionIndex < 0) {
                selectionIndex = 0;
            }
            item = this.dateTimeCombo.getItem(selectionIndex);
            DateTime dt = ISO_DATE_TIME_PARSER.parseDateTime(item);
            viewportModel.setCurrentTimestep(dt);
            this.dateTimeCombo.select(selectionIndex);
        }
        if (source.equals(this.dtUpButton)) {
            selectionIndex = this.dateTimeCombo.getSelectionIndex();
            if (++selectionIndex > this.dateTimeCombo.getItemCount() - 1) {
                selectionIndex = this.dateTimeCombo.getItemCount() - 1;
            }
            item = this.dateTimeCombo.getItem(selectionIndex);
            DateTime dt = ISO_DATE_TIME_PARSER.parseDateTime(item);
            viewportModel.setCurrentTimestep(dt);
            this.dateTimeCombo.select(selectionIndex);
        }
        this.updateData();
    }

    public void changed(MapEvent event) {
        this.updateData();
    }

    public void changed(MapCompositionEvent event) {
        this.updateData();
    }

    public void setFocus() {
        this.updateData();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void populatePlacesMap(HashMap<String, Coordinate> placesMap, String fileToRead) throws FileNotFoundException, IOException {
        BufferedReader bR = new BufferedReader(new FileReader(fileToRead));
        String line = null;
        while ((line = bR.readLine()) != null) {
            String[] lineSplit = line.split("\t");
            String name = lineSplit[1];
            String lat = lineSplit[4];
            String lon = lineSplit[5];
            Coordinate c = new Coordinate(Double.parseDouble(lon), Double.parseDouble(lat));
            placesMap.put(name, c);
        }
        bR.close();
    }
}

