/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.geopaparazzi;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import eu.udig.tools.jgrass.JGrassToolsPlugin;
import eu.udig.tools.jgrass.geopaparazzi.ImportGeopaparazziFolderWizardPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ImportGeopaparazziFolderWizard
extends Wizard
implements IImportWizard {
    private static final String[] GEOPAPARAZZI_NOTES_DESCRIPTIONFIELDS = new String[]{"DESCRIPTION", "TIMESTAMP", "ALTIM"};
    private static final String GEOPAPARAZZI_NOTES_OUTPUTSHAPEFILENAME = "notes.shp";
    private ImportGeopaparazziFolderWizardPage mainPage;
    private static GeometryFactory gF = new GeometryFactory();
    private CoordinateReferenceSystem mapCrs;
    private boolean canFinish = true;

    public boolean canFinish() {
        return this.canFinish;
    }

    public boolean performFinish() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IProgressService ps = wb.getProgressService();
                    ps.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor pm) {
                            String geopaparazziFolderPath = ImportGeopaparazziFolderWizard.this.mainPage.getGeopaparazziFolderPath();
                            File geopapFolderFile = new File(geopaparazziFolderPath);
                            File geopapDatabaseFile = new File(geopaparazziFolderPath, "geopaparazzi.db");
                            if (!geopapDatabaseFile.exists()) {
                                MessageDialog.openError((Shell)ImportGeopaparazziFolderWizard.this.getShell(), (String)"Missing database", (String)"The geopaparazzi database file (geopaparazzi.db) is missing. Check the inserted path.");
                                return;
                            }
                            String outputFolderPath = ImportGeopaparazziFolderWizard.this.mainPage.getOutputFolderPath();
                            File outputFolderFile = new File(outputFolderPath);
                            ImportGeopaparazziFolderWizard.this.mapCrs = ApplicationGIS.getActiveMap().getViewportModel().getCRS();
                            Connection connection = null;
                            try {
                                try {
                                    connection = DriverManager.getConnection("jdbc:sqlite:" + geopapDatabaseFile.getAbsolutePath());
                                    if (geopapDatabaseFile.exists()) {
                                        ImportGeopaparazziFolderWizard.this.notesToShapefile(connection, outputFolderFile, pm);
                                        ImportGeopaparazziFolderWizard.this.gpsLogToShapefiles(connection, outputFolderFile, pm);
                                    }
                                    ImportGeopaparazziFolderWizard.this.mediaToShapeFile(geopapFolderFile, outputFolderFile, pm);
                                }
                                catch (Exception e) {
                                    String message = "An error occurred while importing from geopaparazzi.";
                                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
                                    try {
                                        if (connection != null) {
                                            connection.close();
                                        }
                                    }
                                    catch (SQLException e2) {
                                        String message2 = "An error occurred while closing the database connection.";
                                        ExceptionDetailsDialog.openError(null, (String)message2, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e2);
                                    }
                                }
                            }
                            finally {
                                try {
                                    if (connection != null) {
                                        connection.close();
                                    }
                                }
                                catch (SQLException e) {
                                    String message = "An error occurred while closing the database connection.";
                                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
                                }
                            }
                        }
                    });
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    String message = "An error occurred while extracting the data from the database.";
                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e1);
                }
            }
        });
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Geopaparazzi Import Wizard");
        this.setNeedsProgressMonitor(true);
        this.mainPage = new ImportGeopaparazziFolderWizardPage("Import GeoPaparazzi Data Folder", selection);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
        try {
            Class.forName("org.sqlite.JDBC");
            this.canFinish = true;
        }
        catch (Exception e) {
            String message = "An error occurred while loading the database drivers. Check your installation.";
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
            this.canFinish = false;
        }
    }

    private void notesToShapefile(Connection connection, File outputFolderFile, IProgressMonitor pm) throws Exception {
        File outputShapeFile = new File(outputFolderFile, GEOPAPARAZZI_NOTES_OUTPUTSHAPEFILENAME);
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("geopaparazzinotes");
        b.setCRS(this.mapCrs);
        b.add("the_geom", Point.class);
        String[] stringArray = GEOPAPARAZZI_NOTES_DESCRIPTIONFIELDS;
        int n = GEOPAPARAZZI_NOTES_DESCRIPTIONFIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            b.add(fieldName, String.class);
            ++n2;
        }
        SimpleFeatureType featureType = b.buildFeatureType();
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.mapCrs);
        pm.beginTask("Import notes...", -1);
        SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery("select lat, lon, altim, ts, text from notes");
            int i = 0;
            while (rs.next()) {
                double lat = rs.getDouble("lat");
                double lon = rs.getDouble("lon");
                double altim = rs.getDouble("altim");
                String dateTimeString = rs.getString("ts");
                String text = rs.getString("text");
                if (lat == 0.0 || lon == 0.0) continue;
                Coordinate c = new Coordinate(lon, lat);
                Point point = gF.createPoint(c);
                Geometry reprojectPoint = JTS.transform((Geometry)point, (MathTransform)transform);
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                Object[] values = new Object[]{reprojectPoint, text, dateTimeString, String.valueOf(altim)};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(String.valueOf(featureType.getTypeName()) + "." + i++);
                newCollection.add((Feature)feature);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
            if (statement != null) {
                statement.close();
            }
        }
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", outputShapeFile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore dStore = (ShapefileDataStore)factory.createNewDataStore(params);
        dStore.createSchema(featureType);
        dStore.forceSchemaCRS(this.mapCrs);
        JGrassToolsPlugin.getDefault().writeToShapefile(dStore, (FeatureCollection<SimpleFeatureType, SimpleFeature>)newCollection);
        JGrassToolsPlugin.getDefault().addServiceToCatalogAndMap(outputShapeFile.getAbsolutePath(), true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void gpsLogToShapefiles(Connection connection, File outputFolderFile, IProgressMonitor pm) throws Exception {
        SimpleFeatureBuilder builder;
        File outputLinesShapeFile = new File(outputFolderFile, "gpslines.shp");
        Statement statement = connection.createStatement();
        statement.setQueryTimeout(30);
        ArrayList<GpsLog> logsList = new ArrayList<GpsLog>();
        ResultSet rs = statement.executeQuery("select _id, startts, endts, text from gpslogs");
        while (rs.next()) {
            long id = rs.getLong("_id");
            String startDateTimeString = rs.getString("startts");
            String endDateTimeString = rs.getString("endts");
            String text = rs.getString("text");
            GpsLog log = new GpsLog();
            log.id = id;
            log.startTime = startDateTimeString;
            log.endTime = endDateTimeString;
            log.text = text;
            logsList.add(log);
        }
        statement.close();
        try {
            for (GpsLog log : logsList) {
                long logId = log.id;
                String query = "select lat, lon, altim, ts from gpslog_data where logid = " + logId + " order by ts";
                Statement newStatement = connection.createStatement();
                newStatement.setQueryTimeout(30);
                ResultSet result = newStatement.executeQuery(query);
                while (result.next()) {
                    double lat = result.getDouble("lat");
                    double lon = result.getDouble("lon");
                    double altim = result.getDouble("altim");
                    String dateTimeString = result.getString("ts");
                    GpsPoint gPoint = new GpsPoint();
                    gPoint.lon = lon;
                    gPoint.lat = lat;
                    gPoint.altim = altim;
                    gPoint.utctime = dateTimeString;
                    log.points.add(gPoint);
                }
                newStatement.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "An error occurred while reading the gps logs.";
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
            return;
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("geopaparazzinotes");
        b.setCRS(this.mapCrs);
        b.add("the_geom", MultiLineString.class);
        b.add("STARTDATE", String.class);
        b.add("ENDDATE", String.class);
        b.add("DESCR", String.class);
        SimpleFeatureType featureType = b.buildFeatureType();
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.mapCrs);
            pm.beginTask("Import gps to lines...", logsList.size());
            SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
            int index = 0;
            for (GpsLog log : logsList) {
                List<GpsPoint> points = log.points;
                ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
                String startDate = log.startTime;
                String endDate = log.endTime;
                for (GpsPoint gpsPoint : points) {
                    Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                    coordList.add(c);
                }
                Coordinate[] coordArray = coordList.toArray(new Coordinate[coordList.size()]);
                if (coordArray.length < 2) continue;
                LineString lineString = gF.createLineString(coordArray);
                LineString reprojectLineString = (LineString)JTS.transform((Geometry)lineString, (MathTransform)transform);
                MultiLineString multiLineString = gF.createMultiLineString(new LineString[]{reprojectLineString});
                builder = new SimpleFeatureBuilder(featureType);
                Object[] values = new Object[]{multiLineString, startDate, endDate, log.text};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(String.valueOf(featureType.getTypeName()) + "." + index++);
                newCollection.add((Feature)feature);
                pm.worked(1);
            }
            pm.done();
            ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", outputLinesShapeFile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            ShapefileDataStore dStore = (ShapefileDataStore)factory.createNewDataStore(params);
            dStore.createSchema(featureType);
            dStore.forceSchemaCRS(this.mapCrs);
            JGrassToolsPlugin.getDefault().writeToShapefile(dStore, (FeatureCollection<SimpleFeatureType, SimpleFeature>)newCollection);
            JGrassToolsPlugin.getDefault().addServiceToCatalogAndMap(outputLinesShapeFile.getAbsolutePath(), true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            JGrassToolsPlugin.log(e1.getLocalizedMessage(), e1);
            e1.printStackTrace();
        }
        File outputPointsShapeFile = new File(outputFolderFile, "gpspoints.shp");
        b = new SimpleFeatureTypeBuilder();
        b.setName("geopaparazzinotes");
        b.setCRS(this.mapCrs);
        b.add("the_geom", Point.class);
        b.add("ALTIMETRY", String.class);
        b.add("DATE", String.class);
        featureType = b.buildFeatureType();
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.mapCrs);
            pm.beginTask("Import gps to points...", logsList.size());
            SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
            int index = 0;
            for (GpsLog log : logsList) {
                List<GpsPoint> gpsPointList = log.points;
                for (GpsPoint gpsPoint : gpsPointList) {
                    Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                    Point point = gF.createPoint(c);
                    Point reprojectPoint = (Point)JTS.transform((Geometry)point, (MathTransform)transform);
                    Object[] values = new Object[]{reprojectPoint, String.valueOf(gpsPoint.altim), gpsPoint.utctime};
                    builder = new SimpleFeatureBuilder(featureType);
                    builder.addAll(values);
                    SimpleFeature feature = builder.buildFeature(String.valueOf(featureType.getTypeName()) + "." + index++);
                    newCollection.add((Feature)feature);
                }
                pm.worked(1);
            }
            pm.done();
            ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", outputPointsShapeFile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            ShapefileDataStore dStore = (ShapefileDataStore)factory.createNewDataStore(params);
            dStore.createSchema(featureType);
            dStore.forceSchemaCRS(this.mapCrs);
            JGrassToolsPlugin.getDefault().writeToShapefile(dStore, (FeatureCollection<SimpleFeatureType, SimpleFeature>)newCollection);
            JGrassToolsPlugin.getDefault().addServiceToCatalogAndMap(outputPointsShapeFile.getAbsolutePath(), true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            JGrassToolsPlugin.log(e1.getLocalizedMessage(), e1);
            e1.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void mediaToShapeFile(File geopapFolderFile, File outputFolderFile, IProgressMonitor pm) throws Exception {
        folder = new File(geopapFolderFile, "media");
        if (!folder.exists() && !(folder = new File(geopapFolderFile, "pictures")).exists()) {
            return;
        }
        imageFolderName = "media";
        listFiles = folder.listFiles();
        nonTakenFilesList = new ArrayList<String>();
        pm.beginTask("Importing media...", listFiles.length);
        try {
            outputPointsShapeFile = new File(outputFolderFile, "mediapoints.shp");
            b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzinotes");
            b.setCRS(this.mapCrs);
            b.add("the_geom", Point.class);
            b.add("ALTIMETRY", String.class);
            b.add("DATE", String.class);
            b.add("AZIMUTH", Double.class);
            b.add("IMAGE", String.class);
            featureType = b.buildFeatureType();
            transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.mapCrs);
            newCollection = FeatureCollections.newCollection();
            var16_13 = listFiles;
            var15_14 = listFiles.length;
            var14_16 = 0;
            while (var14_16 < var15_14) {
                imageFile = var16_13[var14_16];
                name = imageFile.getName();
                if (!name.endsWith("jpg") && !imageFile.getName().endsWith("JPG") && !imageFile.getName().endsWith("png") && !imageFile.getName().endsWith("PNG") && !imageFile.getName().endsWith("3gp")) ** GOTO lbl70
                nameSplit = name.split("[_\\|.]");
                dateString = nameSplit[1];
                timeString = nameSplit[2];
                locationProperties = new Properties();
                mediaPath = imageFile.getAbsolutePath();
                nameNoExt = mediaPath.substring(0, lastDot = mediaPath.lastIndexOf("."));
                infoPath = String.valueOf(nameNoExt) + ".properties";
                infoFile = new File(infoPath);
                if (!infoFile.exists()) {
                    nonTakenFilesList.add(mediaPath);
                } else {
                    locationProperties.load(new FileInputStream(infoFile));
                    azimuthString = locationProperties.getProperty("azimuth");
                    latString = locationProperties.getProperty("latitude");
                    lonString = locationProperties.getProperty("longitude");
                    altimString = locationProperties.getProperty("altim");
                    azimuth = -9999.0;
                    if (azimuthString != null) {
                        azimuth = Double.parseDouble(azimuthString);
                    }
                    lat = 0.0;
                    lon = 0.0;
                    if (latString.contains("/")) {
                        lat = ImportGeopaparazziFolderWizard.exifFormat2degreeDecimal(latString);
                        lon = ImportGeopaparazziFolderWizard.exifFormat2degreeDecimal(lonString);
                    } else {
                        lat = Double.parseDouble(latString);
                        lon = Double.parseDouble(lonString);
                    }
                    altim = Double.parseDouble(altimString);
                    c = new Coordinate(lon, lat);
                    point = ImportGeopaparazziFolderWizard.gF.createPoint(c);
                    imageRelativePath = String.valueOf(imageFolderName) + "/" + imageFile.getName();
                    newImageFile = new File(outputFolderFile, imageRelativePath);
                    FileUtils.copyFile((File)imageFile, (File)newImageFile);
                    reprojectPoint = (Point)JTS.transform((Geometry)point, (MathTransform)transform);
                    dateTime = String.valueOf(dateString) + timeString;
                    values = new Object[]{reprojectPoint, String.valueOf(altim), dateTime, azimuth, imageRelativePath};
                    builder = new SimpleFeatureBuilder(featureType);
                    builder.addAll(values);
                    feature = builder.buildFeature(null);
                    newCollection.add((Feature)feature);
lbl70:
                    // 2 sources

                    pm.worked(1);
                }
                ++var14_16;
            }
            factory = new ShapefileDataStoreFactory();
            params = new HashMap<String, Serializable>();
            params.put("url", outputPointsShapeFile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            dStore = (ShapefileDataStore)factory.createNewDataStore(params);
            dStore.createSchema(featureType);
            dStore.forceSchemaCRS(this.mapCrs);
            JGrassToolsPlugin.getDefault().writeToShapefile(dStore, (FeatureCollection<SimpleFeatureType, SimpleFeature>)newCollection);
            JGrassToolsPlugin.getDefault().addServiceToCatalogAndMap(outputPointsShapeFile.getAbsolutePath(), true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            pm.done();
        }
        if (nonTakenFilesList.size() > 0) {
            sB = new StringBuilder();
            sB.append("For the following media no *.properties file could be found:\n");
            for (String p : nonTakenFilesList) {
                sB.append(p).append("\n");
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)sB.toString());
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    MessageDialog.openInformation((Shell)shell, (String)"Info", (String)"All media were successfully imported.");
                }
            });
        }
    }

    public static String degreeDecimal2ExifFormat(double decimalDegree) {
        StringBuilder sb = new StringBuilder();
        sb.append((int)decimalDegree);
        sb.append("/1,");
        decimalDegree = (decimalDegree - (double)((int)decimalDegree)) * 60.0;
        sb.append((int)decimalDegree);
        sb.append("/1,");
        decimalDegree = (decimalDegree - (double)((int)decimalDegree)) * 60000.0;
        sb.append((int)decimalDegree);
        sb.append("/1000");
        return sb.toString();
    }

    public static double exifFormat2degreeDecimal(String exifFormat) {
        String[] exifSplit = exifFormat.trim().split(",");
        String[] value = exifSplit[0].split("/");
        double tmp1 = Double.parseDouble(value[0]);
        double tmp2 = Double.parseDouble(value[1]);
        double degree = tmp1 / tmp2;
        value = exifSplit[1].split("/");
        tmp1 = Double.parseDouble(value[0]);
        tmp2 = Double.parseDouble(value[1]);
        double minutes = tmp1 / tmp2;
        value = exifSplit[2].split("/");
        tmp1 = Double.parseDouble(value[0]);
        tmp2 = Double.parseDouble(value[1]);
        double seconds = tmp1 / tmp2;
        double result = degree + minutes / 60.0 + seconds / 3600.0;
        return result;
    }

    private static class GpsLog {
        public long id;
        public String startTime;
        public String endTime;
        public String text;
        public List<GpsPoint> points = new ArrayList<GpsPoint>();

        private GpsLog() {
        }
    }

    private static class GpsPoint {
        public double lat;
        public double lon;
        public double altim;
        public String utctime;

        private GpsPoint() {
        }
    }
}

