/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.csv;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.tools.jgrass.csv.CsvImportWizardPage;
import eu.udig.tools.jgrass.i18n.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.grassraster.JGrassConstants;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CsvImportWizard
extends Wizard
implements INewWizard {
    private CsvImportWizardPage mainPage;
    private final Map<String, String> params = new HashMap<String, String>();
    public static boolean canFinish = true;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.getString("CsvImportWizard.fileimport"));
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/workset_wiz.png"));
        this.setNeedsProgressMonitor(true);
        this.mainPage = new CsvImportWizardPage(Messages.getString("CsvImportWizard.csvimport"), this.params);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        final CoordinateReferenceSystem crs = this.mainPage.getCrs();
        final File csvFile = this.mainPage.getCsvFile();
        final String separator = this.mainPage.getSeparator();
        final LinkedHashMap<String, Integer> fieldsAndTypesIndex = this.mainPage.getFieldsAndTypesIndex();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                if (!csvFile.exists()) {
                    MessageDialog.openError((Shell)CsvImportWizard.this.getShell(), (String)"Import error", (String)(String.valueOf(Messages.getString("CsvImportWizard.inputnotexist")) + csvFile.getAbsolutePath()));
                    return;
                }
                try {
                    SimpleFeatureCollection csvFileFeatureCollection = CsvImportWizard.csvFileToFeatureCollection(csvFile, crs, fieldsAndTypesIndex, separator, pm);
                    SimpleFeatureType featureType = (SimpleFeatureType)csvFileFeatureCollection.getSchema();
                    JGrassCatalogUtilities.removeMemoryServiceByTypeName((String)featureType.getTypeName());
                    IGeoResource resource = CatalogPlugin.getDefault().getLocalCatalog().createTemporaryResource((Object)featureType);
                    SimpleFeatureStore resolve = (SimpleFeatureStore)resource.resolve(FeatureStore.class, pm);
                    resolve.addFeatures((FeatureCollection)csvFileFeatureCollection);
                    ApplicationGIS.addLayersToMap((IMap)ApplicationGIS.getActiveMap(), Collections.singletonList(resource), (int)-1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = Messages.getString("CsvImportWizard.error");
                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
                }
            }
        };
        PlatformGIS.runInProgressDialog((String)"Importing data to feature layer", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
        return true;
    }

    public boolean canFinish() {
        return canFinish;
    }

    public static SimpleFeatureCollection csvFileToFeatureCollection(File csvFile, CoordinateReferenceSystem crs, LinkedHashMap<String, Integer> fieldsAndTypesIndex, String separator, IProgressMonitor pm) throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Map typesMap = JGrassConstants.CSVTYPESCLASSESMAP;
        String[] typesArray = JGrassConstants.CSVTYPESARRAY;
        if (separator == null) {
            separator = ",";
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("csvimport");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        int xIndex = -1;
        int yIndex = -1;
        Set<String> fieldNames = fieldsAndTypesIndex.keySet();
        String[] fieldNamesArray = fieldNames.toArray(new String[fieldNames.size()]);
        int i = 0;
        while (i < fieldNamesArray.length) {
            String fieldName = fieldNamesArray[i];
            Integer typeIndex = fieldsAndTypesIndex.get(fieldName);
            if (typeIndex == 0) {
                xIndex = i;
            } else if (typeIndex == 1) {
                yIndex = i;
            } else {
                Class class1 = (Class)typesMap.get(typesArray[typeIndex]);
                b.add(fieldName, class1);
            }
            ++i;
        }
        SimpleFeatureType featureType = b.buildFeatureType();
        SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
        Collection<Integer> orderedTypeIndexes = fieldsAndTypesIndex.values();
        Integer[] orderedTypeIndexesArray = orderedTypeIndexes.toArray(new Integer[orderedTypeIndexes.size()]);
        BufferedReader bR = null;
        try {
            bR = new BufferedReader(new FileReader(csvFile));
            String line = null;
            int featureId = 0;
            pm.beginTask("Importing raw data", -1);
            while ((line = bR.readLine()) != null) {
                pm.worked(1);
                line = line.trim();
                if (line.length() == 0 || line.startsWith("#")) continue;
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                Object[] values = new Object[fieldNames.size() - 1];
                String[] lineSplit = line.split(separator);
                double x = Double.parseDouble(lineSplit[xIndex]);
                double y = Double.parseDouble(lineSplit[yIndex]);
                Point point = gf.createPoint(new Coordinate(x, y));
                values[0] = point;
                int objIndex = 1;
                int i2 = 0;
                while (i2 < lineSplit.length) {
                    if (i2 != xIndex && i2 != yIndex) {
                        String value = lineSplit[i2];
                        int typeIndex = orderedTypeIndexesArray[i2];
                        String typeName = typesArray[typeIndex];
                        if (typeName.equals(typesArray[3])) {
                            values[objIndex] = value;
                        } else if (typeName.equals(typesArray[4])) {
                            values[objIndex] = new Double(value);
                        } else if (typeName.equals(typesArray[5])) {
                            values[objIndex] = new Integer(value);
                        } else {
                            throw new IllegalArgumentException("An undefined value type was found");
                        }
                        ++objIndex;
                    }
                    ++i2;
                }
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(String.valueOf(featureType.getTypeName()) + "." + featureId);
                ++featureId;
                newCollection.add((Feature)feature);
            }
        }
        finally {
            if (bR != null) {
                bR.close();
            }
            pm.done();
        }
        return newCollection;
    }
}

