/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.coverageexport;

import eu.udig.tools.jgrass.coverageexport.TiffAsciiExportWizard;
import java.io.IOException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.CRSChooserDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TiffAsciiExportWizardPage
extends WizardPage {
    public static final String ID = "eu.udig.tools.jgrass.rasterexport.TiffAsciiExportWizardPage";
    private Text outFolderText;
    private Text crsText;
    private CoordinateReferenceSystem fileCrs;
    private IGeoResource geoResource;
    private boolean crsIsOk = true;
    private boolean nameIsOk = true;
    private boolean folderIsOk = true;
    private CoordinateReferenceSystem newCrs;
    private String folderPath;
    private String fileName;
    private boolean isTiff = true;
    private boolean isAscii = false;

    public TiffAsciiExportWizardPage() {
        super(ID);
        this.setTitle("Export coverage map");
        this.setDescription("Export coverage map to geotiff or ascii grid");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 10;
        mainComposite.setLayout((Layout)gridLayout);
        ILayer selectedLayer = ApplicationGIS.getActiveMap().getEditManager().getSelectedLayer();
        this.geoResource = selectedLayer.getGeoResource();
        try {
            this.fileCrs = this.geoResource.getInfo((IProgressMonitor)new NullProgressMonitor()).getCRS();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Label selectedLayerLabel = new Label(mainComposite, 0);
        GridData selectedLayerLabelGd = new GridData(1, 0x1000000, false, false);
        selectedLayerLabelGd.horizontalSpan = 3;
        selectedLayerLabel.setLayoutData((Object)selectedLayerLabelGd);
        selectedLayerLabel.setText("Selected layer to export: " + this.geoResource.getTitle());
        Label outFolderLabel = new Label(mainComposite, 0);
        outFolderLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        outFolderLabel.setText("Folder to which to save the file to");
        this.outFolderText = new Text(mainComposite, 2048);
        this.outFolderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.outFolderText.setEditable(false);
        final Button outFolderButton = new Button(mainComposite, 8);
        outFolderButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        outFolderButton.setText("...");
        outFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog folderDialog = new DirectoryDialog(outFolderButton.getShell(), 4096);
                String path = folderDialog.open();
                if (path == null || path.length() < 1) {
                    TiffAsciiExportWizardPage.this.outFolderText.setText("");
                    TiffAsciiExportWizardPage.this.folderIsOk = false;
                } else {
                    TiffAsciiExportWizardPage.this.outFolderText.setText(path);
                    TiffAsciiExportWizardPage.this.folderIsOk = true;
                    TiffAsciiExportWizardPage.this.folderPath = path;
                }
                TiffAsciiExportWizardPage.this.checkFinish();
            }
        });
        Label outputNameLabel = new Label(mainComposite, 0);
        outputNameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        outputNameLabel.setText("Output file name (without extension)");
        final Text outputNameText = new Text(mainComposite, 2048);
        outputNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        outputNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String text = outputNameText.getText();
                if (text.length() > 0) {
                    TiffAsciiExportWizardPage.this.nameIsOk = true;
                    TiffAsciiExportWizardPage.this.fileName = text;
                } else {
                    TiffAsciiExportWizardPage.this.nameIsOk = false;
                }
                TiffAsciiExportWizardPage.this.checkFinish();
            }
        });
        Label dummyLabel = new Label(mainComposite, 0);
        dummyLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        dummyLabel.setText("");
        Label crsLabel = new Label(mainComposite, 0);
        crsLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        crsLabel.setText("Crs to which to reproject (optional)");
        this.crsText = new Text(mainComposite, 2048);
        this.crsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.crsText.setEditable(false);
        final Button crsButton = new Button(mainComposite, 2048);
        crsButton.setText("...");
        crsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoordinateReferenceSystem crs = ApplicationGIS.getActiveMap().getViewportModel().getCRS();
                CRSChooserDialog dialog = new CRSChooserDialog(crsButton.getShell(), crs);
                int code = dialog.open();
                if (code == 0) {
                    CoordinateReferenceSystem result = dialog.getResult();
                    TiffAsciiExportWizardPage.this.crsText.setText(result.getName().toString());
                    TiffAsciiExportWizardPage.this.crsText.setData((Object)result);
                    TiffAsciiExportWizardPage.this.newCrs = result;
                }
            }
        });
        final Button tiffRadioButton = new Button(mainComposite, 16);
        GridData tiffRadioGd = new GridData(1, 0x1000000, true, false);
        tiffRadioGd.horizontalSpan = 3;
        tiffRadioButton.setLayoutData((Object)tiffRadioGd);
        tiffRadioButton.setText("export as geotiff");
        tiffRadioButton.setSelection(true);
        tiffRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TiffAsciiExportWizardPage.this.isTiff = tiffRadioButton.getSelection();
            }
        });
        final Button asciiRadioButton = new Button(mainComposite, 16);
        asciiRadioButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        asciiRadioButton.setText("export as esri ascii");
        asciiRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TiffAsciiExportWizardPage.this.isAscii = asciiRadioButton.getSelection();
                if (TiffAsciiExportWizardPage.this.isAscii) {
                    Object crsData;
                    if (TiffAsciiExportWizardPage.this.fileCrs instanceof DefaultGeographicCRS && ((crsData = TiffAsciiExportWizardPage.this.crsText.getData()) == null || crsData instanceof DefaultGeographicCRS)) {
                        MessageBox msgBox = new MessageBox(asciiRadioButton.getShell(), 1);
                        msgBox.setMessage("In the case of export to ascii grids, it is necessary to choose a non angular coordinate system.");
                        msgBox.setText("Export error");
                        msgBox.open();
                        tiffRadioButton.setSelection(true);
                        asciiRadioButton.setSelection(false);
                        TiffAsciiExportWizardPage.this.crsIsOk = false;
                    }
                    TiffAsciiExportWizardPage.this.checkFinish();
                }
            }
        });
        this.setControl((Control)mainComposite);
    }

    public CoordinateReferenceSystem getNewCrs() {
        return this.newCrs;
    }

    public CoordinateReferenceSystem getFileCrs() {
        return this.fileCrs;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isAscii() {
        return this.isAscii;
    }

    public boolean isTiff() {
        return this.isTiff;
    }

    public IGeoResource getGeoResource() {
        return this.geoResource;
    }

    public void dispose() {
        super.dispose();
    }

    private void checkFinish() {
        TiffAsciiExportWizard.canFinish = this.crsIsOk && this.nameIsOk && this.folderIsOk;
        this.getWizard().getContainer().updateButtons();
    }
}

