/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.coverageexport;

import eu.udig.tools.jgrass.coverageexport.TiffAsciiExportWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.processing.Operations;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.arcgrid.ArcGridWriteParams;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.referencing.CRS;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class TiffAsciiExportWizard
extends Wizard
implements IExportWizard {
    public static boolean canFinish = false;
    private TiffAsciiExportWizardPage mainPage;
    public static DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Coverage export");
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/export_wiz.png"));
        this.setNeedsProgressMonitor(true);
        this.mainPage = new TiffAsciiExportWizardPage();
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                IGeoResource geoResource = TiffAsciiExportWizard.this.mainPage.getGeoResource();
                String folderPath = TiffAsciiExportWizard.this.mainPage.getFolderPath();
                String fileName = TiffAsciiExportWizard.this.mainPage.getFileName();
                String newPath = String.valueOf(folderPath) + File.separator + fileName;
                CoordinateReferenceSystem fileCrs = TiffAsciiExportWizard.this.mainPage.getFileCrs();
                CoordinateReferenceSystem newCrs = TiffAsciiExportWizard.this.mainPage.getNewCrs();
                boolean isAscii = TiffAsciiExportWizard.this.mainPage.isAscii();
                boolean isTiff = TiffAsciiExportWizard.this.mainPage.isTiff();
                pm.beginTask("Exporting map...", -1);
                try {
                    if (!geoResource.canResolve(GridCoverage.class)) {
                        throw new IOException("The selected resource doesn't seem to be a coverage layer: " + geoResource.getTitle());
                    }
                    GridCoverage2D coverage2D = (GridCoverage2D)geoResource.resolve(GridCoverage.class, pm);
                    TiffAsciiExportWizard.this.dumpMap(coverage2D, fileCrs, newCrs, newPath, isAscii, isTiff);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = "An error occurred while exporting the resource: " + geoResource.getTitle();
                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
                }
                pm.done();
            }
        };
        PlatformGIS.runInProgressDialog((String)"Downloading selected maps", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
        return true;
    }

    public boolean canFinish() {
        return super.canFinish() && canFinish;
    }

    private void dumpMap(GridCoverage2D coverage2D, CoordinateReferenceSystem fileCrs, CoordinateReferenceSystem newCrs, String newFilePath, boolean isAscii, boolean isTiff) throws FactoryException, IOException {
        ArcGridWriter gtw;
        File dumpFile;
        ParameterValueGroup paramWrite;
        GeoTiffWriteParams wp;
        GeoTiffFormat format;
        MathTransform mathTransform;
        if (newCrs != null && !(mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)fileCrs, (CoordinateReferenceSystem)newCrs)).isIdentity()) {
            coverage2D = (GridCoverage2D)Operations.DEFAULT.resample((Coverage)coverage2D, newCrs);
        }
        if (isTiff) {
            format = new GeoTiffFormat();
            wp = new GeoTiffWriteParams();
            wp.setCompressionMode(1);
            wp.setTilingMode(1);
            paramWrite = format.getWriteParameters();
            paramWrite.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
            dumpFile = new File(String.valueOf(newFilePath) + ".tif");
            gtw = (GeoTiffWriter)format.getWriter((Object)dumpFile);
            gtw.write((GridCoverage)coverage2D, paramWrite.values().toArray(new GeneralParameterValue[1]));
        }
        if (isAscii) {
            format = new ArcGridFormat();
            wp = new ArcGridWriteParams();
            paramWrite = format.getWriteParameters();
            paramWrite.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
            dumpFile = new File(String.valueOf(newFilePath) + ".asc");
            gtw = (ArcGridWriter)format.getWriter((Object)dumpFile);
            gtw.write((GridCoverage)coverage2D, paramWrite.values().toArray(new GeneralParameterValue[1]));
        }
    }
}

