/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalogbuilder;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.SwingUtilities;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

public class CatalogBuilder
implements Runnable {
    private static final double RESOLUTION_TOLERANCE_FACTOR = 0.01;
    static final Logger LOGGER = Logging.getLogger(CatalogBuilder.class);
    private int numFiles;
    private List<ProcessingEventListener> notificationListeners = new CopyOnWriteArrayList<ProcessingEventListener>();
    private boolean sendDelayedMessages = false;
    private volatile boolean stop = false;
    private MosaicConfigurationBean mosaicConfiguration;
    private GeometryFactory geomFactory;
    private GranuleCatalog catalog;
    private int numberOfProcessedFiles;
    private boolean mustConvertToRGB = false;
    private int fileIndex = 0;
    private ColorModel defaultCM = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private byte[][] defaultPalette = null;
    private CatalogBuilderConfiguration runConfiguration;
    private ImageReaderSpi cachedReaderSPI;
    private ImageInputStreamSpi cachedStreamSPI;
    private List<PropertiesCollector> propertiesCollectors;
    private SampleModel defaultSM;
    private ReferencedEnvelope imposedBBox;
    private SimpleFeatureType indexSchema;
    private AbstractGridFormat cachedFormat;

    @Override
    public void run() {
        try {
            IOFileFilter finalFilter = this.createGranuleFilterRules();
            this.numFiles = 0;
            for (String indexingDirectory : this.runConfiguration.getIndexingDirectories()) {
                File directoryToScan = new File(indexingDirectory);
                Collection files = FileUtils.listFiles((File)directoryToScan, (IOFileFilter)finalFilter, (IOFileFilter)(this.runConfiguration.isRecursive() ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));
                this.numFiles += files.size();
            }
            if (this.numFiles > 0) {
                List<String> indexingDirectories = this.runConfiguration.getIndexingDirectories();
                CatalogBuilderDirectoryWalker catalogBuilderDirectoryWalker = new CatalogBuilderDirectoryWalker(indexingDirectories, (FileFilter)finalFilter);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private IOFileFilter createGranuleFilterRules() {
        WildcardFileFilter specialWildCardFileFilter = new WildcardFileFilter(this.runConfiguration.getWildcard(), IOCase.INSENSITIVE);
        IOFileFilter dirFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)HiddenFileFilter.VISIBLE);
        IOFileFilter fileFilter = Utils.excludeFilters(FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)specialWildCardFileFilter, (IOFileFilter)HiddenFileFilter.VISIBLE))), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"qix"), FileFilterUtils.suffixFileFilter((String)"lyr"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.nameFileFilter((String)"error.txt"), FileFilterUtils.nameFileFilter((String)"error.txt.lck"), FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"svn-base"));
        Set extensions = WorldImageFormat.getWorldExtension((String)"png");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"gif");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"jpg");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"tiff");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"bmp");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"sdw")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"aux")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"wld")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"svn")));
        IOFileFilter finalFilter = FileFilterUtils.orFileFilter((IOFileFilter)dirFilter, (IOFileFilter)fileFilter);
        return finalFilter;
    }

    public CatalogBuilder(CatalogBuilderConfiguration configuration) {
        Utilities.ensureNonNull((String)"runConfiguration", (Object)configuration);
        Utilities.ensureNonNull((String)"root location", (Object)configuration.getRootMosaicDirectory());
        File parent = new File(configuration.getRootMosaicDirectory());
        File indexerProperties = new File(parent, "indexer.properties");
        if (Utils.checkFileReadable(indexerProperties)) {
            Properties props = Utils.loadPropertiesFromURL(DataUtilities.fileToURL((File)indexerProperties));
            if (props.containsKey("Name")) {
                configuration.setIndexName(props.getProperty("Name"));
            }
            if (props.containsKey("AbsolutePath")) {
                configuration.setAbsolute(Boolean.valueOf(props.getProperty("AbsolutePath")));
            }
            if (props.containsKey("Recursive")) {
                configuration.setRecursive(Boolean.valueOf(props.getProperty("Recursive")));
            }
            if (props.containsKey("Wildcard")) {
                configuration.setWildcard(props.getProperty("Wildcard"));
            }
            if (props.containsKey("Schema")) {
                configuration.setSchema(props.getProperty("Schema"));
            }
            if (props.containsKey("TimeAttribute")) {
                configuration.setTimeAttribute(props.getProperty("TimeAttribute"));
            }
            if (props.containsKey("ElevationAttribute")) {
                configuration.setElevationAttribute(props.getProperty("ElevationAttribute"));
            }
            if (props.containsKey("Envelope2D")) {
                configuration.setEnvelope2D(props.getProperty("Envelope2D"));
            }
            if (props.containsKey("ResolutionLevels")) {
                configuration.setResolutionLevels(props.getProperty("ResolutionLevels"));
            }
            if (props.containsKey("PropertyCollectors")) {
                configuration.setPropertyCollectors(props.getProperty("PropertyCollectors"));
            }
            if (props.containsKey("Caching")) {
                configuration.setCaching(Boolean.valueOf(props.getProperty("Caching")));
            }
        }
        configuration.check();
        this.runConfiguration = new CatalogBuilderConfiguration(configuration);
    }

    public final void addProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.add(listener);
    }

    public void reset() {
        this.removeAllProcessingEventListeners();
        this.stop = false;
        this.closeIndexObjects();
        this.defaultCM = null;
        this.defaultCRS = null;
        this.defaultPalette = null;
        this.fileIndex = 0;
        this.numberOfProcessedFiles = 0;
        this.runConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(Level level, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            ProcessingEvent evt = new ProcessingEvent(this, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.fireException(Utils.getMessageFromException(ex), -1.0, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(String string, double percentage, Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(string);
            ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public boolean isSendDelayedMessages() {
        return this.sendDelayedMessages;
    }

    public void setSendDelayedMessages(boolean sendDelayedMessages) {
        this.sendDelayedMessages = sendDelayedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProcessingEventListeners() {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.clear();
        }
    }

    public void removeProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.remove(listener);
    }

    private void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        if (this.sendDelayedMessages) {
            SwingUtilities.invokeLater(eventLauncher);
        } else {
            eventLauncher.run();
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void indexingPreamble() throws IOException {
        block10: {
            PrecisionModel precMod = new PrecisionModel(PrecisionModel.FLOATING);
            this.geomFactory = new GeometryFactory(precMod);
            File parent = new File(this.runConfiguration.getRootMosaicDirectory());
            File datastoreProperties = new File(parent, "datastore.properties");
            if (Utils.checkFileReadable(datastoreProperties)) {
                Properties properties = Utils.loadPropertiesFromURL(DataUtilities.fileToURL((File)datastoreProperties));
                if (properties == null) {
                    throw new IOException("Unable to load properties from:" + datastoreProperties.getAbsolutePath());
                }
                String SPIClass = properties.getProperty("SPI");
                try {
                    DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
                    Map<String, Serializable> params = Utils.createDataStoreParamsFromPropertiesFile(properties, spi);
                    params.put("ParentLocation", (Serializable)((Object)DataUtilities.fileToURL((File)parent).toExternalForm()));
                    this.catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, true, spi);
                }
                catch (ClassNotFoundException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
                catch (InstantiationException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
                catch (IllegalAccessException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
            } else {
                URL file = new File(parent, this.runConfiguration.getIndexName() + ".shp").toURI().toURL();
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put(ShapefileDataStoreFactory.URLP.key, file);
                if (file.getProtocol().equalsIgnoreCase("file")) {
                    params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
                }
                params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.TRUE);
                params.put(ShapefileDataStoreFactory.DBFTIMEZONE.key, TimeZone.getTimeZone("UTC"));
                this.catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, true, Utils.SHAPE_SPI);
            }
            this.mosaicConfiguration = new MosaicConfigurationBean();
            this.mosaicConfiguration.setName(this.runConfiguration.getIndexName());
            String bbox = this.runConfiguration.getEnvelope2D();
            try {
                this.imposedBBox = Utils.parseEnvelope(bbox);
            }
            catch (Exception e) {
                this.imposedBBox = null;
                if (!LOGGER.isLoggable(Level.WARNING)) break block10;
                LOGGER.log(Level.WARNING, "Unable to parse imposed bbox", e);
            }
        }
        this.mosaicConfiguration.setCaching(this.runConfiguration.isCaching());
        this.loadPropertyCollectors();
    }

    private void loadPropertyCollectors() {
        String pcConfig = this.runConfiguration.getPropertyCollectors();
        if (pcConfig != null && pcConfig.length() > 0) {
            String[] pcsDefs;
            Set<PropertiesCollectorSPI> pcSPIs = PropertiesCollectorFinder.getPropertiesCollectorSPI();
            ArrayList<PropertiesCollector> pcs = new ArrayList<PropertiesCollector>();
            for (String pcDef : pcsDefs = pcConfig.split(",")) {
                int squareLPos = pcDef.indexOf("[");
                int squareRPos = pcDef.indexOf("]");
                int squareRPosLast = pcDef.lastIndexOf("]");
                int roundLPos = pcDef.indexOf("(");
                int roundRPos = pcDef.indexOf(")");
                int roundRPosLast = pcDef.lastIndexOf(")");
                if (squareRPos != squareRPosLast || squareLPos == -1 || squareRPos == -1 || squareLPos == 0 || roundRPos != roundRPosLast || roundLPos == -1 || roundRPos == -1 || roundLPos == 0 || roundLPos != squareRPos + 1 || roundRPos != pcDef.length() - 1) continue;
                String name = pcDef.substring(0, squareLPos);
                PropertiesCollectorSPI selectedSPI = null;
                for (PropertiesCollectorSPI spi : pcSPIs) {
                    if (!spi.isAvailable() || !spi.getName().equalsIgnoreCase(name)) continue;
                    selectedSPI = spi;
                    break;
                }
                if (selectedSPI == null) continue;
                String config = squareLPos < squareRPos ? pcDef.substring(squareLPos + 1, squareRPos) : "";
                File configFile = new File(this.runConfiguration.getRootMosaicDirectory(), config + ".properties");
                if (!Utils.checkFileReadable(configFile)) continue;
                String[] propertyNames = pcDef.substring(roundLPos + 1, roundRPos).split(",");
                PropertiesCollector pc = selectedSPI.create(configFile, Arrays.asList(propertyNames));
                if (pc != null) {
                    pcs.add(pc);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Unable to create PropertyCollector from config file:" + configFile);
            }
            this.propertiesCollectors = pcs;
        }
    }

    private void indexingPostamble(boolean success) throws IOException {
        this.closeIndexObjects();
        if (success) {
            this.createSampleImage();
            if (this.numberOfProcessedFiles > 0) {
                String elevationAttribute;
                this.mosaicConfiguration.setName(this.runConfiguration.getIndexName());
                this.mosaicConfiguration.setExpandToRGB(this.mustConvertToRGB);
                this.mosaicConfiguration.setAbsolutePath(this.runConfiguration.isAbsolute());
                this.mosaicConfiguration.setLocationAttribute(this.runConfiguration.getLocationAttribute());
                this.mosaicConfiguration.setCaching(this.runConfiguration.isCaching());
                String timeAttribute = this.runConfiguration.getTimeAttribute();
                if (timeAttribute != null) {
                    this.mosaicConfiguration.setTimeAttribute(this.runConfiguration.getTimeAttribute());
                }
                if ((elevationAttribute = this.runConfiguration.getElevationAttribute()) != null) {
                    this.mosaicConfiguration.setElevationAttribute(this.runConfiguration.getElevationAttribute());
                }
                this.createPropertiesFiles();
                this.fireEvent(Level.FINE, "Done!!!", 100.0);
            } else {
                this.fireEvent(Level.FINE, "Nothing to process!!!", 100.0);
            }
        } else {
            this.fireEvent(Level.FINE, "Canceled!!!", 100.0);
        }
    }

    private void createSampleImage() {
        if (this.defaultCM != null && this.defaultSM != null) {
            File sampleImageFile = new File(this.runConfiguration.getRootMosaicDirectory() + "/sample_image");
            try {
                Utils.storeSampleImage(sampleImageFile, this.defaultSM, this.defaultCM);
            }
            catch (IOException e) {
                this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
            }
        }
    }

    private void closeIndexObjects() {
        try {
            if (this.catalog != null) {
                this.catalog.dispose();
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.catalog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createPropertiesFiles() {
        String elevationAttribute;
        this.fireEvent(Level.INFO, "Creating final properties file ", 99.9);
        Properties properties = new Properties();
        properties.setProperty("AbsolutePath", Boolean.toString(this.mosaicConfiguration.isAbsolutePath()));
        properties.setProperty("LocationAttribute", this.mosaicConfiguration.getLocationAttribute());
        String timeAttribute = this.mosaicConfiguration.getTimeAttribute();
        if (timeAttribute != null) {
            properties.setProperty("TimeAttribute", this.mosaicConfiguration.getTimeAttribute());
        }
        if ((elevationAttribute = this.mosaicConfiguration.getElevationAttribute()) != null) {
            properties.setProperty("ElevationAttribute", this.mosaicConfiguration.getElevationAttribute());
        }
        int numberOfLevels = this.mosaicConfiguration.getLevelsNum();
        double[][] resolutionLevels = this.mosaicConfiguration.getLevels();
        properties.setProperty("LevelsNum", Integer.toString(numberOfLevels));
        StringBuilder levels = new StringBuilder();
        for (int k = 0; k < numberOfLevels; ++k) {
            levels.append(Double.toString(resolutionLevels[0][k])).append(",").append(Double.toString(resolutionLevels[1][k]));
            if (k >= numberOfLevels - 1) continue;
            levels.append(" ");
        }
        properties.setProperty("Levels", levels.toString());
        properties.setProperty("Name", this.mosaicConfiguration.getName());
        properties.setProperty("TypeName", this.mosaicConfiguration.getName());
        properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
        properties.setProperty("Heterogeneous", Boolean.toString(this.mosaicConfiguration.isHeterogeneous()));
        if (this.cachedReaderSPI != null) {
            properties.setProperty("SuggestedSPI", this.cachedReaderSPI.getClass().getName());
        }
        if (this.imposedBBox != null) {
            properties.setProperty("Envelope2D", this.imposedBBox.getMinX() + "," + this.imposedBBox.getMinY() + " " + this.imposedBBox.getMaxX() + "," + this.imposedBBox.getMaxY());
        }
        properties.setProperty("Caching", Boolean.toString(this.mosaicConfiguration.isCaching()));
        BufferedOutputStream outStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(this.runConfiguration.getRootMosaicDirectory() + "/" + this.runConfiguration.getIndexName() + ".properties"));
            properties.store(outStream, "-Automagically created from GeoTools-");
            if (outStream == null) return;
        }
        catch (FileNotFoundException e) {
            this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
            return;
        }
        catch (IOException e2) {
            this.fireEvent(Level.SEVERE, e2.getLocalizedMessage(), 0.0);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (outStream != null) {
                IOUtils.closeQuietly(outStream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outStream);
        return;
    }

    public void dispose() {
        this.reset();
    }

    private static boolean setupResolutions(double[][] resolutionLevels, int numberOfLevels, AbstractGridCoverage2DReader coverageReader, ImageReader imageioReader, double[][] compareLevels) throws IndexOutOfBoundsException, IOException {
        boolean checkLevels;
        double[] res = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)coverageReader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)));
        resolutionLevels[0][0] = res[0];
        resolutionLevels[1][0] = res[1];
        boolean bl = checkLevels = compareLevels != null;
        if (numberOfLevels >= 1) {
            for (int k = 0; k < numberOfLevels; ++k) {
                resolutionLevels[0][k] = resolutionLevels[0][0] * (double)coverageReader.getOriginalGridRange().getSpan(0) / (1.0 * (double)imageioReader.getWidth(k));
                resolutionLevels[1][k] = resolutionLevels[1][0] * (double)coverageReader.getOriginalGridRange().getSpan(1) / (1.0 * (double)imageioReader.getHeight(k));
                if (!checkLevels || !(Math.abs(resolutionLevels[0][k] - compareLevels[0][k]) > 0.01 * compareLevels[0][k]) && !(Math.abs(resolutionLevels[1][k] - compareLevels[1][k]) > 0.01 * compareLevels[1][k])) continue;
                return false;
            }
        }
        return true;
    }

    public MosaicConfigurationBean getMosaicConfiguration() {
        return new MosaicConfigurationBean(this.mosaicConfiguration);
    }

    static /* synthetic */ byte[][] access$1102(CatalogBuilder x0, byte[][] x1) {
        x0.defaultPalette = x1;
        return x1;
    }

    final class CatalogBuilderDirectoryWalker
    extends DirectoryWalker {
        private DefaultTransaction transaction;
        private volatile boolean canceled;

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            super.handleCancelled(startDirectory, results, cancel);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Stop requested when walking directory " + startDirectory);
            }
            super.handleEnd(results);
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
            if (!this.checkStop()) {
                this.canceled = true;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleFile(File fileBeingProcessed, int depth, Collection results) throws IOException {
            String validFileName;
            CatalogBuilder.this.fileIndex++;
            if (!this.checkFile(fileBeingProcessed)) {
                return;
            }
            try {
                validFileName = fileBeingProcessed.getCanonicalPath();
                validFileName = FilenameUtils.normalize((String)validFileName);
            }
            catch (IOException e1) {
                CatalogBuilder.this.fireException(e1);
                return;
            }
            validFileName = FilenameUtils.getName((String)validFileName);
            CatalogBuilder.this.fireEvent(Level.INFO, "Now indexing file " + validFileName, (double)CatalogBuilder.this.fileIndex * 100.0 / (double)CatalogBuilder.this.numFiles);
            ImageInputStream inStream = null;
            ImageReader imageioReader = null;
            AbstractGridCoverage2DReader coverageReader = null;
            try {
                double[][] resolutionLevels;
                if (CatalogBuilder.this.cachedStreamSPI != null) {
                    inStream = CatalogBuilder.this.cachedStreamSPI.createInputStreamInstance(fileBeingProcessed);
                }
                if (inStream == null) {
                    CatalogBuilder.this.cachedStreamSPI = ImageIOExt.getImageInputStreamSPI((Object)fileBeingProcessed);
                    if (CatalogBuilder.this.cachedStreamSPI != null) {
                        inStream = CatalogBuilder.this.cachedStreamSPI.createInputStreamInstance(fileBeingProcessed);
                    }
                }
                if (inStream == null) {
                    CatalogBuilder.this.fireEvent(Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)CatalogBuilder.this.fileIndex * 100.0 / (double)CatalogBuilder.this.numFiles);
                    return;
                }
                inStream.mark();
                if (CatalogBuilder.this.cachedReaderSPI == null) {
                    Iterator<ImageReader> it = ImageIO.getImageReaders(inStream);
                    if (it.hasNext()) {
                        imageioReader = it.next();
                        if (imageioReader != null) {
                            CatalogBuilder.this.cachedReaderSPI = imageioReader.getOriginatingProvider();
                            imageioReader.setInput(inStream);
                        }
                    } else {
                        imageioReader = null;
                    }
                } else if (!CatalogBuilder.this.cachedReaderSPI.canDecodeInput(inStream)) {
                    CatalogBuilder.this.cachedReaderSPI = null;
                } else {
                    imageioReader = CatalogBuilder.this.cachedReaderSPI.createReaderInstance();
                    imageioReader.setInput(inStream);
                }
                if (imageioReader == null) {
                    CatalogBuilder.this.fireEvent(Level.INFO, "Skipped file " + fileBeingProcessed + ":No ImageIO reader\ts availaible.", (double)CatalogBuilder.this.fileIndex * 99.0 / (double)CatalogBuilder.this.numFiles);
                    return;
                }
                Object format = CatalogBuilder.this.cachedFormat == null ? GridFormatFinder.findFormat((Object)fileBeingProcessed) : (CatalogBuilder.this.cachedFormat.accepts((Object)fileBeingProcessed) ? CatalogBuilder.this.cachedFormat : new UnknownFormat());
                if (format instanceof UnknownFormat || format == null) {
                    CatalogBuilder.this.fireEvent(Level.INFO, "Skipped file " + fileBeingProcessed + ": File format is not supported.", (double)CatalogBuilder.this.fileIndex * 99.0 / (double)CatalogBuilder.this.numFiles);
                    return;
                }
                CatalogBuilder.this.cachedFormat = format;
                coverageReader = format.getReader((Object)fileBeingProcessed, CatalogBuilder.this.runConfiguration.getHints());
                GeneralEnvelope envelope = coverageReader.getOriginalEnvelope();
                CoordinateReferenceSystem actualCRS = coverageReader.getCrs();
                ImageTypeSpecifier its = imageioReader.getImageTypes(0).next();
                if (CatalogBuilder.this.numberOfProcessedFiles == 0) {
                    CatalogBuilder.this.defaultCM = its.getColorModel();
                    CatalogBuilder.this.defaultSM = its.getSampleModel();
                    if (CatalogBuilder.this.defaultCM instanceof IndexColorModel) {
                        IndexColorModel icm = (IndexColorModel)CatalogBuilder.this.defaultCM;
                        int numBands = CatalogBuilder.this.defaultCM.getNumColorComponents();
                        CatalogBuilder.access$1102(CatalogBuilder.this, new byte[3][icm.getMapSize()]);
                        icm.getReds(CatalogBuilder.this.defaultPalette[0]);
                        icm.getGreens(CatalogBuilder.this.defaultPalette[0]);
                        icm.getBlues(CatalogBuilder.this.defaultPalette[0]);
                        if (numBands == 4) {
                            icm.getAlphas(CatalogBuilder.this.defaultPalette[0]);
                        }
                    }
                    CatalogBuilder.this.defaultCRS = actualCRS;
                    imageioReader.reset();
                    try {
                        inStream.reset();
                    }
                    catch (IOException e) {
                        block116: {
                            try {
                                inStream.close();
                            }
                            catch (Throwable e1) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block116;
                                LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                            }
                        }
                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                    }
                    if (inStream == null) {
                        CatalogBuilder.this.fireEvent(Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)CatalogBuilder.this.fileIndex * 100.0 / (double)CatalogBuilder.this.numFiles);
                        return;
                    }
                    imageioReader.setInput(inStream);
                    int numberOfLevels = imageioReader.getNumImages(true);
                    resolutionLevels = new double[2][numberOfLevels];
                    CatalogBuilder.setupResolutions(resolutionLevels, numberOfLevels, coverageReader, imageioReader, null);
                    CatalogBuilder.this.mosaicConfiguration.setLevelsNum(numberOfLevels);
                    CatalogBuilder.this.mosaicConfiguration.setLevels(resolutionLevels);
                    String schemaDef = CatalogBuilder.this.runConfiguration.getSchema();
                    if (schemaDef != null) {
                        try {
                            CatalogBuilder.this.indexSchema = DataUtilities.createType((String)CatalogBuilder.this.mosaicConfiguration.getName(), (String)CatalogBuilder.this.runConfiguration.getSchema());
                            CatalogBuilder.this.indexSchema = DataUtilities.createSubType((SimpleFeatureType)CatalogBuilder.this.indexSchema, (String[])DataUtilities.attributeNames((SimpleFeatureType)CatalogBuilder.this.indexSchema), (CoordinateReferenceSystem)actualCRS);
                        }
                        catch (Throwable e) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                            CatalogBuilder.this.indexSchema = null;
                        }
                    }
                    if (CatalogBuilder.this.indexSchema == null) {
                        SimpleFeatureTypeBuilder featureBuilder = new SimpleFeatureTypeBuilder();
                        featureBuilder.setName(CatalogBuilder.this.runConfiguration.getIndexName());
                        featureBuilder.setNamespaceURI("http://www.geo-solutions.it/");
                        featureBuilder.add(CatalogBuilder.this.runConfiguration.getLocationAttribute(), String.class);
                        featureBuilder.add("the_geom", Polygon.class, actualCRS);
                        featureBuilder.setDefaultGeometry("the_geom");
                        if (CatalogBuilder.this.runConfiguration.getTimeAttribute() != null) {
                            featureBuilder.add(CatalogBuilder.this.runConfiguration.getTimeAttribute(), Date.class);
                        }
                        CatalogBuilder.this.indexSchema = featureBuilder.buildFeatureType();
                    }
                    CatalogBuilder.this.catalog.createType(CatalogBuilder.this.indexSchema);
                } else {
                    if (!CatalogBuilder.this.mosaicConfiguration.isHeterogeneous()) {
                        int numberOfLevels = imageioReader.getNumImages(true);
                        if (numberOfLevels != CatalogBuilder.this.mosaicConfiguration.getLevelsNum()) {
                            CatalogBuilder.this.mosaicConfiguration.setHeterogeneous(true);
                            if (numberOfLevels > CatalogBuilder.this.mosaicConfiguration.getLevelsNum()) {
                                resolutionLevels = new double[2][numberOfLevels];
                                CatalogBuilder.setupResolutions(resolutionLevels, numberOfLevels, coverageReader, imageioReader, null);
                                CatalogBuilder.this.mosaicConfiguration.setLevelsNum(numberOfLevels);
                                CatalogBuilder.this.mosaicConfiguration.setLevels(resolutionLevels);
                            }
                        } else {
                            double[][] resolutionLevels2 = new double[2][numberOfLevels];
                            double[][] mosaicLevels = CatalogBuilder.this.mosaicConfiguration.getLevels();
                            boolean homogeneousLevels = CatalogBuilder.setupResolutions(resolutionLevels2, numberOfLevels, coverageReader, imageioReader, mosaicLevels);
                            if (!homogeneousLevels) {
                                CatalogBuilder.this.mosaicConfiguration.setHeterogeneous(true);
                            }
                        }
                    }
                    ColorModel actualCM = its.getColorModel();
                    if (CatalogBuilder.this.fileIndex > 0 && !CRS.equalsIgnoreMetadata((Object)CatalogBuilder.this.defaultCRS, (Object)actualCRS)) {
                        CatalogBuilder.this.fireEvent(Level.INFO, "Skipping image " + fileBeingProcessed + " because CRSs do not match.", (double)(CatalogBuilder.this.fileIndex + 1) * 99.0 / (double)CatalogBuilder.this.numFiles);
                        return;
                    }
                    if (this.checkColorModels(CatalogBuilder.this.defaultCM, CatalogBuilder.this.defaultPalette, actualCM)) {
                        CatalogBuilder.this.fireEvent(Level.INFO, "Skipping image " + fileBeingProcessed + " because color models do not match.", (double)(CatalogBuilder.this.fileIndex + 1) * 99.0 / (double)CatalogBuilder.this.numFiles);
                        return;
                    }
                }
                SimpleFeature feature = DataUtilities.template((SimpleFeatureType)CatalogBuilder.this.indexSchema);
                feature.setAttribute(CatalogBuilder.this.indexSchema.getGeometryDescriptor().getLocalName(), (Object)CatalogBuilder.this.geomFactory.toGeometry(new ReferencedEnvelope((Envelope)envelope)));
                feature.setAttribute(CatalogBuilder.this.runConfiguration.getLocationAttribute(), (Object)this.prepareLocation(fileBeingProcessed));
                if (CatalogBuilder.this.propertiesCollectors != null && CatalogBuilder.this.propertiesCollectors.size() > 0) {
                    for (PropertiesCollector pc : CatalogBuilder.this.propertiesCollectors) {
                        pc.collect(fileBeingProcessed).collect(coverageReader).collect(imageioReader).setProperties(feature);
                        pc.reset();
                    }
                }
                CatalogBuilder.this.catalog.addGranule(feature, (Transaction)this.transaction);
                CatalogBuilder.this.fireEvent(Level.FINE, "Done with file " + fileBeingProcessed, (double)(CatalogBuilder.this.fileIndex + 1) * 99.0 / (double)CatalogBuilder.this.numFiles);
                CatalogBuilder.this.numberOfProcessedFiles++;
            }
            catch (IOException e) {
                CatalogBuilder.this.fireException(e);
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                CatalogBuilder.this.fireException(e);
                return;
            }
            finally {
                block120: {
                    block119: {
                        block118: {
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (Throwable e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block118;
                                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            if (imageioReader != null) {
                                imageioReader.dispose();
                            }
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block119;
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        if (coverageReader != null) {
                            coverageReader.dispose();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block120;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
            super.handleFile(fileBeingProcessed, depth, results);
        }

        private String prepareLocation(File fileBeingProcessed) throws IOException {
            if (CatalogBuilder.this.runConfiguration.isAbsolute()) {
                return fileBeingProcessed.getAbsolutePath();
            }
            String path = fileBeingProcessed.getCanonicalPath();
            path = path.substring(CatalogBuilder.this.runConfiguration.getRootMosaicDirectory().length());
            return path;
        }

        private boolean checkStop() {
            if (CatalogBuilder.this.getStop()) {
                CatalogBuilder.this.fireEvent(Level.INFO, "Stopping requested at file  " + CatalogBuilder.this.fileIndex + " of " + CatalogBuilder.this.numFiles + " files", (double)CatalogBuilder.this.fileIndex * 100.0 / (double)CatalogBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        private boolean checkFile(File fileBeingProcessed) {
            if (!(fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile())) {
                CatalogBuilder.this.fireEvent(Level.INFO, "Skipped file " + fileBeingProcessed + " snce it seems invalid", (double)CatalogBuilder.this.fileIndex * 99.0 / (double)CatalogBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public CatalogBuilderDirectoryWalker(List<String> indexingDirectories, FileFilter filter) throws IOException {
            block25: {
                String message;
                block24: {
                    super(filter, Integer.MAX_VALUE);
                    this.transaction = new DefaultTransaction("MosaicCreationTransaction" + System.nanoTime());
                    CatalogBuilder.this.indexingPreamble();
                    for (String indexingDirectory : indexingDirectories) {
                        this.walk(new File(indexingDirectory), null);
                        if (!this.canceled) continue;
                        break;
                    }
                    if (this.canceled) {
                        this.transaction.rollback();
                        break block24;
                    }
                    this.transaction.commit();
                }
                try {
                    this.transaction.close();
                }
                catch (Exception e) {
                    message = "Unable to close indexing" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    CatalogBuilder.this.fireException(e);
                }
                try {
                    CatalogBuilder.this.indexingPostamble(!this.canceled);
                }
                catch (Exception e) {
                    message = "Unable to close indexing" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    CatalogBuilder.this.fireException(e);
                }
                break block25;
                catch (Exception e) {
                    String message2;
                    try {
                        LOGGER.log(Level.WARNING, "Failure occurred while collecting the granules", e);
                        this.transaction.rollback();
                    }
                    catch (Throwable throwable) {
                        String message3;
                        try {
                            this.transaction.close();
                        }
                        catch (Exception e2) {
                            message3 = "Unable to close indexing" + e2.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e2);
                            }
                            CatalogBuilder.this.fireException(e2);
                        }
                        try {
                            CatalogBuilder.this.indexingPostamble(!this.canceled);
                        }
                        catch (Exception e3) {
                            message3 = "Unable to close indexing" + e3.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e3);
                            }
                            CatalogBuilder.this.fireException(e3);
                        }
                        throw throwable;
                    }
                    try {
                        this.transaction.close();
                    }
                    catch (Exception e4) {
                        message2 = "Unable to close indexing" + e4.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e4);
                        }
                        CatalogBuilder.this.fireException(e4);
                    }
                    try {
                        CatalogBuilder.this.indexingPostamble(!this.canceled);
                    }
                    catch (Exception e5) {
                        message2 = "Unable to close indexing" + e5.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e5);
                        }
                        CatalogBuilder.this.fireException(e5);
                    }
                }
            }
        }

        public int getNumberOfProcessedFiles() {
            return CatalogBuilder.this.numberOfProcessedFiles;
        }

        private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
            if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
                boolean colorSpaceIsOk;
                ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
                ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
                ColorSpace defCS = defCCM.getColorSpace();
                ColorSpace actualCS = actualCCM.getColorSpace();
                boolean isBogusDef = defCS instanceof BogusColorSpace;
                boolean isBogusActual = actualCS instanceof BogusColorSpace;
                if (isBogusDef && isBogusActual) {
                    BogusColorSpace def = (BogusColorSpace)defCS;
                    BogusColorSpace act = (BogusColorSpace)actualCS;
                    colorSpaceIsOk = def.getNumComponents() == act.getNumComponents() && def.isCS_sRGB() == act.isCS_sRGB() && def.getType() == act.getType();
                } else {
                    colorSpaceIsOk = defCS.equals(actualCS);
                }
                return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !colorSpaceIsOk || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
            }
            if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
                IndexColorModel defICM = (IndexColorModel)defaultCM;
                IndexColorModel actualICM = (IndexColorModel)actualCM;
                if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                    return true;
                }
                if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                    CatalogBuilder.this.mustConvertToRGB = true;
                    return false;
                }
                int numBands = actualICM.getNumColorComponents();
                byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
                actualICM.getReds(actualPalette[0]);
                actualICM.getGreens(actualPalette[0]);
                actualICM.getBlues(actualPalette[0]);
                if (numBands == 4) {
                    actualICM.getAlphas(defaultPalette[0]);
                }
                block0: for (int i = 0; i < defICM.getMapSize(); ++i) {
                    for (int j = 0; j < numBands; ++j) {
                        if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                        CatalogBuilder.this.mustConvertToRGB = true;
                        continue block0;
                    }
                }
                return false;
            }
            return true;
        }
    }

    static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            if (listeners == null || evt == null) {
                throw new NullPointerException("Input argumentBuilder cannot be null");
            }
            this.listeners = listeners;
            this.event = evt;
        }

        @Override
        public void run() {
            int numListeners = this.listeners.length;
            if (this.event instanceof ExceptionEvent) {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).getNotification(this.event);
                }
            }
        }
    }

    public static final class ExceptionEvent
    extends ProcessingEvent {
        private static final long serialVersionUID = 2272452028229922551L;
        private Exception exception;

        public ExceptionEvent(Object source, String message, double percentage, Exception exception) {
            super(source, message, percentage);
            this.exception = exception;
        }

        public ExceptionEvent(Object source, Exception exception) {
            super(source, Utils.getMessageFromException(exception), -1.0);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class ProcessingEvent
    extends EventObject {
        private static final long serialVersionUID = 6930580659705360225L;
        private String message = null;
        private double percentage = 0.0;

        public ProcessingEvent(Object source, String message, double percentage) {
            super(source);
            this.message = message;
            this.percentage = percentage;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static abstract class ProcessingEventListener
    implements EventListener {
        public abstract void getNotification(ProcessingEvent var1);

        public abstract void exceptionOccurred(ExceptionEvent var1);
    }
}

