/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.h2.H2DataStoreFactory;
import org.geotools.data.h2.H2JNDIDataStoreFactory;
import org.geotools.data.oracle.OracleNGDataStoreFactory;
import org.geotools.data.oracle.OracleNGJNDIDataStoreFactory;
import org.geotools.data.oracle.OracleNGOCIDataStoreFactory;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.postgis.PostgisNGJNDIDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.catalog.AbstractGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DefaultProgressListener;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.util.ProgressListener;

class GTDataStoreGranuleCatalog
extends AbstractGranuleCatalog {
    static final Logger LOGGER = Logging.getLogger(GTDataStoreGranuleCatalog.class);
    static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(GeoTools.getDefaultHints());
    private DataStore tileIndexStore;
    private String typeName;
    private String geometryPropertyName;
    private ReferencedEnvelope bounds;
    private DataStoreFactorySpi spi;
    private PathType pathType;
    private String locationAttribute;
    private ImageReaderSpi suggestedRasterSPI;
    private String parentLocation;
    private boolean heterogeneous;
    private final SoftValueHashMap<String, GranuleDescriptor> granuleDescriptorsCache = new SoftValueHashMap(0);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GTDataStoreGranuleCatalog(Map<String, Serializable> params, boolean create, DataStoreFactorySpi spi) {
        Utilities.ensureNonNull((String)"params", params);
        Utilities.ensureNonNull((String)"spi", (Object)spi);
        this.spi = spi;
        try {
            this.pathType = (PathType)((Object)params.get("PathType"));
            this.locationAttribute = (String)((Object)params.get("LocationAttribute"));
            String temp = (String)((Object)params.get("SuggestedSPI"));
            this.suggestedRasterSPI = temp != null ? (ImageReaderSpi)Class.forName(temp).newInstance() : null;
            this.parentLocation = (String)((Object)params.get("ParentLocation"));
            Serializable heterogen = params.get("Heterogeneous");
            if (heterogen != null) {
                this.heterogeneous = (Boolean)heterogen;
            }
            if ((spi instanceof H2DataStoreFactory || spi instanceof H2JNDIDataStoreFactory) && params.containsKey(H2DataStoreFactory.DATABASE.key)) {
                String dbname = (String)((Object)params.get(H2DataStoreFactory.DATABASE.key));
                params.put(H2DataStoreFactory.DATABASE.key, (Serializable)((Object)("file:" + new File(DataUtilities.urlToFile((URL)new URL(this.parentLocation)), dbname).getPath())));
            }
            if (!create) {
                this.tileIndexStore = spi.createDataStore(params);
            } else {
                try {
                    this.tileIndexStore = spi.createNewDataStore(params);
                }
                catch (UnsupportedOperationException e) {
                    this.tileIndexStore = spi.createDataStore(params);
                }
            }
            if (create) {
                return;
            }
            if (params.containsKey("TypeName")) {
                this.typeName = (String)((Object)params.get("TypeName"));
                if (spi instanceof OracleNGOCIDataStoreFactory || spi instanceof OracleNGJNDIDataStoreFactory || spi instanceof OracleNGDataStoreFactory) {
                    this.typeName = this.typeName.toUpperCase();
                    if (this.locationAttribute != null) {
                        this.locationAttribute = this.locationAttribute.toUpperCase();
                    }
                }
            }
            this.extractBasicProperties();
        }
        catch (Throwable e) {
            try {
                if (this.tileIndexStore != null) {
                    this.tileIndexStore.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.tileIndexStore = null;
            }
            throw new IllegalArgumentException(e);
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.tileIndexStore == null) {
            throw new IllegalStateException("The index store has been disposed already.");
        }
    }

    private void extractBasicProperties() throws IOException {
        SimpleFeatureSource featureSource;
        if (this.typeName == null) {
            String[] typeNames = this.tileIndexStore.getTypeNames();
            if (typeNames == null || typeNames.length <= 0) {
                throw new IllegalArgumentException("BBOXFilterExtractor::extractBasicProperties(): Problems when opening the index, no typenames for the schema are defined");
            }
            if (this.typeName == null) {
                this.typeName = typeNames[0];
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("BBOXFilterExtractor::extractBasicProperties(): passed typename is null, using: " + this.typeName);
                }
            }
            for (String type : typeNames) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Looking for type '" + this.typeName + "' in DataStore:getTypeNames(). Testing: '" + type + "'.");
                }
                if (!type.equalsIgnoreCase(this.typeName)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): SUCCESS -> type '" + this.typeName + "' is equalsIgnoreCase() to '" + type + "'.");
                }
                this.typeName = type;
                break;
            }
        }
        if ((featureSource = this.tileIndexStore.getFeatureSource(this.typeName)) == null) {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a featureSource for the qualified name" + this.typeName);
        }
        this.bounds = featureSource.getBounds();
        Object schema = featureSource.getSchema();
        if (schema != null) {
            this.geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): geometryPropertyName is set to '" + this.geometryPropertyName + "'.");
            }
        } else {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a schema from the featureSource");
        }
    }

    public List<GranuleDescriptor> getGranules(BoundingBox envelope) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Query q = new Query(this.typeName);
        BBOX filter = ff.bbox((Expression)ff.property(this.geometryPropertyName), (BoundingBox)ReferencedEnvelope.reference(envelope));
        q.setFilter((Filter)filter);
        return this.getGranules(q);
    }

    @Override
    public void getGranules(BoundingBox envelope, GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Query q = new Query(this.typeName);
        BBOX filter = ff.bbox((Expression)ff.property(this.geometryPropertyName), (BoundingBox)ReferencedEnvelope.reference(envelope));
        q.setFilter((Filter)filter);
        this.getGranules(q, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            l.lock();
            try {
                if (this.tileIndexStore != null) {
                    this.tileIndexStore.dispose();
                }
                this.tileIndexStore = null;
            }
            catch (Throwable e) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.tileIndexStore = null;
                }
            }
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeGranules(Query query) {
        Utilities.ensureNonNull((String)"query", (Object)query);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureStore fs = null;
            try {
                fs = (SimpleFeatureStore)this.tileIndexStore.getFeatureSource(this.typeName);
                int retVal = fs.getCount(query);
                fs.removeFeatures(query.getFilter());
                this.bounds = this.tileIndexStore.getFeatureSource(this.typeName).getBounds();
                int n = retVal;
                return n;
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                int n = -1;
                lock.unlock();
                return n;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addGranule(SimpleFeature granule, Transaction transaction) throws IOException {
        this.addGranules(Collections.singleton(granule), transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGranules(Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"granuleMetadata", granules);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            FeatureWriter<SimpleFeatureType, SimpleFeature> fw = null;
            try {
                fw = this.tileIndexStore.getFeatureWriterAppend(this.typeName, transaction);
                for (SimpleFeature f : granules) {
                    SimpleFeature feature = fw.next();
                    for (int i = f.getAttributeCount() - 1; i >= 0; --i) {
                        AttributeDescriptor descriptor;
                        Object attribute = f.getAttribute(i);
                        if ((this.spi instanceof PostgisNGJNDIDataStoreFactory || this.spi instanceof PostgisNGDataStoreFactory) && (descriptor = this.tileIndexStore.getSchema(this.typeName).getDescriptor(i)).getType().getBinding().equals(String.class)) {
                            attribute = ((String)attribute).replace("\\", "\\\\");
                        }
                        feature.setAttribute(i, attribute);
                    }
                    fw.write();
                }
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
            finally {
                if (fw != null) {
                    fw.close();
                }
            }
            this.bounds = null;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getGranules(final Query q, final GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource featureSource = this.tileIndexStore.getFeatureSource(this.typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            SimpleFeatureCollection features = featureSource.getFeatures(q);
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            SimpleFeatureIterator it = features.features();
            try {
                if (!it.hasNext()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("The provided SimpleFeatureCollection  or empty, it's impossible to create an index!");
                    }
                    return;
                }
            }
            finally {
                it.close();
            }
            final DefaultProgressListener listener = new DefaultProgressListener();
            features.accepts((FeatureVisitor)new AbstractFeatureVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visit(Feature feature) {
                    if (feature instanceof SimpleFeature) {
                        GranuleDescriptor granule;
                        SimpleFeature sf = (SimpleFeature)feature;
                        SoftValueHashMap softValueHashMap = GTDataStoreGranuleCatalog.this.granuleDescriptorsCache;
                        synchronized (softValueHashMap) {
                            String granuleLocation = (String)sf.getAttribute(GTDataStoreGranuleCatalog.this.locationAttribute);
                            if (GTDataStoreGranuleCatalog.this.granuleDescriptorsCache.containsKey((Object)granuleLocation)) {
                                granule = (GranuleDescriptor)GTDataStoreGranuleCatalog.this.granuleDescriptorsCache.get((Object)granuleLocation);
                            } else {
                                granule = new GranuleDescriptor(sf, GTDataStoreGranuleCatalog.this.suggestedRasterSPI, GTDataStoreGranuleCatalog.this.pathType, GTDataStoreGranuleCatalog.this.locationAttribute, GTDataStoreGranuleCatalog.this.parentLocation, GTDataStoreGranuleCatalog.this.heterogeneous);
                                GTDataStoreGranuleCatalog.this.granuleDescriptorsCache.put((Object)granuleLocation, (Object)granule);
                            }
                        }
                        visitor.visit(granule, null);
                        if (listener.isCanceled() || listener.hasExceptions()) {
                            if (listener.hasExceptions()) {
                                throw new RuntimeException((Throwable)listener.getExceptions().peek());
                            }
                            throw new IllegalStateException("Feature visitor for query " + q + " has been canceled");
                        }
                    }
                }
            }, (ProgressListener)listener);
        }
        catch (Throwable e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            lock.unlock();
        }
    }

    public List<GranuleDescriptor> getGranules(Query q) throws IOException {
        final ArrayList<GranuleDescriptor> returnValue = new ArrayList<GranuleDescriptor>();
        this.getGranules(q, new GranuleCatalogVisitor(){

            @Override
            public void visit(GranuleDescriptor granule, Object o) {
                returnValue.add(granule);
            }
        });
        return returnValue;
    }

    @Override
    public Collection<GranuleDescriptor> getGranules() throws IOException {
        return this.getGranules(this.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBounds() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            if (this.bounds == null) {
                this.bounds = this.tileIndexStore.getFeatureSource(this.typeName).getBounds();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            this.bounds = null;
        }
        finally {
            lock.unlock();
        }
        return this.bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType featureType = DataUtilities.createType((String)namespace, (String)typeName, (String)typeSpec);
            this.tileIndexStore.createSchema(featureType);
            if (this.spi instanceof OracleNGOCIDataStoreFactory || this.spi instanceof OracleNGJNDIDataStoreFactory || this.spi instanceof OracleNGDataStoreFactory) {
                this.typeName = this.typeName.toUpperCase();
                if (this.locationAttribute != null) {
                    this.locationAttribute = this.locationAttribute.toUpperCase();
                }
            }
            this.extractBasicProperties();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)featureType);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            this.tileIndexStore.createSchema(featureType);
            this.typeName = featureType.getTypeName();
            if (this.spi instanceof OracleNGOCIDataStoreFactory || this.spi instanceof OracleNGJNDIDataStoreFactory || this.spi instanceof OracleNGDataStoreFactory) {
                this.typeName = this.typeName.toUpperCase();
                if (this.locationAttribute != null) {
                    this.locationAttribute = this.locationAttribute.toUpperCase();
                }
            }
            this.extractBasicProperties();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Utilities.ensureNonNull((String)"identification", (Object)identification);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType featureType = DataUtilities.createType((String)identification, (String)typeSpec);
            this.tileIndexStore.createSchema(featureType);
            this.typeName = featureType.getTypeName();
            if (this.spi instanceof OracleNGOCIDataStoreFactory || this.spi instanceof OracleNGJNDIDataStoreFactory || this.spi instanceof OracleNGDataStoreFactory) {
                this.typeName = this.typeName.toUpperCase();
                if (this.locationAttribute != null) {
                    this.locationAttribute = this.locationAttribute.toUpperCase();
                }
            }
            this.extractBasicProperties();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureType getType() throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType simpleFeatureType = this.tileIndexStore.getSchema(this.typeName);
            return simpleFeatureType;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource fs = this.tileIndexStore.getFeatureSource(query.getTypeName());
            if (fs instanceof ContentFeatureSource) {
                ((ContentFeatureSource)fs).accepts(query, (FeatureVisitor)function, null);
            } else {
                SimpleFeatureCollection collection = fs.getFeatures(query);
                collection.accepts((FeatureVisitor)function, null);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCapabilities getQueryCapabilities() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.tileIndexStore.getFeatureSource(this.typeName).getQueryCapabilities();
            return queryCapabilities;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to collect QueryCapabilities", e);
            }
            QueryCapabilities queryCapabilities = null;
            return queryCapabilities;
        }
        finally {
            lock.unlock();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.tileIndexStore != null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("This granule catalog was not properly dispose as it still points to:" + this.tileIndexStore.getInfo().toString());
            }
            this.dispose();
        }
    }

    static class BBOXFilterExtractor
    extends DefaultFilterVisitor {
        private ReferencedEnvelope bbox;

        BBOXFilterExtractor() {
        }

        public ReferencedEnvelope getBBox() {
            return this.bbox;
        }

        public Object visit(BBOX filter, Object data) {
            ReferencedEnvelope bbox = new ReferencedEnvelope(filter.getMinX(), filter.getMaxX(), filter.getMinY(), filter.getMaxY(), null);
            this.bbox = this.bbox != null ? (ReferencedEnvelope)this.bbox.intersection(bbox) : bbox;
            return super.visit(filter, data);
        }
    }
}

