/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.Histogram;
import javax.media.jai.RasterFactory;
import javax.media.jai.remote.SerializableRenderedImage;
import net.sf.ehcache.Cache;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilder;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class Utils {
    public static final String INDEXER_PROPERTIES = "indexer.properties";
    private static Cache ehcache;
    public static final double[][] RGB_TO_GRAY_MATRIX;
    static final boolean OPTIMIZE_CROP;
    private static final Logger LOGGER;
    public static final String DEFAULT_WILCARD = "*.*";
    public static final boolean DEFAULT_PATH_BEHAVIOR = false;
    private static final boolean DEFAULT_CACHING_BEHAVIOR = false;
    public static final int DEFAULT_PRIORITY = 5;
    public static final String DEFAULT_LOCATION_ATTRIBUTE = "location";
    public static final String DEFAULT_INDEX_NAME = "index";
    public static final DataStoreFactorySpi SHAPE_SPI;
    static final String DIRECT_KAKADU_PLUGIN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";
    public static final boolean DEFAULT_RECURSION_BEHAVIOR = true;
    static final Color TRANSPARENT;
    static final Boolean IGNORE_FOOTPRINT;
    public static final boolean DEFAULT_FOOTPRINT_MANAGEMENT = true;
    public static final boolean DEFAULT_CONFIGURATION_CACHING = false;
    static final double SAMEBBOX_THRESHOLD_FACTOR = 20.0;
    static final double AFFINE_IDENTITY_EPS = 1.0E-6;
    public static final boolean DEFAULT_COLOR_EXPANSION_BEHAVIOR = false;
    public static final TimeZone UTC_TIME_ZONE;
    static final String DESCENDING_ORDER_IDENTIFIER = " D";
    static final String ASCENDING_ORDER_IDENTIFIER = " A";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createMosaic(String location, String indexName, String wildcard, boolean absolutePath, Hints hints) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setAbsolute(absolutePath);
        configuration.setHints(hints);
        configuration.setRootMosaicDirectory(location);
        configuration.setIndexingDirectories(Arrays.asList(location));
        configuration.setIndexName(indexName);
        CatalogBuilder catalogBuilder = new CatalogBuilder(configuration);
        final LinkedList exceptions = new LinkedList();
        try {
            CatalogBuilder.ProcessingEventListener listener = new CatalogBuilder.ProcessingEventListener(){

                @Override
                public void exceptionOccurred(CatalogBuilder.ExceptionEvent event) {
                    Exception t = event.getException();
                    exceptions.add(t);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                    }
                }

                @Override
                public void getNotification(CatalogBuilder.ProcessingEvent event) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(event.getMessage());
                    }
                }
            };
            catalogBuilder.addProcessingEventListener(listener);
            catalogBuilder.run();
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Unable to build mosaic", e);
            boolean bl = false;
            return bl;
        }
        finally {
            catalogBuilder.dispose();
        }
        return exceptions.size() <= 0;
    }

    public static String getMessageFromException(Exception exception) {
        if (exception.getLocalizedMessage() != null) {
            return exception.getLocalizedMessage();
        }
        return exception.getMessage();
    }

    static URL checkSource(Object source) throws MalformedURLException, DataSourceException {
        return Utils.checkSource(source, null);
    }

    static MosaicConfigurationBean loadMosaicProperties(URL sourceURL, String defaultLocationAttribute) {
        return Utils.loadMosaicProperties(sourceURL, defaultLocationAttribute, null);
    }

    static MosaicConfigurationBean loadMosaicProperties(URL sourceURL, String defaultLocationAttribute, Set<String> ignorePropertiesSet) {
        String[] pair;
        String[] pairs;
        Properties properties;
        boolean ignoreSome;
        MosaicConfigurationBean retValue;
        block33: {
            String bboxString;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Trying to load properties file from URL:" + sourceURL);
            }
            retValue = new MosaicConfigurationBean();
            ignoreSome = ignorePropertiesSet != null && !ignorePropertiesSet.isEmpty();
            URL propsURL = sourceURL;
            if (!sourceURL.toExternalForm().endsWith(".properties")) {
                propsURL = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
            }
            if ((properties = Utils.loadPropertiesFromURL(propsURL)) == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to load mosaic properties file");
                }
                return null;
            }
            pairs = null;
            pair = null;
            if (!(ignoreSome && ignorePropertiesSet.contains("Envelope2D") || (bboxString = properties.getProperty("Envelope2D", null)) == null)) {
                bboxString = bboxString.trim();
                try {
                    ReferencedEnvelope bbox = Utils.parseEnvelope(bboxString);
                    if (bbox != null) {
                        retValue.setEnvelope(bbox);
                    } else if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Cannot parse imposed bbox.");
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block33;
                    LOGGER.log(Level.INFO, "Cannot parse imposed bbox.", e);
                }
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Levels")) {
            int levelsNumber = Integer.parseInt(properties.getProperty("LevelsNum", "1").trim());
            retValue.setLevelsNum(levelsNumber);
            if (!properties.containsKey("Levels")) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Required key Levels not found.");
                }
                return null;
            }
            String levels = properties.getProperty("Levels").trim();
            pairs = levels.split(" ");
            if (pairs == null || pairs.length != levelsNumber) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Levels number is different from the provided number of levels resoltion.");
                }
                return null;
            }
            double[][] resolutions = new double[levelsNumber][2];
            for (int i = 0; i < levelsNumber; ++i) {
                pair = pairs[i].split(",");
                if (pair == null || pair.length != 2) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("OverviewLevel number is different from the provided number of levels resoltion.");
                    }
                    return null;
                }
                resolutions[i][0] = Double.parseDouble(pair[0]);
                resolutions[i][1] = Double.parseDouble(pair[1]);
            }
            retValue.setLevels(resolutions);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("TypeName")) {
            String typeName = properties.getProperty("TypeName", null);
            retValue.setTypeName(typeName);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("SuggestedSPI") || !properties.containsKey("SuggestedSPI"))) {
            String suggestedSPI = properties.getProperty("SuggestedSPI").trim();
            retValue.setSuggestedSPI(suggestedSPI);
        }
        if (properties.containsKey("TimeAttribute")) {
            String timeAttribute = properties.getProperty("TimeAttribute").trim();
            retValue.setTimeAttribute(timeAttribute);
        }
        if (properties.containsKey("ElevationAttribute")) {
            String elevationAttribute = properties.getProperty("ElevationAttribute").trim();
            retValue.setElevationAttribute(elevationAttribute);
        }
        if (properties.containsKey("Caching")) {
            String caching = properties.getProperty("Caching").trim();
            try {
                retValue.setCaching(Boolean.valueOf(caching));
            }
            catch (Throwable e) {
                retValue.setCaching(false);
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Name")) {
            if (!properties.containsKey("Name")) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Required key Name not found.");
                }
                return null;
            }
            String coverageName = properties.getProperty("Name").trim();
            retValue.setName(coverageName);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("ExpandToRGB")) {
            boolean expandMe = Boolean.valueOf(properties.getProperty("ExpandToRGB", "false").trim());
            retValue.setExpandToRGB(expandMe);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Heterogeneous")) {
            boolean heterogeneous = Boolean.valueOf(properties.getProperty("Heterogeneous", "false").trim());
            retValue.setHeterogeneous(heterogeneous);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AbsolutePath")) {
            boolean absolutePath = Boolean.valueOf(properties.getProperty("AbsolutePath", Boolean.toString(false)).trim());
            retValue.setAbsolutePath(absolutePath);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("FootprintManagement")) {
            boolean footprintManagement = Boolean.valueOf(properties.getProperty("FootprintManagement", "false").trim());
            retValue.setFootprintManagement(footprintManagement);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("LocationAttribute")) {
            retValue.setLocationAttribute(properties.getProperty("LocationAttribute", DEFAULT_LOCATION_ATTRIBUTE).trim());
        }
        return retValue;
    }

    public static ReferencedEnvelope parseEnvelope(String bboxString) {
        if (bboxString == null || bboxString.length() == 0) {
            return null;
        }
        String[] pairs = bboxString.split(" ");
        if (pairs != null && pairs.length == 2) {
            String[] pair1 = pairs[0].split(",");
            String[] pair2 = pairs[1].split(",");
            if (pair1 != null && pair1.length == 2 && pair2 != null && pair2.length == 2) {
                return new ReferencedEnvelope(Double.parseDouble(pair1[0]), Double.parseDouble(pair2[0]), Double.parseDouble(pair1[1]), Double.parseDouble(pair2[1]), null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadPropertiesFromURL(URL propsURL) {
        InputStream openStream;
        Properties properties;
        block13: {
            properties = new Properties();
            BufferedInputStream stream = null;
            openStream = null;
            try {
                openStream = propsURL.openStream();
                stream = new BufferedInputStream(openStream);
                properties.load(stream);
                if (stream == null) break block13;
            }
            catch (FileNotFoundException e) {
                Properties properties2;
                block14: {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    properties2 = null;
                    if (stream == null) break block14;
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                return properties2;
            }
            catch (IOException e2) {
                Properties properties3;
                block15: {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
                    }
                    properties3 = null;
                    if (stream == null) break block15;
                    {
                        catch (Throwable throwable) {
                            if (stream != null) {
                                IOUtils.closeQuietly(stream);
                            }
                            if (openStream != null) {
                                IOUtils.closeQuietly((InputStream)openStream);
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                return properties3;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (openStream != null) {
            IOUtils.closeQuietly((InputStream)openStream);
        }
        return properties;
    }

    public static IOFileFilter excludeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        for (IOFileFilter filter : filters) {
            retFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{retFilter, FileFilterUtils.notFileFilter((IOFileFilter)filter)});
        }
        return retFilter;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static Rectangle getDimension(int imageIndex, ImageReader reader) throws IOException {
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format((int)79, (Object)imageIndex));
        }
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    public static boolean checkFileReadable(File file) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String message = Utils.getFileInfo(file);
            LOGGER.fine(message);
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static String getFileInfo(File file) {
        StringBuilder builder = new StringBuilder();
        builder.append("Checking file:").append(FilenameUtils.getFullPath((String)file.getAbsolutePath())).append("\n");
        builder.append("isHidden:").append(file.isHidden()).append("\n");
        builder.append("exists:").append(file.exists()).append("\n");
        builder.append("isFile").append(file.isFile()).append("\n");
        builder.append("canRead:").append(file.canRead()).append("\n");
        builder.append("canWrite").append(file.canWrite()).append("\n");
        builder.append("canExecute:").append(file.canExecute()).append("\n");
        builder.append("isAbsolute:").append(file.isAbsolute()).append("\n");
        builder.append("lastModified:").append(file.lastModified()).append("\n");
        builder.append("length:").append(file.length());
        String message = builder.toString();
        return message;
    }

    public static String checkDirectory(String testingDirectory, boolean writable) throws IllegalArgumentException {
        boolean failure;
        File inDir = new File(testingDirectory);
        boolean bl = failure = !inDir.exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\n" + "location exists:" + inDir.exists() + "\n" + "location is a directory:" + inDir.isDirectory() + "\n" + "location is writable:" + inDir.canWrite() + "\n" + "location is readable:" + inDir.canRead() + "\n" + "location is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        try {
            testingDirectory = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        testingDirectory = FilenameUtils.normalize((String)testingDirectory);
        if (!testingDirectory.endsWith(File.separator)) {
            testingDirectory = testingDirectory + File.separator;
        }
        boolean bl2 = failure = !(inDir = new File(testingDirectory)).exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\n" + "location exists:" + inDir.exists() + "\n" + "location is a directory:" + inDir.isDirectory() + "\n" + "location is writable:" + inDir.canWrite() + "\n" + "location is readable:" + inDir.canRead() + "\n" + "location is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        return testingDirectory;
    }

    static boolean checkURLReadable(URL url) {
        try {
            url.openStream().close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(URL datastoreProperties) throws IOException {
        Properties properties = Utils.loadPropertiesFromURL(datastoreProperties);
        if (properties == null) {
            return null;
        }
        String SPIClass = properties.getProperty("SPI");
        try {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
            return Utils.createDataStoreParamsFromPropertiesFile(properties, spi);
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
        catch (InstantiationException e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
        catch (IllegalAccessException e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeSampleImage(File sampleImageFile, SampleModel defaultSM, ColorModel defaultCM) throws IOException {
        SampleModel sm = defaultSM.createCompatibleSampleModel(1, 1);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
        BufferedImage sampleImage = new BufferedImage(defaultCM, raster, false, null);
        BufferedOutputStream outStream = null;
        ObjectOutputStream ooStream = null;
        SerializableRenderedImage sri = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(sampleImageFile));
            ooStream = new ObjectOutputStream(outStream);
            sri = new SerializableRenderedImage((RenderedImage)sampleImage, true);
            ooStream.writeObject(sri);
        }
        finally {
            try {
                if (ooStream != null) {
                    ooStream.close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)ooStream);
            }
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            try {
                if (sri != null) {
                    sri.dispose();
                }
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderedImage loadSampleImage(File sampleImageFile) {
        InputStream inStream = null;
        ObjectInputStream oiStream = null;
        try {
            if (Utils.checkFileReadable(sampleImageFile)) {
                inStream = new BufferedInputStream(new FileInputStream(sampleImageFile));
                oiStream = new ObjectInputStream(inStream);
                RenderedImage renderedImage = (RenderedImage)oiStream.readObject();
                return renderedImage;
            }
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Unable to find sample image for path " + sampleImageFile);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        finally {
            block42: {
                block41: {
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block41;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (oiStream != null) {
                        oiStream.close();
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block42;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(Properties properties, DataStoreFactorySpi spi) throws IOException {
        DataAccessFactory.Param[] paramsInfo;
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
            if (properties.containsKey(p.key)) {
                params.put(p.key, (Serializable)Converters.convert(properties.getProperty(p.key), p.type));
                continue;
            }
            if (!p.required || p.sample != null) continue;
            throw new IOException("Required parameter missing: " + p.toString());
        }
        return params;
    }

    static URL checkSource(Object source, Hints hints) {
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = DataUtilities.fileToURL((File)sourceFile);
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile((URL)sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL((File)tempFile);
                sourceFile = tempFile;
            }
        }
        if (sourceFile != null) {
            if (!sourceFile.isDirectory()) {
                sourceURL = DataUtilities.fileToURL((File)sourceFile);
            } else {
                String locationPath = sourceFile.getAbsolutePath();
                String defaultIndexName = FilenameUtils.getName((String)locationPath);
                boolean datastoreFound = false;
                boolean buildMosaic = false;
                File dataStoreProperties = new File(locationPath, "datastore.properties");
                File[] properties = sourceFile.listFiles((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties"))}));
                if (Utils.checkFileReadable(dataStoreProperties)) {
                    datastoreFound = true;
                    boolean found = false;
                    for (File propFile : properties) {
                        if (!Utils.checkFileReadable(propFile) || null == Utils.loadMosaicProperties(DataUtilities.fileToURL((File)propFile), DEFAULT_LOCATION_ATTRIBUTE)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        buildMosaic = true;
                    }
                } else {
                    buildMosaic = true;
                    datastoreFound = false;
                }
                File shapeFile = null;
                if (!datastoreFound) {
                    for (File propFile : properties) {
                        if (null == Utils.loadMosaicProperties(DataUtilities.fileToURL((File)propFile), DEFAULT_LOCATION_ATTRIBUTE)) continue;
                        shapeFile = new File(locationPath, FilenameUtils.getBaseName((String)propFile.getName()) + ".shp");
                        if (!Utils.checkFileReadable(shapeFile) && Utils.checkFileReadable(propFile)) {
                            buildMosaic = true;
                            continue;
                        }
                        buildMosaic = false;
                        break;
                    }
                }
                if (buildMosaic) {
                    File mosaicDirectory = new File(locationPath);
                    if (!mosaicDirectory.exists() || mosaicDirectory.isFile() || !mosaicDirectory.canWrite()) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Unable to create the mosaic, check the location:\nlocation is:" + locationPath + "\n" + "location exists:" + mosaicDirectory.exists() + "\n" + "location is a directory:" + mosaicDirectory.isDirectory() + "\n" + "location is writable:" + mosaicDirectory.canWrite() + "\n" + "location is readable:" + mosaicDirectory.canRead() + "\n" + "location is hidden:" + mosaicDirectory.isHidden() + "\n");
                        }
                        return null;
                    }
                    Utils.createMosaic(locationPath, defaultIndexName, DEFAULT_WILCARD, false, hints);
                    File propertiesFile = new File(locationPath, defaultIndexName + ".properties");
                    if (!Utils.checkFileReadable(propertiesFile)) {
                        sourceURL = null;
                        return sourceURL;
                    }
                    sourceURL = !datastoreFound ? (!Utils.checkFileReadable(shapeFile = new File(locationPath, defaultIndexName + ".shp")) ? null : DataUtilities.fileToURL((File)shapeFile)) : (!Utils.checkFileReadable(dataStoreProperties = new File(locationPath, "datastore.properties")) ? null : DataUtilities.fileToURL((File)dataStoreProperties));
                } else {
                    sourceURL = datastoreFound ? DataUtilities.fileToURL((File)dataStoreProperties) : DataUtilities.fileToURL(shapeFile);
                }
            }
        }
        return sourceURL;
    }

    private Utils(Cache ehcache) {
        Utils.ehcache = ehcache;
    }

    /*
     * Exception decompiling
     */
    static Histogram getHistogram(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean areaIsDifferent(Geometry granuleFootprint, AffineTransform baseGridToWorld, ReferencedEnvelope granuleBBOX) {
        double bboxArea;
        Envelope envelope = granuleFootprint.getEnvelope().getEnvelopeInternal();
        double deltaMinX = Math.abs(envelope.getMinX() - granuleBBOX.getMinX());
        double deltaMinY = Math.abs(envelope.getMinY() - granuleBBOX.getMinY());
        double deltaMaxX = Math.abs(envelope.getMaxX() - granuleBBOX.getMaxX());
        double deltaMaxY = Math.abs(envelope.getMaxY() - granuleBBOX.getMaxY());
        double resX = XAffineTransform.getScaleX0((AffineTransform)baseGridToWorld);
        double resY = XAffineTransform.getScaleY0((AffineTransform)baseGridToWorld);
        double toleranceX = resX / 20.0;
        double toleranceY = resY / 20.0;
        double cellArea = resX * resY;
        if (deltaMinX > toleranceX || deltaMaxX > toleranceX || deltaMinY > toleranceY || deltaMaxY > toleranceY) {
            return true;
        }
        double footprintArea = granuleFootprint.getArea();
        return Math.abs(footprintArea - (bboxArea = granuleBBOX.getHeight() * granuleBBOX.getWidth())) > cellArea;
    }

    static Rectangle toRectangle(Shape shape) {
        int i;
        if (shape instanceof Rectangle) {
            return (Rectangle)shape;
        }
        if (shape == null) {
            return null;
        }
        PathIterator iter = shape.getPathIterator(new AffineTransform());
        double[] coords = new double[2];
        if (iter.isDone()) {
            return null;
        }
        iter.next();
        int action = iter.currentSegment(coords);
        if (action != 0 && action != 1) {
            return null;
        }
        double minx = coords[0];
        double miny = coords[1];
        double maxx = minx;
        double maxy = miny;
        double prevx = minx;
        double prevy = miny;
        for (i = 0; i < 4 && !iter.isDone(); ++i) {
            iter.next();
            action = iter.currentSegment(coords);
            if (action == 4) break;
            if (action != 1) {
                return null;
            }
            double x = coords[0];
            double y = coords[1];
            if (!(prevx == x && prevy != y || prevx != x && prevy == y)) {
                return null;
            }
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            if (y < miny) {
                miny = y;
            } else if (y > maxy) {
                maxy = y;
            }
            prevx = x;
            prevy = y;
        }
        iter.next();
        if (!iter.isDone() || i != 3) {
            return null;
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny).getBounds();
    }

    static {
        RGB_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0}};
        String prop = System.getProperty("org.geotools.imagemosaic.optimizecrop");
        OPTIMIZE_CROP = prop == null || !prop.equalsIgnoreCase("FALSE");
        LOGGER = Logging.getLogger((String)Utils.class.toString());
        SHAPE_SPI = new ShapefileDataStoreFactory();
        TRANSPARENT = new Color(0, 0, 0, 0);
        IGNORE_FOOTPRINT = Boolean.getBoolean("org.geotools.footprint.ignore");
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    }

    public static class Prop {
        public static final String LOCATION_ATTRIBUTE = "LocationAttribute";
        public static final String ENVELOPE2D = "Envelope2D";
        public static final String LEVELS_NUM = "LevelsNum";
        public static final String LEVELS = "Levels";
        public static final String SUGGESTED_SPI = "SuggestedSPI";
        public static final String EXP_RGB = "ExpandToRGB";
        public static final String ABSOLUTE_PATH = "AbsolutePath";
        public static final String NAME = "Name";
        public static final String FOOTPRINT_MANAGEMENT = "FootprintManagement";
        public static final String HETEROGENEOUS = "Heterogeneous";
        public static final String TIME_ATTRIBUTE = "TimeAttribute";
        public static final String ELEVATION_ATTRIBUTE = "ElevationAttribute";
        public static final String TYPENAME = "TypeName";
        public static final String PATH_TYPE = "PathType";
        public static final String PARENT_LOCATION = "ParentLocation";
        public static final String RECURSIVE = "Recursive";
        public static final String WILDCARD = "Wildcard";
        public static final String SCHEMA = "Schema";
        public static final String RESOLUTION_LEVELS = "ResolutionLevels";
        public static final String PROPERTY_COLLECTORS = "PropertyCollectors";
        public static final String CACHING = "Caching";
    }
}

