/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Geometry;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ROI;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.ReadParamsController;
import org.geotools.gce.imagemosaic.ReadType;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.jai.Registry;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.jaitools.imageutils.ROIGeometry;
import org.jaitools.media.jai.vectorbinarize.VectorBinarizeDescriptor;
import org.jaitools.media.jai.vectorbinarize.VectorBinarizeRIF;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class GranuleDescriptor {
    private static final Logger LOGGER;
    OverviewsController overviewsController;
    ReferencedEnvelope granuleBBOX;
    ROIGeometry granuleROIShape;
    Geometry inclusionGeometry;
    URL granuleUrl;
    int maxDecimationFactor = -1;
    final Map<Integer, GranuleOverviewLevelDescriptor> granuleLevels = Collections.synchronizedMap(new HashMap());
    AffineTransform baseGridToWorld;
    ImageReaderSpi cachedReaderSPI;
    SimpleFeature originator;
    boolean handleArtifactsFiltering = false;
    boolean filterMe = false;
    ImageInputStreamSpi cachedStreamSPI;

    private void init(BoundingBox granuleBBOX, URL granuleUrl, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry, boolean heterogeneousGranules) {
        this.init(granuleBBOX, granuleUrl, suggestedSPI, inclusionGeometry, heterogeneousGranules, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(BoundingBox granuleBBOX, URL granuleUrl, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry, boolean heterogeneousGranules, boolean handleArtifactsFiltering) {
        this.granuleBBOX = ReferencedEnvelope.reference(granuleBBOX);
        this.granuleUrl = granuleUrl;
        this.inclusionGeometry = inclusionGeometry;
        this.handleArtifactsFiltering = handleArtifactsFiltering;
        this.filterMe = handleArtifactsFiltering && inclusionGeometry != null;
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            if (this.cachedStreamSPI == null) {
                this.cachedStreamSPI = ImageIOExt.getImageInputStreamSPI((Object)granuleUrl, (boolean)true);
                if (this.cachedStreamSPI == null) {
                    File file = DataUtilities.urlToFile((URL)granuleUrl);
                    if (file == null) throw new IllegalArgumentException("Unable to get an input stream for the provided granule " + granuleUrl.toString());
                    if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException("Unable to get an input stream for the provided granule " + granuleUrl.toString());
                    LOGGER.log(Level.WARNING, Utils.getFileInfo(file));
                    throw new IllegalArgumentException("Unable to get an input stream for the provided granule " + granuleUrl.toString());
                }
            }
            assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
            inStream = this.cachedStreamSPI.createInputStreamInstance(granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            if (inStream == null) {
                File file = DataUtilities.urlToFile((URL)granuleUrl);
                if (file == null) throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
                if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
                LOGGER.log(Level.WARNING, Utils.getFileInfo(file));
                throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
            }
            if (this.cachedReaderSPI == null) {
                inStream.mark();
                if (suggestedSPI != null && suggestedSPI.canDecodeInput(inStream)) {
                    this.cachedReaderSPI = suggestedSPI;
                    inStream.reset();
                } else {
                    inStream.mark();
                    reader = ImageIOExt.getImageioReader((ImageInputStream)inStream);
                    if (reader != null) {
                        this.cachedReaderSPI = reader.getOriginatingProvider();
                    }
                    inStream.reset();
                }
            }
            if ((reader = this.cachedReaderSPI.createReaderInstance()) == null) {
                throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + granuleUrl.toString());
            }
            reader.setInput(inStream);
            Rectangle originalDimension = Utils.getDimension(0, reader);
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(originalDimension), (Envelope)granuleBBOX);
            geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
            this.baseGridToWorld = geMapper.createAffineTransform();
            try {
                if (inclusionGeometry != null) {
                    geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
                    Geometry mapped = JTS.transform(inclusionGeometry, geMapper.createTransform().inverse());
                    this.granuleROIShape = new ROIGeometry(mapped);
                }
            }
            catch (TransformException e1) {
                throw new IllegalArgumentException(e1);
            }
            this.granuleLevels.put(0, new GranuleOverviewLevelDescriptor(1.0, 1.0, originalDimension.width, originalDimension.height));
            if (!heterogeneousGranules) return;
            GranuleOverviewLevelDescriptor baseOverviewLevelDescriptor = this.granuleLevels.get(0);
            int numberOfOvervies = reader.getNumImages(true) - 1;
            AffineTransform2D baseG2W = baseOverviewLevelDescriptor.getGridToWorldTransform();
            int width = baseOverviewLevelDescriptor.getWidth();
            int height = baseOverviewLevelDescriptor.getHeight();
            double resX = AffineTransform2D.getScaleX0((AffineTransform)baseG2W);
            double resY = AffineTransform2D.getScaleY0((AffineTransform)baseG2W);
            double[] highestRes = new double[]{resX, resY};
            double[][] overviewsResolution = new double[numberOfOvervies][2];
            for (int i = 0; i < numberOfOvervies; ++i) {
                overviewsResolution[i][0] = highestRes[0] * (double)width / (double)reader.getWidth(i + 1);
                overviewsResolution[i][1] = highestRes[1] * (double)height / (double)reader.getWidth(i + 1);
            }
            this.overviewsController = new OverviewsController(highestRes, numberOfOvervies, overviewsResolution);
            return;
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry) {
        this(granuleLocation, granuleBBox, suggestedSPI, inclusionGeometry, -1, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry, boolean heterogeneousGranules) {
        this(granuleLocation, granuleBBox, suggestedSPI, inclusionGeometry, -1, heterogeneousGranules);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry, int maxDecimationFactor) {
        this(granuleLocation, granuleBBox, suggestedSPI, inclusionGeometry, maxDecimationFactor, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry, int maxDecimationFactor, boolean heterogeneousGranules) {
        this(granuleLocation, granuleBBox, suggestedSPI, inclusionGeometry, maxDecimationFactor, heterogeneousGranules, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry, int maxDecimationFactor, boolean heterogeneousGranules, boolean handleArtifactsFiltering) {
        this.maxDecimationFactor = maxDecimationFactor;
        URL rasterFile = DataUtilities.fileToURL((File)new File(granuleLocation));
        if (rasterFile == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("File found " + granuleLocation);
        }
        this.originator = null;
        this.init(granuleBBox, rasterFile, suggestedSPI, inclusionGeometry, heterogeneousGranules, handleArtifactsFiltering);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, PathType pathType, String locationAttribute, String parentLocation) {
        this(feature, suggestedSPI, pathType, locationAttribute, parentLocation, false);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, PathType pathType, String locationAttribute, String parentLocation, boolean heterogeneousGranules) {
        this(feature, suggestedSPI, pathType, locationAttribute, parentLocation, null, heterogeneousGranules);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, PathType pathType, String locationAttribute, String parentLocation, Geometry inclusionGeometry) {
        this(feature, suggestedSPI, pathType, locationAttribute, parentLocation, inclusionGeometry, false);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, PathType pathType, String locationAttribute, String parentLocation, Geometry inclusionGeometry, boolean heterogeneousGranules) {
        String granuleLocation = (String)feature.getAttribute(locationAttribute);
        ReferencedEnvelope granuleBBox = ReferencedEnvelope.reference(feature.getBounds());
        URL rasterFile = pathType.resolvePath(parentLocation, granuleLocation);
        if (rasterFile == null) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"granuleLocation", (Object)granuleLocation));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File found " + granuleLocation);
        }
        this.originator = feature;
        this.init(granuleBBox, rasterFile, suggestedSPI, inclusionGeometry, heterogeneousGranules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GranuleLoadingResult loadRaster(ImageReadParam imageReadParameters, int index, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, RasterLayerRequest request, Hints hints) throws IOException {
        GranuleLoadingResult granuleLoadingResult;
        ReferencedEnvelope intersection;
        if (LOGGER.isLoggable(Level.FINER)) {
            String name = Thread.currentThread().getName();
            LOGGER.finer("Thread:" + name + " Loading raster data for granuleDescriptor " + this.toString());
        }
        ImageReadParam readParameters = null;
        ReferencedEnvelope bbox = this.inclusionGeometry != null ? new ReferencedEnvelope(this.granuleBBOX.intersection(this.inclusionGeometry.getEnvelopeInternal()), this.granuleBBOX.getCoordinateReferenceSystem()) : this.granuleBBOX;
        boolean doFiltering = false;
        if (this.filterMe) {
            doFiltering = Utils.areaIsDifferent(this.inclusionGeometry, this.baseGridToWorld, this.granuleBBOX);
        }
        if ((intersection = new ReferencedEnvelope(bbox.intersection(cropBBox), cropBBox.getCoordinateReferenceSystem())).isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
            }
            return null;
        }
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            Object extender;
            Object scheduler;
            Object cache;
            Object layout;
            Object tx2;
            RenderedImage raster;
            int ssy;
            int ssx;
            int imageIndex;
            assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
            inStream = this.cachedStreamSPI.createInputStreamInstance(this.granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            if (inStream == null) {
                GranuleLoadingResult granuleLoadingResult2 = null;
                return granuleLoadingResult2;
            }
            if (this.cachedReaderSPI == null) {
                reader = ImageIOExt.getImageioReader((ImageInputStream)inStream);
                if (reader != null) {
                    this.cachedReaderSPI = reader.getOriginatingProvider();
                }
            } else {
                reader = this.cachedReaderSPI.createReaderInstance();
            }
            if (reader == null) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to get s reader for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                }
                GranuleLoadingResult granuleLoadingResult3 = null;
                return granuleLoadingResult3;
            }
            reader.setInput(inStream);
            if (request.isHeterogeneousGranules()) {
                readParameters = new ImageReadParam();
                imageIndex = ReadParamsController.setReadParams(request.getRequestedResolution(), request.getOverviewPolicy(), request.getDecimationPolicy(), readParameters, request.rasterManager, this.overviewsController);
            } else {
                imageIndex = index;
                readParameters = imageReadParameters;
            }
            GranuleOverviewLevelDescriptor selectedlevel = this.getLevel(imageIndex, reader);
            AffineTransform2D cropWorldToGrid = new AffineTransform2D((AffineTransform)selectedlevel.gridToWorldTransformCorner);
            cropWorldToGrid = (AffineTransform2D)cropWorldToGrid.inverse();
            Rectangle sourceArea = CRS.transform((MathTransform)cropWorldToGrid, (Envelope)intersection).toRectangle2D().getBounds();
            if (selectedlevel.baseToLevelTransform.isIdentity()) {
                sourceArea.grow(2, 2);
            }
            XRectangle2D.intersect((Rectangle2D)sourceArea, (Rectangle2D)selectedlevel.rasterDimensions, (Rectangle2D)sourceArea);
            if (sourceArea.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Got empty area for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                }
                GranuleLoadingResult granuleLoadingResult4 = null;
                return granuleLoadingResult4;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Loading level " + imageIndex + " with source region: " + sourceArea + " subsampling: " + readParameters.getSourceXSubsampling() + "," + readParameters.getSourceYSubsampling() + " for granule:" + this.granuleUrl);
            }
            int newSubSamplingFactor = 0;
            String pluginName = this.cachedReaderSPI.getPluginClassName();
            if (pluginName != null && pluginName.equals("it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader") && (newSubSamplingFactor = ImageIOUtilities.getSubSamplingFactor2((int)(ssx = readParameters.getSourceXSubsampling()), (int)(ssy = readParameters.getSourceYSubsampling()))) != 0) {
                if (newSubSamplingFactor > this.maxDecimationFactor && this.maxDecimationFactor != -1) {
                    newSubSamplingFactor = this.maxDecimationFactor;
                }
                readParameters.setSourceSubsampling(newSubSamplingFactor, newSubSamplingFactor, 0, 0);
            }
            readParameters.setSourceRegion(sourceArea);
            try {
                raster = request.getReadType().read(readParameters, imageIndex, this.granuleUrl, selectedlevel.rasterDimensions, reader, hints, false);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
                }
                GranuleLoadingResult granuleLoadingResult5 = null;
                try {
                    if (request.getReadType() != ReadType.JAI_IMAGEREAD && inStream != null) {
                        inStream.close();
                    }
                }
                finally {
                    if (request.getReadType() != ReadType.JAI_IMAGEREAD && reader != null) {
                        reader.dispose();
                    }
                }
                return granuleLoadingResult5;
            }
            sourceArea.setRect(readParameters.getSourceRegion());
            double decimationScaleX = 1.0 * (double)sourceArea.width / (double)raster.getWidth();
            double decimationScaleY = 1.0 * (double)sourceArea.height / (double)raster.getHeight();
            AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance((double)decimationScaleX, (double)decimationScaleY);
            AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance((double)sourceArea.x, (double)sourceArea.y);
            AffineTransform2D backToBaseLevelScaleTransform = selectedlevel.baseToLevelTransform;
            AffineTransform finalRaster2Model = new AffineTransform(this.baseGridToWorld);
            finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            double x = finalRaster2Model.getTranslateX();
            double y = finalRaster2Model.getTranslateY();
            if (!XAffineTransform.isIdentity((AffineTransform)backToBaseLevelScaleTransform, (double)1.0E-6)) {
                finalRaster2Model.concatenate((AffineTransform)backToBaseLevelScaleTransform);
            }
            if (!XAffineTransform.isIdentity((AffineTransform)afterDecimationTranslateTranform, (double)1.0E-6)) {
                finalRaster2Model.concatenate(afterDecimationTranslateTranform);
            }
            if (!XAffineTransform.isIdentity((AffineTransform)decimationScaleTranform, (double)1.0E-6)) {
                finalRaster2Model.concatenate(decimationScaleTranform);
            }
            finalRaster2Model.preConcatenate((AffineTransform)mosaicWorldToGrid);
            Interpolation interpolation = request.getInterpolation();
            Rectangle2D finalLayout = ImageUtilities.layoutHelper((RenderedImage)raster, (float)((float)finalRaster2Model.getScaleX()), (float)((float)finalRaster2Model.getScaleY()), (float)((float)finalRaster2Model.getTranslateX()), (float)((float)finalRaster2Model.getTranslateY()), (Interpolation)interpolation);
            if (finalLayout.isEmpty()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug creating a null source area");
                }
                GranuleLoadingResult granuleLoadingResult6 = null;
                return granuleLoadingResult6;
            }
            ROI granuleLoadingShape = null;
            if (this.granuleROIShape != null) {
                Point2D translate = mosaicWorldToGrid.transform((Point2D)new DirectPosition2D(x, y), (Point2D)null);
                tx2 = new AffineTransform();
                ((AffineTransform)tx2).preConcatenate(AffineTransform.getScaleInstance(((AffineTransform)mosaicWorldToGrid).getScaleX(), -((AffineTransform)mosaicWorldToGrid).getScaleY()));
                ((AffineTransform)tx2).preConcatenate(AffineTransform.getScaleInstance(this.baseGridToWorld.getScaleX(), -this.baseGridToWorld.getScaleY()));
                ((AffineTransform)tx2).preConcatenate(AffineTransform.getTranslateInstance(translate.getX(), translate.getY()));
                granuleLoadingShape = this.granuleROIShape.transform((AffineTransform)tx2);
            }
            RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, interpolation instanceof InterpolationNearest ? Boolean.FALSE : Boolean.TRUE);
            if (XAffineTransform.isIdentity((AffineTransform)finalRaster2Model, (double)1.0E-6)) {
                tx2 = new GranuleLoadingResult(raster, granuleLoadingShape, this.granuleUrl, doFiltering);
                return tx2;
            }
            Dimension tileDimensions = request.getTileDimensions();
            if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
                layout = new ImageLayout();
                layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            } else if (hints != null && hints.containsKey((Object)JAI.KEY_IMAGE_LAYOUT) && (layout = hints.get((Object)JAI.KEY_IMAGE_LAYOUT)) != null && layout instanceof ImageLayout) {
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout.clone()));
            }
            if (hints != null && hints.containsKey((Object)JAI.KEY_TILE_CACHE) && (cache = hints.get((Object)JAI.KEY_TILE_CACHE)) != null && cache instanceof TileCache) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, (TileCache)cache));
            }
            if (hints != null && hints.containsKey((Object)JAI.KEY_TILE_SCHEDULER) && (scheduler = hints.get((Object)JAI.KEY_TILE_SCHEDULER)) != null && scheduler instanceof TileScheduler) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, (TileScheduler)scheduler));
            }
            boolean addBorderExtender = true;
            if (hints != null && hints.containsKey((Object)JAI.KEY_BORDER_EXTENDER) && (extender = hints.get((Object)JAI.KEY_BORDER_EXTENDER)) != null && extender instanceof BorderExtender) {
                localHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, (BorderExtender)extender));
                addBorderExtender = false;
            }
            if (addBorderExtender) {
                localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
            }
            ImageWorker iw = new ImageWorker(raster);
            iw.setRenderingHints(localHints);
            iw.affine(finalRaster2Model, interpolation, request.getBackgroundValues());
            GranuleLoadingResult granuleLoadingResult7 = new GranuleLoadingResult(iw.getRenderedImage(), granuleLoadingShape, this.granuleUrl, doFiltering);
            return granuleLoadingResult7;
        }
        catch (IllegalStateException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
            }
            granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        catch (NoninvertibleTransformException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
            }
            granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
            }
            granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        finally {
            try {
                if (request.getReadType() != ReadType.JAI_IMAGEREAD && inStream != null) {
                    inStream.close();
                }
            }
            finally {
                if (request.getReadType() != ReadType.JAI_IMAGEREAD && reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    private GranuleOverviewLevelDescriptor getLevel(int index, ImageReader reader) {
        if (reader == null) {
            throw new NullPointerException("Null reader passed to the internal GranuleOverviewLevelDescriptor method");
        }
        Map<Integer, GranuleOverviewLevelDescriptor> map = this.granuleLevels;
        synchronized (map) {
            if (this.granuleLevels.containsKey(index)) {
                return this.granuleLevels.get(index);
            }
            try {
                Rectangle levelDimension = Utils.getDimension(index, reader);
                GranuleOverviewLevelDescriptor baseLevel = this.granuleLevels.get(0);
                double scaleX = (double)baseLevel.width / (1.0 * (double)levelDimension.width);
                double scaleY = (double)baseLevel.height / (1.0 * (double)levelDimension.height);
                GranuleOverviewLevelDescriptor newLevel = new GranuleOverviewLevelDescriptor(scaleX, scaleY, levelDimension.width, levelDimension.height);
                this.granuleLevels.put(index, newLevel);
                return newLevel;
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GranuleOverviewLevelDescriptor getLevel(int index) {
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
            inStream = this.cachedStreamSPI.createInputStreamInstance(this.granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            if (inStream == null) {
                throw new IllegalArgumentException("Unable to create an inputstream for the granuleurl:" + (this.granuleUrl != null ? this.granuleUrl : "null"));
            }
            if (this.cachedReaderSPI == null) {
                reader = ImageIOExt.getImageioReader((ImageInputStream)inStream);
                if (reader != null) {
                    this.cachedReaderSPI = reader.getOriginatingProvider();
                }
            } else {
                reader = this.cachedReaderSPI.createReaderInstance();
            }
            if (reader == null) {
                throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + this.granuleUrl.toString());
            }
            reader.setInput(inStream);
            return this.getLevel(index, reader);
        }
        catch (IllegalStateException e) {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable ee) {
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable ee) {
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Description of a granuleDescriptor ").append("\n");
        buffer.append("BBOX:\t\t").append(this.granuleBBOX.toString());
        buffer.append("file:\t\t").append(this.granuleUrl);
        buffer.append("gridToWorld:\t\t").append(this.baseGridToWorld);
        int i = 1;
        for (GranuleOverviewLevelDescriptor granuleOverviewLevelDescriptor : this.granuleLevels.values()) {
            int n = ++i;
            ++i;
            buffer.append("Description of level ").append(n).append("\n");
            buffer.append(granuleOverviewLevelDescriptor.toString()).append("\n");
        }
        return buffer.toString();
    }

    public BoundingBox getGranuleBBOX() {
        return this.granuleBBOX;
    }

    public URL getGranuleUrl() {
        return this.granuleUrl;
    }

    public SimpleFeature getOriginator() {
        return this.originator;
    }

    static {
        block2: {
            LOGGER = Logging.getLogger(GranuleDescriptor.class);
            try {
                Registry.registerRIF((JAI)JAI.getDefaultInstance(), (OperationDescriptor)new VectorBinarizeDescriptor(), (RenderedImageFactory)new VectorBinarizeRIF(), (String)"org.jaitools.media.jai");
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage());
            }
        }
    }

    static class GranuleLoadingResult {
        RenderedImage loadedImage;
        ROI footprint;
        URL granuleUrl;
        boolean doFiltering;

        public ROI getFootprint() {
            return this.footprint;
        }

        public RenderedImage getRaster() {
            return this.loadedImage;
        }

        public URL getGranuleUrl() {
            return this.granuleUrl;
        }

        public boolean isDoFiltering() {
            return this.doFiltering;
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint) {
            this(loadedImage, footprint, null);
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint, URL granuleUrl) {
            this(loadedImage, footprint, granuleUrl, false);
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint, URL granuleUrl, boolean doFiltering) {
            this.loadedImage = loadedImage;
            this.footprint = footprint;
            this.granuleUrl = granuleUrl;
            this.doFiltering = doFiltering;
        }
    }

    class GranuleOverviewLevelDescriptor {
        final double scaleX;
        final double scaleY;
        final int width;
        final int height;
        final AffineTransform2D baseToLevelTransform;
        final AffineTransform2D gridToWorldTransformCorner;
        final Rectangle rasterDimensions;

        public AffineTransform getBaseToLevelTransform() {
            return this.baseToLevelTransform;
        }

        public double getScaleX() {
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public GranuleOverviewLevelDescriptor(double scaleX, double scaleY, int width, int height) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.baseToLevelTransform = new AffineTransform2D(XAffineTransform.getScaleInstance((double)scaleX, (double)scaleY, (double)0.0, (double)0.0));
            AffineTransform gridToWorldTransform_ = new AffineTransform((AffineTransform)this.baseToLevelTransform);
            gridToWorldTransform_.preConcatenate(CoverageUtilities.CENTER_TO_CORNER);
            gridToWorldTransform_.preConcatenate(GranuleDescriptor.this.baseGridToWorld);
            this.gridToWorldTransformCorner = new AffineTransform2D(gridToWorldTransform_);
            this.width = width;
            this.height = height;
            this.rasterDimensions = new Rectangle(0, 0, width, height);
        }

        public Rectangle getBounds() {
            return (Rectangle)this.rasterDimensions.clone();
        }

        public AffineTransform2D getGridToWorldTransform() {
            return this.gridToWorldTransformCorner;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Description of a granuleDescriptor level").append("\n").append("width:\t\t").append(this.width).append("\n").append("height:\t\t").append(this.height).append("\n").append("scaleX:\t\t").append(this.scaleX).append("\n").append("scaleY:\t\t").append(this.scaleY).append("\n").append("baseToLevelTransform:\t\t").append(this.baseToLevelTransform.toString()).append("\n").append("gridToWorldTransform:\t\t").append(this.gridToWorldTransformCorner.toString()).append("\n");
            return buffer.toString();
        }
    }
}

